/*
 * Decompiled with CFR 0.152.
 */
package filewatcher;

import filewatcher.FileWatcher;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Program;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a6\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\b0\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u0010\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u0004\u001a6\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0004\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u0002H\b0\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00130\u000e\u001a9\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\u0004\b\u0000\u0010\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\b0\u000eH\u0007\u00a2\u0006\u0002\b\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00170\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!\"!\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010#\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "watchers", "", "Lkotlin/Function0;", "", "Lfilewatcher/FileWatcher;", "watchFile", "T", "program", "Lorg/openrndr/Program;", "file", "Ljava/io/File;", "transducer", "Lkotlin/Function1;", "stop", "", "triggerChange", "watch", "R", "programWatchFile", "watching", "Ljava/nio/file/Path;", "", "pathKeys", "Ljava/nio/file/WatchKey;", "keyPaths", "waiting", "Lkotlinx/coroutines/Job;", "watchService", "Ljava/nio/file/WatchService;", "kotlin.jvm.PlatformType", "getWatchService", "()Ljava/nio/file/WatchService;", "watchService$delegate", "Lkotlin/Lazy;", "watchThread", "Ljava/lang/Thread;", "getWatchThread$annotations", "()V", "getWatchThread", "()Ljava/lang/Thread;", "watchThread$delegate", "deminityy"})
@SourceDebugExtension(value={"SMAP\nFileWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatcher.kt\nfilewatcher/FileWatcherKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1863#2,2:145\n*S KotlinDebug\n*F\n+ 1 FileWatcher.kt\nfilewatcher/FileWatcherKt\n*L\n126#1:145,2\n*E\n"})
public final class FileWatcherKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(FileWatcherKt::logger$lambda$0);
    @NotNull
    private static final Map<Function0<Object>, FileWatcher> watchers = new LinkedHashMap();
    @NotNull
    private static final Map<Path, List<FileWatcher>> watching = new LinkedHashMap();
    @NotNull
    private static final Map<Path, WatchKey> pathKeys = new LinkedHashMap();
    @NotNull
    private static final Map<WatchKey, Path> keyPaths = new LinkedHashMap();
    @NotNull
    private static final Map<Path, Job> waiting = new LinkedHashMap();
    @NotNull
    private static final Lazy watchService$delegate = LazyKt.lazy(FileWatcherKt::watchService_delegate$lambda$7);
    @NotNull
    private static final Lazy watchThread$delegate = LazyKt.lazy(FileWatcherKt::watchThread_delegate$lambda$11);

    @NotNull
    public static final <T> Function0<T> watchFile(@NotNull Program program2, @NotNull File file, @NotNull Function1<? super File, ? extends T> transducer) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(transducer, "transducer");
        if (!file.exists()) {
            boolean $i$a$-require-FileWatcherKt$watchFile$22 = false;
            String $i$a$-require-FileWatcherKt$watchFile$22 = "'" + file.getAbsolutePath() + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-FileWatcherKt$watchFile$22.toString());
        }
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = transducer.invoke(file);
        FileWatcher watcher = new FileWatcher(program2, file, arg_0 -> FileWatcherKt.watchFile$lambda$3(result, transducer, file, arg_0));
        Function0<Object> function2 = () -> FileWatcherKt.watchFile$lambda$4(result);
        Intrinsics.checkNotNull(function2, "null cannot be cast to non-null type kotlin.Function0<kotlin.Any>");
        watchers.put((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function2, 0), watcher);
        return function2;
    }

    public static final <T> void stop(@NotNull Function0<? extends T> $this$stop) {
        block0: {
            Intrinsics.checkNotNullParameter($this$stop, "<this>");
            FileWatcher fileWatcher = watchers.get((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity($this$stop, 0));
            if (fileWatcher == null) break block0;
            fileWatcher.stop();
        }
    }

    public static final <T> void triggerChange(@NotNull Function0<? extends T> $this$triggerChange) {
        block0: {
            Intrinsics.checkNotNullParameter($this$triggerChange, "<this>");
            FileWatcher fileWatcher = watchers.get((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity($this$triggerChange, 0));
            if (fileWatcher == null) break block0;
            fileWatcher.triggerChange$deminityy();
        }
    }

    @NotNull
    public static final <T, R> Function0<R> watch(@NotNull Function0<? extends T> $this$watch, @NotNull Function1<? super T, ? extends R> transducer) {
        Intrinsics.checkNotNullParameter($this$watch, "<this>");
        Intrinsics.checkNotNullParameter(transducer, "transducer");
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = transducer.invoke($this$watch.invoke());
        FileWatcher fileWatcher = watchers.get((Function0)TypeIntrinsics.beforeCheckcastToFunctionOfArity($this$watch, 0));
        if (fileWatcher == null) {
            throw new IllegalStateException(("watcher '" + $this$watch + "' not found").toString());
        }
        fileWatcher.getWatchers().add(() -> FileWatcherKt.watch$lambda$5(result, transducer, $this$watch));
        return () -> FileWatcherKt.watch$lambda$6(result);
    }

    @JvmName(name="programWatchFile")
    @NotNull
    public static final <T> Function0<T> programWatchFile(@NotNull Program $this$watchFile, @NotNull File file, @NotNull Function1<? super File, ? extends T> transducer) {
        Intrinsics.checkNotNullParameter($this$watchFile, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(transducer, "transducer");
        return FileWatcherKt.watchFile($this$watchFile, file, transducer);
    }

    private static final WatchService getWatchService() {
        Lazy lazy = watchService$delegate;
        return (WatchService)lazy.getValue();
    }

    private static final Thread getWatchThread() {
        Lazy lazy = watchThread$delegate;
        return (Thread)lazy.getValue();
    }

    private static /* synthetic */ void getWatchThread$annotations() {
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object watchFile$lambda$3$lambda$2() {
        return "exception while transducing file";
    }

    private static final Unit watchFile$lambda$3(Ref.ObjectRef $result, Function1 $transducer, File $file, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        try {
            $result.element = $transducer.invoke($file);
        }
        catch (Throwable e) {
            logger.error(e, FileWatcherKt::watchFile$lambda$3$lambda$2);
        }
        return Unit.INSTANCE;
    }

    private static final Object watchFile$lambda$4(Ref.ObjectRef $result) {
        return $result.element;
    }

    private static final Unit watch$lambda$5(Ref.ObjectRef $result, Function1 $transducer, Function0 $this_watch) {
        $result.element = $transducer.invoke($this_watch.invoke());
        return Unit.INSTANCE;
    }

    private static final Object watch$lambda$6(Ref.ObjectRef $result) {
        return $result.element;
    }

    private static final WatchService watchService_delegate$lambda$7() {
        return FileSystems.getDefault().newWatchService();
    }

    private static final Unit watchThread_delegate$lambda$11$lambda$10() {
        while (true) {
            WatchKey key = FileWatcherKt.getWatchService().take();
            Path path = keyPaths.get(key);
            List<WatchEvent<?>> list = key.pollEvents();
            Intrinsics.checkNotNullExpressionValue(list, "pollEvents(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path fullPath;
                WatchEvent it = (WatchEvent)element$iv;
                boolean bl = false;
                Object t = it.context();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type java.nio.file.Path");
                Path contextPath = (Path)t;
                Path path2 = path;
                Path path3 = fullPath = path2 != null ? path2.resolve(contextPath) : null;
                if (fullPath == null) continue;
                boolean bl2 = false;
                Job job = waiting.get(fullPath);
                if (job != null) {
                    Job.DefaultImpls.cancel$default(job, null, 1, null);
                }
                waiting.put(fullPath, BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(fullPath, null){
                    int label;
                    final /* synthetic */ Path $fullPath;
                    {
                        this.$fullPath = $fullPath;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay(100L, this);
                                if (v0 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                v1 = (List)FileWatcherKt.access$getWatching$p().get(this.$fullPath);
                                if (v1 != null) {
                                    $this$forEach$iv = v1;
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        w = (FileWatcher)element$iv;
                                        $i$a$-forEach-FileWatcherKt$watchThread$2$1$1$1$1$1 = false;
                                        w.triggerChange$deminityy();
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null));
            }
            key.reset();
        }
    }

    private static final Thread watchThread_delegate$lambda$11() {
        return ThreadsKt.thread$default(false, true, null, null, 0, FileWatcherKt::watchThread_delegate$lambda$11$lambda$10, 29, null);
    }

    public static final /* synthetic */ Map access$getPathKeys$p() {
        return pathKeys;
    }

    public static final /* synthetic */ Thread access$getWatchThread() {
        return FileWatcherKt.getWatchThread();
    }

    public static final /* synthetic */ Map access$getWatching$p() {
        return watching;
    }

    public static final /* synthetic */ Map access$getKeyPaths$p() {
        return keyPaths;
    }

    public static final /* synthetic */ WatchService access$getWatchService() {
        return FileWatcherKt.getWatchService();
    }
}

