/*
 * Decompiled with CFR 0.152.
 */
package demo.view.renderers;

import demo.model.Demo;
import demo.model.Layer;
import demo.view.AssetLoader;
import demo.view.IObjectView;
import demo.view.LayerRenderer;
import demo.view.LayerRendererException;
import demo.view.LayerView;
import demo.view.ObjectRenderer;
import demo.view.ObjectView;
import demo.view.PaintView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import org.openrndr.Program;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.extra.mesh.MeshData;
import org.openrndr.extra.mesh.WireframeKt;
import org.openrndr.extra.objloader.OBJLoaderKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Path3D;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u001dR\u00020\u001eH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldemo/view/renderers/WireframeRenderer;", "Ldemo/view/ObjectRenderer;", "<init>", "()V", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "program$delegate", "Lkotlin/Lazy;", "demo", "Ldemo/model/Demo;", "getDemo", "()Ldemo/model/Demo;", "demo$delegate", "meshes", "Ldemo/view/AssetLoader;", "Ldemo/view/renderers/WireframeRenderer$MeshAsset;", "input", "", "Lorg/openrndr/shape/Path3D;", "Ldemo/view/ObjectView;", "x", "", "transforms", "Lorg/openrndr/math/Matrix44;", "draw", "", "objectContext", "Ldemo/view/LayerRenderer$ObjectContext;", "Ldemo/view/LayerRenderer;", "MeshAsset", "deminityy"})
@SourceDebugExtension(value={"SMAP\nWireframeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireframeRenderer.kt\ndemo/view/renderers/WireframeRenderer\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n58#2,6:107\n58#2,6:113\n1557#3:119\n1628#3,3:120\n1567#3:124\n1598#3,4:125\n1#4:123\n*S KotlinDebug\n*F\n+ 1 WireframeRenderer.kt\ndemo/view/renderers/WireframeRenderer\n*L\n15#1:107,6\n16#1:113,6\n24#1:119\n24#1:120,3\n90#1:124\n90#1:125,4\n*E\n"})
public final class WireframeRenderer
extends ObjectRenderer {
    @NotNull
    private final Lazy program$delegate;
    @NotNull
    private final Lazy demo$delegate;
    @NotNull
    private final AssetLoader<MeshAsset> meshes;

    public WireframeRenderer() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.program$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Program>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Program invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demo$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Demo>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Demo invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.meshes = new AssetLoader(this.getProgram(), this.getDemo().getAssetPath(), null, null, WireframeRenderer::meshes$lambda$1, 12, null);
    }

    @NotNull
    public final Program getProgram() {
        Lazy lazy = this.program$delegate;
        return (Program)lazy.getValue();
    }

    @NotNull
    public final Demo getDemo() {
        Lazy lazy = this.demo$delegate;
        return (Demo)lazy.getValue();
    }

    private final List<Path3D> input(ObjectView $this$input, double x) {
        List list;
        try {
            Function1<Double, Object> function1 = $this$input.getFunctions1().get("input");
            Function1<Double, Object> input = TypeIntrinsics.isFunctionOfArity(function1, 1) ? function1 : null;
            list = input == null ? null : (List)input.invoke(x);
        }
        catch (Throwable e) {
            throw new LayerRendererException("Error while evaluating function 'input'. " + e.getMessage(), e, null, null, $this$input.getObj(), null, 44, null);
        }
        return list;
    }

    private final List<Matrix44> transforms(ObjectView $this$transforms, double x) {
        List list;
        try {
            Function1<Double, Object> function1 = $this$transforms.getFunctions1().get("transforms");
            Function1<Double, Object> input = TypeIntrinsics.isFunctionOfArity(function1, 1) ? function1 : null;
            list = input == null ? CollectionsKt.listOf(Matrix44.Companion.getIDENTITY()) : (List)input.invoke(x);
        }
        catch (Throwable e) {
            throw new LayerRendererException("Error while evaluating function 'transforms'. " + e.getMessage(), e, null, null, $this$transforms.getObj(), null, 44, null);
        }
        return list;
    }

    @Override
    public void draw(@NotNull LayerRenderer.ObjectContext objectContext) {
        Intrinsics.checkNotNullParameter(objectContext, "objectContext");
        IObjectView iObjectView = objectContext.getObjectView();
        Intrinsics.checkNotNull(iObjectView, "null cannot be cast to non-null type demo.view.ObjectView");
        ObjectView ov = (ObjectView)iObjectView;
        double ot = objectContext.getObjectTime();
        LayerView layerView = objectContext.getLayerView();
        Layer.Object parentObj = objectContext.getObj().getParentId() != null ? layerView.getObjectsById().get(objectContext.getObj().getParentId()) : null;
        IObjectView parentObjView = parentObj != null ? layerView.getObjectViews().get(parentObj) : null;
        Matrix44 parentTransform = parentObj != null ? objectContext.getObjectTransforms().get(parentObj) : Matrix44.Companion.getIDENTITY();
        Matrix44 localTransform = ov.transform(ot);
        DrawerKt.isolated(this.getDrawer(), arg_0 -> WireframeRenderer.draw$lambda$4(ov, this, objectContext, ot, parentTransform, localTransform, layerView, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final MeshAsset meshes$lambda$1(File file, String string) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        MeshData meshData = OBJLoaderKt.loadOBJMeshData(file).toMeshData();
        Iterable $this$map$iv = WireframeKt.wireframe(meshData);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path3D.Companion.fromPoints((List<Vector3>)it, true));
        }
        List list = (List)destination$iv$iv;
        return new MeshAsset(list);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit draw$lambda$4(ObjectView $ov, WireframeRenderer this$0, LayerRenderer.ObjectContext $objectContext, double $ot, Matrix44 $parentTransform, Matrix44 $localTransform, LayerView $layerView, Drawer $this$isolated) {
        PaintView paint;
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        Pair<Layer.Paint, Map<String, Double>> pair = $ov.getEffectivePaint();
        if (pair != null) {
            Pair<Layer.Paint, Map<String, Double>> it = pair;
            boolean bl = false;
            v1 = $layerView.getPaints().get(it);
        } else {
            v1 = paint = null;
        }
        if (paint != null) {
            paint.apply(this$0.getDrawer(), this$0.getTargetManager(), this$0.getImages(), ((Number)$objectContext.getFunctions().getPaintTime().invoke($ot)).doubleValue());
            this$0.getDrawer().setShadeStyle(paint.getShadeStyle());
        }
        IObjectView iObjectView = $objectContext.getObjectView();
        Intrinsics.checkNotNull(iObjectView, "null cannot be cast to non-null type demo.view.ObjectView");
        List<Path3D> input = this$0.input((ObjectView)iObjectView, $objectContext.getObjectTime());
        for (Matrix44 pose : this$0.transforms($ov, $ot)) {
            Matrix44 modelTransform = $parentTransform.times(pose.times($localTransform));
            this$0.getDrawer().setModel(modelTransform);
            this$0.getDrawer().setStroke($objectContext.getFunctions().getStroke().invoke($ot));
            this$0.getDrawer().setStrokeWeight(((Number)$objectContext.getFunctions().getStrokeWeight().invoke($ot)).doubleValue());
            if (input != null) {
                Drawer.paths$default(this$0.getDrawer(), input, null, null, 6, null);
                continue;
            }
            if ($objectContext.getAssetName() != null) {
                void $this$mapIndexedTo$iv$iv;
                AssetLoader<MeshAsset> assetLoader = this$0.meshes;
                String string = $objectContext.getAssetName();
                Intrinsics.checkNotNull(string);
                MeshAsset mesh = assetLoader.get(string);
                int pathCount = mesh.getPaths().size();
                double offsetBlend = ((Number)$objectContext.getFunctions().getCutOffsetBlend().invoke($ot)).doubleValue();
                Iterable $this$mapIndexed$iv = mesh.getPaths();
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void path;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Path3D path3D = (Path3D)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    double p = (double)index / ((double)pathCount - 1.0);
                    double offset0 = ((Number)$objectContext.getFunctions().getCutOffset0().invoke(p)).doubleValue();
                    double offset1 = ((Number)$objectContext.getFunctions().getCutOffset1().invoke(p)).doubleValue();
                    double offset = MappingKt.mix(offset0, offset1, offsetBlend);
                    double c0 = ((Number)$objectContext.getFunctions().getC0().invoke($ot + offset)).doubleValue();
                    double c1 = ((Number)$objectContext.getFunctions().getC1().invoke($ot + offset)).doubleValue();
                    collection.add(path.sub(c0, c1));
                }
                List drawPaths = (List)destination$iv$iv;
                Drawer.paths$default(this$0.getDrawer(), drawPaths, null, null, 6, null);
                continue;
            }
            throw new IllegalStateException("Nothing to draw".toString());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Ldemo/view/renderers/WireframeRenderer$MeshAsset;", "", "paths", "", "Lorg/openrndr/shape/Path3D;", "<init>", "(Ljava/util/List;)V", "getPaths", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "deminityy"})
    public static final class MeshAsset {
        @NotNull
        private final List<Path3D> paths;

        public MeshAsset(@NotNull List<Path3D> paths) {
            Intrinsics.checkNotNullParameter(paths, "paths");
            this.paths = paths;
        }

        @NotNull
        public final List<Path3D> getPaths() {
            return this.paths;
        }

        @NotNull
        public final List<Path3D> component1() {
            return this.paths;
        }

        @NotNull
        public final MeshAsset copy(@NotNull List<Path3D> paths) {
            Intrinsics.checkNotNullParameter(paths, "paths");
            return new MeshAsset(paths);
        }

        public static /* synthetic */ MeshAsset copy$default(MeshAsset meshAsset, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = meshAsset.paths;
            }
            return meshAsset.copy(list);
        }

        @NotNull
        public String toString() {
            return "MeshAsset(paths=" + this.paths + ")";
        }

        public int hashCode() {
            return ((Object)this.paths).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeshAsset)) {
                return false;
            }
            MeshAsset meshAsset = (MeshAsset)other;
            return Intrinsics.areEqual(this.paths, meshAsset.paths);
        }
    }
}

