/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import demo.model.Configuration;
import demo.model.Demo;
import demo.model.Targets;
import demo.view.LazyMap;
import demo.view.TargetManagerKt;
import filewatcher.FileWatcherKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferMultisample;
import org.openrndr.draw.ColorAttachment;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferAttachment;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 J\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020'R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Ldemo/view/TargetManager;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "program$delegate", "Lkotlin/Lazy;", "demo", "Ldemo/model/Demo;", "getDemo", "()Ldemo/model/Demo;", "demo$delegate", "configuration", "Ldemo/model/Configuration;", "getConfiguration", "()Ldemo/model/Configuration;", "configuration$delegate", "states", "Ldemo/view/LazyMap;", "", "Ldemo/view/TargetManager$TargetState;", "getStates", "()Ldemo/view/LazyMap;", "renderTargets", "Lorg/openrndr/draw/RenderTarget;", "colorBuffers", "Lorg/openrndr/draw/ColorBuffer;", "getColorBuffers", "targetOrder", "", "targetDefinitions", "Lkotlin/Function0;", "Ldemo/model/Targets;", "getTargetDefinitions", "()Lkotlin/jvm/functions/Function0;", "clearTargets", "", "useTarget", "key", "resolveTarget", "resolveTargets", "TargetState", "deminityy"})
@SourceDebugExtension(value={"SMAP\nTargetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetManager.kt\ndemo/view/TargetManager\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n58#2,6:139\n58#2,6:145\n58#2,6:151\n1053#3:157\n1557#3:158\n1628#3,3:159\n1863#3,2:162\n*S KotlinDebug\n*F\n+ 1 TargetManager.kt\ndemo/view/TargetManager\n*L\n18#1:139,6\n19#1:145,6\n20#1:151,6\n79#1:157\n79#1:158\n79#1:159,3\n105#1:162,2\n*E\n"})
public final class TargetManager
implements KoinComponent {
    @NotNull
    private final Lazy program$delegate;
    @NotNull
    private final Lazy demo$delegate;
    @NotNull
    private final Lazy configuration$delegate;
    @NotNull
    private final LazyMap<String, TargetState> states;
    @NotNull
    private final LazyMap<String, RenderTarget> renderTargets;
    @NotNull
    private final LazyMap<String, ColorBuffer> colorBuffers;
    @NotNull
    private final Function0<Targets> targetDefinitions;

    public TargetManager() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.program$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Program>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Program invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demo$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Demo>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Demo invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.configuration$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Configuration>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Configuration invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Configuration.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Configuration.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.states = new LazyMap<String, TargetState>(TargetManager::states$lambda$0);
        this.renderTargets = new LazyMap<String, RenderTarget>((arg_0, arg_1) -> TargetManager.renderTargets$lambda$3(this, arg_0, arg_1));
        this.colorBuffers = new LazyMap<String, ColorBuffer>((arg_0, arg_1) -> TargetManager.colorBuffers$lambda$4(this, arg_0, arg_1));
        this.targetDefinitions = FileWatcherKt.watchFile(this.getProgram(), new File(this.getDemo().getDataBase(), "post/targets.conf"), TargetManager::targetDefinitions$lambda$7);
    }

    @NotNull
    public final Program getProgram() {
        Lazy lazy = this.program$delegate;
        return (Program)lazy.getValue();
    }

    @NotNull
    public final Demo getDemo() {
        Lazy lazy = this.demo$delegate;
        return (Demo)lazy.getValue();
    }

    @NotNull
    public final Configuration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (Configuration)lazy.getValue();
    }

    @NotNull
    public final LazyMap<String, TargetState> getStates() {
        return this.states;
    }

    @NotNull
    public final LazyMap<String, ColorBuffer> getColorBuffers() {
        return this.colorBuffers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> targetOrder() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = this.targetDefinitions.invoke().getTargets().entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Targets.Target)it.getValue()).getOrder());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, ((Targets.Target)it.getValue()).getOrder());
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Function0<Targets> getTargetDefinitions() {
        return this.targetDefinitions;
    }

    public final void clearTargets() {
        for (Map.Entry<String, Targets.Target> entry : this.targetDefinitions.invoke().getTargets().entrySet()) {
            String key = entry.getKey();
            Targets.Target value = entry.getValue();
            int n = value.getNames().size();
            for (int i = 0; i < n; ++i) {
                ColorRGBa clearColor = value.getClearColor().get(RangesKt.coerceIn(i, CollectionsKt.getIndices((Collection)value.getClearColor())));
                if (clearColor == null) continue;
                TargetManagerKt.access$getLogger$p().debug(() -> TargetManager.clearTargets$lambda$8(key, i));
                this.renderTargets.get(key).clearColor(i, clearColor);
            }
            if (value.getDepth() == Targets.Target.DepthType.NONE) continue;
            RenderTarget.DefaultImpls.clearDepth$default(this.renderTargets.get(key), 0.0, 0, 3, null);
        }
    }

    @NotNull
    public final RenderTarget useTarget(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        TargetManagerKt.access$getLogger$p().debug(() -> TargetManager.useTarget$lambda$9(key));
        this.states.get(key).setDirty(true);
        Iterable $this$forEach$iv = this.renderTargets.get(key).getColorAttachments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorAttachment it = (ColorAttachment)element$iv;
            boolean bl = false;
            this.states.get(key + ":" + it.getName());
        }
        return this.renderTargets.get(key);
    }

    @NotNull
    public final ColorBuffer resolveTarget(@NotNull String key) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter(key, "key");
        String[] stringArray = new String[]{":"};
        List subkeys = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
        Targets.Target target2 = this.targetDefinitions.invoke().getTargets().get(CollectionsKt.first(subkeys));
        if (target2 == null) {
            throw new IllegalStateException(("no target for '" + subkeys + "'").toString());
        }
        Targets.Target value = target2;
        if (value.getResolveTo() != null) {
            String resolveTo = subkeys.size() == 1 ? value.getResolveTo() : value.getResolveTo() + ":" + subkeys.get(1);
            ColorBuffer cb = this.colorBuffers.get(resolveTo);
            if (this.states.get(key).getDirty()) {
                TargetManagerKt.access$getLogger$p().debug(() -> TargetManager.resolveTarget$lambda$11(key, value));
                ColorBuffer.copyTo$default(this.colorBuffers.get(key), cb, 0, 0, null, 14, null);
                this.states.get(key).setDirty(false);
            }
            colorBuffer = cb;
        } else {
            TargetManagerKt.access$getLogger$p().debug(() -> TargetManager.resolveTarget$lambda$12(key));
            colorBuffer = this.colorBuffers.get(key);
        }
        return colorBuffer;
    }

    public final void resolveTargets() {
        for (Map.Entry<String, Targets.Target> entry : this.targetDefinitions.invoke().getTargets().entrySet()) {
            String key = entry.getKey();
            Targets.Target value = entry.getValue();
            if (value.getResolveTo() == null) continue;
            ColorBuffer.copyTo$default(this.colorBuffers.get(key), this.colorBuffers.get(value.getResolveTo()), 0, 0, null, 14, null);
        }
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final TargetState states$lambda$0(LazyMap $this$LazyMap, String key) {
        Intrinsics.checkNotNullParameter($this$LazyMap, "$this$LazyMap");
        Intrinsics.checkNotNullParameter(key, "key");
        return new TargetState(false);
    }

    private static final Object renderTargets$lambda$3$lambda$1(String $key, Targets.Target $target) {
        return "Creating target '" + $key + "' using " + $target;
    }

    private static final Unit renderTargets$lambda$3$lambda$2(Targets.Target $target, RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        int count2 = $target.getNames().size();
        for (int i = 0; i < count2; ++i) {
            $this$renderTarget.colorBuffer($target.getNames().get(i), switch (WhenMappings.$EnumSwitchMapping$0[$target.getFormats().get(RangesKt.coerceIn(i, CollectionsKt.getIndices((Collection)$target.getFormats()))).ordinal()]) {
                case 1 -> ColorFormat.R;
                case 2 -> ColorFormat.RG;
                case 3 -> ColorFormat.RGB;
                case 4 -> ColorFormat.RGBa;
                default -> throw new NoWhenBranchMatchedException();
            }, switch (WhenMappings.$EnumSwitchMapping$1[$target.getTypes().get(RangesKt.coerceIn(i, CollectionsKt.getIndices((Collection)$target.getTypes()))).ordinal()]) {
                case 1 -> ColorType.UINT8;
                case 2 -> ColorType.UINT8_SRGB;
                case 3 -> ColorType.FLOAT16;
                case 4 -> ColorType.FLOAT32;
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        switch (WhenMappings.$EnumSwitchMapping$2[$target.getDepth().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final RenderTarget renderTargets$lambda$3(TargetManager this$0, LazyMap $this$LazyMap, String key) {
        Intrinsics.checkNotNullParameter($this$LazyMap, "$this$LazyMap");
        Intrinsics.checkNotNullParameter(key, "key");
        Targets.Target target2 = this$0.targetDefinitions.invoke().getTargets().get(key);
        if (target2 == null) {
            throw new IllegalStateException(("no target definition for '" + key + "'").toString());
        }
        Targets.Target target3 = target2;
        TargetManagerKt.access$getLogger$p().info(() -> TargetManager.renderTargets$lambda$3$lambda$1(key, target3));
        return RenderTargetKt.renderTarget$default(this$0.getConfiguration().getTarget().getWidth(), this$0.getConfiguration().getTarget().getHeight(), target3.getScale(), target3.getSamples() == 0 ? (BufferMultisample)BufferMultisample.Disabled.INSTANCE : (BufferMultisample)new BufferMultisample.SampleCount(target3.getSamples()), null, arg_0 -> TargetManager.renderTargets$lambda$3$lambda$2(target3, arg_0), 16, null);
    }

    private static final ColorBuffer colorBuffers$lambda$4(TargetManager this$0, LazyMap $this$LazyMap, String key) {
        ColorBuffer colorBuffer;
        Intrinsics.checkNotNullParameter($this$LazyMap, "$this$LazyMap");
        Intrinsics.checkNotNullParameter(key, "key");
        String[] stringArray = new String[]{":"};
        List subkeys = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
        if (subkeys.size() == 1) {
            RenderTarget renderTarget = this$0.renderTargets.get((String)CollectionsKt.first(subkeys));
            Intrinsics.checkNotNull(renderTarget);
            colorBuffer = renderTarget.colorBuffer(0);
        } else {
            RenderTarget renderTarget = this$0.renderTargets.get((String)CollectionsKt.first(subkeys));
            Intrinsics.checkNotNull(renderTarget);
            ColorAttachment colorAttachment = renderTarget.colorAttachmentByName((String)subkeys.get(1));
            Intrinsics.checkNotNull(colorAttachment, "null cannot be cast to non-null type org.openrndr.draw.ColorBufferAttachment");
            colorBuffer = ((ColorBufferAttachment)colorAttachment).getColorBuffer();
        }
        return colorBuffer;
    }

    private static final Targets targetDefinitions$lambda$7(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Targets definitions = Targets.Companion.loadFromHocon(it);
        return definitions;
    }

    private static final Object clearTargets$lambda$8(String $key, int $i) {
        return "clearing target " + $key + ", attachment " + $i;
    }

    private static final Object useTarget$lambda$9(String $key) {
        return "using target " + $key;
    }

    private static final Object resolveTarget$lambda$11(String $key, Targets.Target $value) {
        return "resolving " + $key + " to " + $value.getResolveTo();
    }

    private static final Object resolveTarget$lambda$12(String $key) {
        return "got " + $key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Ldemo/view/TargetManager$TargetState;", "", "dirty", "", "<init>", "(Z)V", "getDirty", "()Z", "setDirty", "deminityy"})
    public static final class TargetState {
        private boolean dirty;

        public TargetState(boolean dirty) {
            this.dirty = dirty;
        }

        public final boolean getDirty() {
            return this.dirty;
        }

        public final void setDirty(boolean bl) {
            this.dirty = bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Targets.Target.Format.values().length];
            try {
                nArray[Targets.Target.Format.R.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RGB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Format.RGBA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Targets.Target.Type.values().length];
            try {
                nArray[Targets.Target.Type.UINT_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Type.UINT_8_SRGB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Type.FLOAT_16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.Type.FLOAT_32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Targets.Target.DepthType.values().length];
            try {
                nArray[Targets.Target.DepthType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Targets.Target.DepthType.DEPTH_STENCIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

