/*
 * Decompiled with CFR 0.152.
 */
package demo.view;

import audio.Channel;
import audio.VorbisChannel;
import demo.model.Demo;
import demo.services.LayerWatcherService;
import demo.view.DemoControllerKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import org.openrndr.CharacterEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.events.Event;
import org.openrndr.events.EventKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010B\u001a\u0002092\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010C\u001a\u0002092\u0006\u0010D\u001a\u00020\u001aJ\u0006\u0010E\u001a\u00020\u001aJ\u0006\u0010F\u001a\u000209J\u0006\u0010G\u001a\u000209J\u0006\u0010H\u001a\u000209J\u000e\u0010=\u001a\u0002092\u0006\u0010I\u001a\u00020<J\u0006\u0010J\u001a\u000209R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001eR&\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R&\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R\u001e\u00105\u001a\u00020 2\u0006\u00104\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\"R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020908\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\"\u0010=\u001a\u0004\u0018\u00010<2\b\u00104\u001a\u0004\u0018\u00010<@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\"\u00a8\u0006K"}, d2={"Ldemo/view/DemoController;", "Lorg/koin/core/component/KoinComponent;", "channel", "Laudio/Channel;", "<init>", "(Laudio/Channel;)V", "getChannel", "()Laudio/Channel;", "setChannel", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "program$delegate", "Lkotlin/Lazy;", "demo", "Ldemo/model/Demo;", "getDemo", "()Ldemo/model/Demo;", "demo$delegate", "layerWatcherService", "Ldemo/services/LayerWatcherService;", "getLayerWatcherService", "()Ldemo/services/LayerWatcherService;", "layerWatcherService$delegate", "cuePoint", "", "getCuePoint", "()D", "setCuePoint", "(D)V", "enableUI", "", "getEnableUI", "()Z", "setEnableUI", "(Z)V", "pitch", "getPitch", "setPitch", "volume", "getVolume", "setVolume", "nextLayerObjectTime", "Lkotlin/Function1;", "getNextLayerObjectTime", "()Lkotlin/jvm/functions/Function1;", "setNextLayerObjectTime", "(Lkotlin/jvm/functions/Function1;)V", "previousLayerObjectTime", "getPreviousLayerObjectTime", "setPreviousLayerObjectTime", "value", "followPlayhead", "getFollowPlayhead", "centerPlayheadRequested", "Lorg/openrndr/events/Event;", "", "getCenterPlayheadRequested", "()Lorg/openrndr/events/Event;", "", "error", "getError", "()Ljava/lang/Throwable;", "inError", "getInError", "setupInteractions", "setPosition", "time", "position", "jumpToCuePoint", "pause", "resume", "throwable", "clearError", "deminityy"})
@SourceDebugExtension(value={"SMAP\nDemoController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DemoController.kt\ndemo/view/DemoController\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,181:1\n58#2,6:182\n58#2,6:188\n58#2,6:194\n*S KotlinDebug\n*F\n+ 1 DemoController.kt\ndemo/view/DemoController\n*L\n17#1:182,6\n18#1:188,6\n19#1:194,6\n*E\n"})
public final class DemoController
implements KoinComponent {
    @NotNull
    private Channel channel;
    @NotNull
    private final Lazy program$delegate;
    @NotNull
    private final Lazy demo$delegate;
    @NotNull
    private final Lazy layerWatcherService$delegate;
    private double cuePoint;
    private boolean enableUI;
    private double pitch;
    private double volume;
    @NotNull
    private Function1<? super Double, Double> nextLayerObjectTime;
    @NotNull
    private Function1<? super Double, Double> previousLayerObjectTime;
    private boolean followPlayhead;
    @NotNull
    private final Event<Unit> centerPlayheadRequested;
    @Nullable
    private Throwable error;

    public DemoController(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.channel = channel;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.program$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Program>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Program invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Program.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.demo$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Demo>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final Demo invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Demo.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.layerWatcherService$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LayerWatcherService>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LayerWatcherService invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerWatcherService.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LayerWatcherService.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.pitch = 1.0;
        this.volume = 1.0;
        this.nextLayerObjectTime = DemoController::nextLayerObjectTime$lambda$0;
        this.previousLayerObjectTime = DemoController::previousLayerObjectTime$lambda$1;
        this.centerPlayheadRequested = new Event("center-requested", false, 2, null);
        this.getLayerWatcherService().getLayerChanged().listen(arg_0 -> DemoController._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final Channel getChannel() {
        return this.channel;
    }

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter(channel, "<set-?>");
        this.channel = channel;
    }

    private final Program getProgram() {
        Lazy lazy = this.program$delegate;
        return (Program)lazy.getValue();
    }

    private final Demo getDemo() {
        Lazy lazy = this.demo$delegate;
        return (Demo)lazy.getValue();
    }

    private final LayerWatcherService getLayerWatcherService() {
        Lazy lazy = this.layerWatcherService$delegate;
        return (LayerWatcherService)lazy.getValue();
    }

    public final double getCuePoint() {
        return this.cuePoint;
    }

    public final void setCuePoint(double d) {
        this.cuePoint = d;
    }

    public final boolean getEnableUI() {
        return this.enableUI;
    }

    public final void setEnableUI(boolean bl) {
        this.enableUI = bl;
    }

    public final double getPitch() {
        return this.pitch;
    }

    public final void setPitch(double d) {
        this.pitch = d;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final void setVolume(double d) {
        this.volume = d;
    }

    @NotNull
    public final Function1<Double, Double> getNextLayerObjectTime() {
        return this.nextLayerObjectTime;
    }

    public final void setNextLayerObjectTime(@NotNull Function1<? super Double, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.nextLayerObjectTime = function1;
    }

    @NotNull
    public final Function1<Double, Double> getPreviousLayerObjectTime() {
        return this.previousLayerObjectTime;
    }

    public final void setPreviousLayerObjectTime(@NotNull Function1<? super Double, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.previousLayerObjectTime = function1;
    }

    public final boolean getFollowPlayhead() {
        return this.followPlayhead;
    }

    @NotNull
    public final Event<Unit> getCenterPlayheadRequested() {
        return this.centerPlayheadRequested;
    }

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    public final boolean getInError() {
        return this.error != null;
    }

    public final void setupInteractions(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "program");
        Event[] eventArray = new Event[]{program2.getMouse().getDragged(), program2.getMouse().getButtonDown()};
        EventKt.listen((Iterable)CollectionsKt.listOf(eventArray), arg_0 -> DemoController.setupInteractions$lambda$5(program2, this, arg_0));
        program2.getKeyboard().getCharacter().listen(arg_0 -> DemoController.setupInteractions$lambda$6(this, arg_0));
        program2.getKeyboard().getKeyRepeat().listen(arg_0 -> DemoController.setupInteractions$lambda$7(this, arg_0));
        program2.getKeyboard().getKeyDown().listen(arg_0 -> DemoController.setupInteractions$lambda$9(this, program2, arg_0));
    }

    public final void setPosition(double time) {
        this.channel.setPosition(time / this.getDemo().getTimeScale());
    }

    public final double position() {
        return this.channel.getPosition();
    }

    public final void jumpToCuePoint() {
        this.channel.setPosition(this.cuePoint / this.getDemo().getTimeScale());
    }

    public final void pause() {
        Channel channel = this.channel;
        Intrinsics.checkNotNull(channel, "null cannot be cast to non-null type audio.VorbisChannel");
        if (!((VorbisChannel)channel).getPaused()) {
            this.channel.pause();
        } else {
            this.channel.resume();
        }
    }

    public final void resume() {
        this.channel.resume();
    }

    public final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.error = throwable;
        this.channel.pause();
    }

    public final void clearError() {
        this.error = null;
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final double nextLayerObjectTime$lambda$0(double currentTime) {
        return -1.0;
    }

    private static final double previousLayerObjectTime$lambda$1(double currentTime) {
        return -1.0;
    }

    private static final Object lambda$3$lambda$2() {
        return "Layer changed, jumping to cue point";
    }

    private static final Unit _init_$lambda$3(DemoController this$0, LayerWatcherService.LayerChangeEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        DemoControllerKt.access$getLogger$p().info(DemoController::lambda$3$lambda$2);
        this$0.clearError();
        this$0.jumpToCuePoint();
        return Unit.INSTANCE;
    }

    private static final Object setupInteractions$lambda$5$lambda$4(double $time, DemoController this$0) {
        return "setting cue point to " + $time / this$0.getDemo().getTimeScale();
    }

    private static final Unit setupInteractions$lambda$5(Program $program, DemoController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getPropagationCancelled() && !it.getModifiers().contains((Object)KeyModifier.ALT)) {
            double timescale = (double)($program.getWidth() - 210) / (this$0.getDemo().getDuration() * this$0.getDemo().getTimeScale());
            double time = RangesKt.coerceAtLeast((it.getPosition().x() - 200.0) / timescale, 0.0);
            if (it.getModifiers().contains((Object)KeyModifier.SHIFT)) {
                this$0.cuePoint = time;
                DemoControllerKt.access$getLogger$p().info(() -> DemoController.setupInteractions$lambda$5$lambda$4(time, this$0));
            }
            this$0.channel.setPosition(time / this$0.getDemo().getTimeScale());
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupInteractions$lambda$6(DemoController this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getCharacter() == 'q') {
            this$0.pitch /= 2.0;
            this$0.channel.setPitch(this$0.pitch);
        }
        if (it.getCharacter() == 'w') {
            this$0.pitch *= 2.0;
            this$0.channel.setPitch(this$0.pitch);
        }
        if (it.getCharacter() == 'm') {
            this$0.volume = 1.0 - this$0.volume;
            this$0.channel.setVolume(this$0.volume);
        }
        if (it.getCharacter() == 'c') {
            this$0.centerPlayheadRequested.trigger(Unit.INSTANCE);
        }
        if (it.getCharacter() == 'f') {
            this$0.followPlayhead = !this$0.followPlayhead;
        }
        return Unit.INSTANCE;
    }

    private static final Unit setupInteractions$lambda$7(DemoController this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        switch (it.getKey()) {
            case 262: {
                double nt = ((Number)this$0.nextLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.getDemo().getTimeScale());
                break;
            }
            case 263: {
                double nt = ((Number)this$0.previousLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.getDemo().getTimeScale());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object setupInteractions$lambda$9$lambda$8(Program $program, DemoController this$0) {
        return "setting cue point to " + $program.getSeconds() * this$0.getDemo().getTimeScale() / this$0.getDemo().getTimeScale();
    }

    private static final Unit setupInteractions$lambda$9(DemoController this$0, Program $program, KeyEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        switch (it.getKey()) {
            case 258: {
                this$0.enableUI = !this$0.enableUI;
                break;
            }
            case 268: {
                this$0.channel.setPosition(0.0);
                break;
            }
            case 262: {
                double nt = ((Number)this$0.nextLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.getDemo().getTimeScale());
                break;
            }
            case 263: {
                double nt = ((Number)this$0.previousLayerObjectTime.invoke((Double)this$0.cuePoint)).doubleValue();
                if (nt == -1.0) break;
                this$0.cuePoint = nt;
                this$0.channel.setPosition(nt / this$0.getDemo().getTimeScale());
                break;
            }
            case 264: {
                this$0.cuePoint = this$0.position() * this$0.getDemo().getTimeScale();
                DemoControllerKt.access$getLogger$p().info(() -> DemoController.setupInteractions$lambda$9$lambda$8($program, this$0));
                break;
            }
            case 265: {
                this$0.channel.setPosition(this$0.cuePoint / this$0.getDemo().getTimeScale());
                break;
            }
            case 32: {
                this$0.pause();
            }
        }
        return Unit.INSTANCE;
    }
}

