/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.camera;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.KeyEvent;
import org.openrndr.MouseEvent;
import org.openrndr.Program;
import org.openrndr.extras.camera.OrbitalCamera;
import org.openrndr.extras.camera.OrbitalControls$WhenMappings;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/openrndr/extras/camera/OrbitalControls;", "", "orbitalCamera", "Lorg/openrndr/extras/camera/OrbitalCamera;", "userInteraction", "", "(Lorg/openrndr/extras/camera/OrbitalCamera;Z)V", "fov", "", "getFov", "()D", "setFov", "(D)V", "lastMousePosition", "Lorg/openrndr/math/Vector2;", "getOrbitalCamera", "()Lorg/openrndr/extras/camera/OrbitalCamera;", "program", "Lorg/openrndr/Program;", "state", "Lorg/openrndr/extras/camera/OrbitalControls$STATE;", "getUserInteraction", "()Z", "keyPressed", "", "keyEvent", "Lorg/openrndr/KeyEvent;", "mouseButtonDown", "event", "Lorg/openrndr/MouseEvent;", "mouseMoved", "mouseScrolled", "setup", "STATE", "orx-camera"})
public final class OrbitalControls {
    private STATE state;
    private double fov;
    private Program program;
    private Vector2 lastMousePosition;
    @NotNull
    private final OrbitalCamera orbitalCamera;
    private final boolean userInteraction;

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    private final void mouseScrolled(MouseEvent event) {
        if (Math.abs(event.getRotation().getX()) > 0.1) {
            return;
        }
        if (event.getRotation().getY() > 0.0) {
            this.orbitalCamera.dollyIn();
        } else if (event.getRotation().getY() < 0.0) {
            this.orbitalCamera.dollyOut();
        }
    }

    private final void mouseMoved(MouseEvent event) {
        if (this.state == STATE.NONE) {
            return;
        }
        Vector2 vector2 = this.lastMousePosition;
        if (vector2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lastMousePosition");
        }
        Vector2 delta = vector2.minus(event.getPosition());
        this.lastMousePosition = event.getPosition();
        if (this.state == STATE.PAN) {
            Vector3 offset2 = Vector3.Companion.fromSpherical(this.orbitalCamera.getSpherical()).minus(this.orbitalCamera.getLookAt());
            double targetDistance = offset2.getLength() * Math.tan(this.fov / (double)2 * Math.PI / (double)180);
            double d = (double)2 * delta.getX() * targetDistance;
            Program program2 = this.program;
            if (program2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("program");
            }
            double panX = d / program2.getWindow().getSize().getX();
            double d2 = (double)2 * delta.getY() * targetDistance;
            Program program3 = this.program;
            if (program3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("program");
            }
            double panY = d2 / program3.getWindow().getSize().getY();
            this.orbitalCamera.pan(panX, -panY, 0.0);
        } else {
            double d = Math.PI * 2 * delta.getX();
            Program program4 = this.program;
            if (program4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("program");
            }
            double rotX = d / program4.getWindow().getSize().getX();
            double d3 = Math.PI * 2 * delta.getY();
            Program program5 = this.program;
            if (program5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("program");
            }
            double rotY = d3 / program5.getWindow().getSize().getY();
            this.orbitalCamera.rotate(rotX, rotY);
        }
    }

    private final void mouseButtonDown(MouseEvent event) {
        STATE previousState = this.state;
        switch (OrbitalControls$WhenMappings.$EnumSwitchMapping$0[event.getButton().ordinal()]) {
            case 1: {
                this.state = STATE.ROTATE;
                break;
            }
            case 2: {
                this.state = STATE.PAN;
            }
        }
        if (previousState == STATE.NONE) {
            this.lastMousePosition = event.getPosition();
        }
    }

    public final void keyPressed(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkParameterIsNotNull(keyEvent, "keyEvent");
        if (keyEvent.getKey() == 262) {
            this.orbitalCamera.pan(1.0, 0.0, 0.0);
        }
        if (keyEvent.getKey() == 263) {
            this.orbitalCamera.pan(-1.0, 0.0, 0.0);
        }
        if (keyEvent.getKey() == 265) {
            this.orbitalCamera.pan(0.0, 1.0, 0.0);
        }
        if (keyEvent.getKey() == 264) {
            this.orbitalCamera.pan(0.0, -1.0, 0.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "q")) {
            this.orbitalCamera.pan(0.0, -1.0, 0.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "e")) {
            this.orbitalCamera.pan(0.0, 1.0, 0.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "w")) {
            this.orbitalCamera.pan(0.0, 0.0, -1.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "s")) {
            this.orbitalCamera.pan(0.0, 0.0, 1.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "a")) {
            this.orbitalCamera.pan(-1.0, 0.0, 0.0);
        }
        if (Intrinsics.areEqual(keyEvent.getName(), "d")) {
            this.orbitalCamera.pan(1.0, 0.0, 0.0);
        }
        if (keyEvent.getKey() == 266) {
            this.orbitalCamera.zoom(1.0);
        }
        if (keyEvent.getKey() == 267) {
            this.orbitalCamera.zoom(-1.0);
        }
    }

    public final void setup(@NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(program2, "program");
        this.program = program2;
        if (this.userInteraction) {
            program2.getMouse().getMoved().listen(new Function1<MouseEvent, Unit>(this){
                final /* synthetic */ OrbitalControls this$0;

                public final void invoke(@NotNull MouseEvent it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    OrbitalControls.access$mouseMoved(this.this$0, it);
                }
                {
                    this.this$0 = orbitalControls;
                    super(1);
                }
            });
        }
        program2.getMouse().getButtonDown().listen(new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ OrbitalControls this$0;

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                OrbitalControls.access$mouseButtonDown(this.this$0, it);
            }
            {
                this.this$0 = orbitalControls;
                super(1);
            }
        });
        program2.getMouse().getButtonUp().listen(new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ OrbitalControls this$0;

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                OrbitalControls.access$setState$p(this.this$0, STATE.NONE);
            }
            {
                this.this$0 = orbitalControls;
                super(1);
            }
        });
        program2.getMouse().getScrolled().listen(new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ OrbitalControls this$0;

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                OrbitalControls.access$mouseScrolled(this.this$0, it);
            }
            {
                this.this$0 = orbitalControls;
                super(1);
            }
        });
        program2.getKeyboard().getKeyDown().listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ OrbitalControls this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.keyPressed(it);
            }
            {
                this.this$0 = orbitalControls;
                super(1);
            }
        });
        program2.getKeyboard().getKeyRepeat().listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ OrbitalControls this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.keyPressed(it);
            }
            {
                this.this$0 = orbitalControls;
                super(1);
            }
        });
    }

    @NotNull
    public final OrbitalCamera getOrbitalCamera() {
        return this.orbitalCamera;
    }

    public final boolean getUserInteraction() {
        return this.userInteraction;
    }

    public OrbitalControls(@NotNull OrbitalCamera orbitalCamera, boolean userInteraction) {
        Intrinsics.checkParameterIsNotNull(orbitalCamera, "orbitalCamera");
        this.orbitalCamera = orbitalCamera;
        this.userInteraction = userInteraction;
        this.state = STATE.NONE;
        this.fov = 90.0;
    }

    public /* synthetic */ OrbitalControls(OrbitalCamera orbitalCamera, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(orbitalCamera, bl);
    }

    public static final /* synthetic */ void access$mouseMoved(OrbitalControls $this, @NotNull MouseEvent event) {
        $this.mouseMoved(event);
    }

    public static final /* synthetic */ void access$mouseButtonDown(OrbitalControls $this, @NotNull MouseEvent event) {
        $this.mouseButtonDown(event);
    }

    @NotNull
    public static final /* synthetic */ STATE access$getState$p(OrbitalControls $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(OrbitalControls $this, @NotNull STATE sTATE) {
        $this.state = sTATE;
    }

    public static final /* synthetic */ void access$mouseScrolled(OrbitalControls $this, @NotNull MouseEvent event) {
        $this.mouseScrolled(event);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/extras/camera/OrbitalControls$STATE;", "", "(Ljava/lang/String;I)V", "NONE", "ROTATE", "PAN", "orx-camera"})
    public static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE NONE;
        public static final /* enum */ STATE ROTATE;
        public static final /* enum */ STATE PAN;
        private static final /* synthetic */ STATE[] $VALUES;

        static {
            STATE[] sTATEArray = new STATE[3];
            STATE[] sTATEArray2 = sTATEArray;
            sTATEArray[0] = NONE = new STATE();
            sTATEArray[1] = ROTATE = new STATE();
            sTATEArray[2] = PAN = new STATE();
            $VALUES = sTATEArray;
        }

        public static STATE[] values() {
            return (STATE[])$VALUES.clone();
        }

        public static STATE valueOf(String string) {
            return Enum.valueOf(STATE.class, string);
        }
    }
}

