/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.PerlinNoise2DKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"perlin", "", "seed", "", "x", "y", "interpolator", "Lkotlin/Function1;", "perlinHermite", "perlinLinear", "perlinQuintic", "orx-noise"})
public final class PerlinNoise2DKt {
    public static final double perlinLinear(int seed, double x, double y) {
        return PerlinNoise2DKt.perlin(seed, x, y, perlinLinear.1.INSTANCE);
    }

    public static final double perlinQuintic(int seed, double x, double y) {
        return PerlinNoise2DKt.perlin(seed, x, y, perlinQuintic.1.INSTANCE);
    }

    public static final double perlinHermite(int seed, double x, double y) {
        return PerlinNoise2DKt.perlin(seed, x, y, perlinHermite.1.INSTANCE);
    }

    private static final double perlin(int seed, double x, double y, Function1<? super Double, Double> interpolator) {
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolator.invoke((Double)(x - (double)x0))).doubleValue();
        double ys = ((Number)interpolator.invoke((Double)(y - (double)y0))).doubleValue();
        double xd0 = x - (double)x0;
        double yd0 = y - (double)y0;
        double xd1 = xd0 - 1.0;
        double yd1 = yd0 - 1.0;
        double xf0 = InterpolationKt.lerp(GradCoordKt.gradCoord2D(seed, x0, y0, xd0, yd0), GradCoordKt.gradCoord2D(seed, x1, y0, xd1, yd0), xs);
        double xf1 = InterpolationKt.lerp(GradCoordKt.gradCoord2D(seed, x0, y1, xd0, yd1), GradCoordKt.gradCoord2D(seed, x1, y1, xd1, yd1), xs);
        return InterpolationKt.lerp(xf0, xf1, ys);
    }
}

