/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawContextKt;
import org.openrndr.draw.Shader;
import org.openrndr.draw.UniformBlock;
import org.openrndr.internal.Driver;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0007H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/openrndr/draw/DrawContext;", "", "model", "Lorg/openrndr/math/Matrix44;", "view", "projection", "width", "", "height", "contentScale", "", "(Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;IID)V", "getContentScale", "()D", "getHeight", "()I", "getModel", "()Lorg/openrndr/math/Matrix44;", "getProjection", "getView", "getWidth", "applyToShader", "", "shader", "Lorg/openrndr/draw/Shader;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "openrndr-core"})
public final class DrawContext {
    @NotNull
    private final Matrix44 model;
    @NotNull
    private final Matrix44 view;
    @NotNull
    private final Matrix44 projection;
    private final int width;
    private final int height;
    private final double contentScale;

    /*
     * WARNING - void declaration
     */
    public final void applyToShader(@NotNull Shader shader2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull(shader2, "shader");
        Object object2 = DrawContextKt.access$getContextBlocks$p();
        Long key$iv = Driver.Companion.getDriver().getContextID();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DrawContextKt.access$getLogger$p().debug(applyToShader.contextBlock.1.1.INSTANCE);
            UniformBlock answer$iv = shader2.createBlock("ContextBlock");
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        UniformBlock contextBlock2 = (UniformBlock)object;
        if (!DrawContextKt.access$getUseContextBlock$p()) {
            Matrix44 normalMatrix;
            if (shader2.hasUniform("u_viewMatrix")) {
                shader2.uniform("u_viewMatrix", this.view);
            }
            if (shader2.hasUniform("u_modelMatrix")) {
                shader2.uniform("u_modelMatrix", this.model);
            }
            if (shader2.hasUniform("u_projectionMatrix")) {
                shader2.uniform("u_projectionMatrix", this.projection);
            }
            if (shader2.hasUniform("u_viewDimensions")) {
                shader2.uniform("u_viewDimensions", new Vector2(this.width, this.height));
            }
            if (shader2.hasUniform("u_modelNormalMatrix")) {
                Matrix44 matrix44;
                if (this.model == DrawContextKt.access$getLastModel$p()) {
                    matrix44 = DrawContextKt.access$getLastModelNormal$p();
                } else {
                    DrawContextKt.access$setLastModelNormal$p(this.model != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.model) : Matrix44.Companion.getIDENTITY());
                    DrawContextKt.access$setLastModel$p(this.model);
                    matrix44 = DrawContextKt.access$getLastModelNormal$p();
                }
                normalMatrix = matrix44;
                shader2.uniform("u_modelNormalMatrix", normalMatrix);
            }
            if (shader2.hasUniform("u_viewNormalMatrix")) {
                Matrix44 matrix44;
                if (this.view == DrawContextKt.access$getLastView$p()) {
                    matrix44 = DrawContextKt.access$getLastViewNormal$p();
                } else {
                    DrawContextKt.access$setLastViewNormal$p(this.view != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.view) : Matrix44.Companion.getIDENTITY());
                    DrawContextKt.access$setLastView$p(this.view);
                    matrix44 = DrawContextKt.access$getLastViewNormal$p();
                }
                normalMatrix = matrix44;
                shader2.uniform("u_viewNormalMatrix", normalMatrix);
            }
            if (shader2.hasUniform("u_contentScale")) {
                shader2.uniform("u_contentScale", this.contentScale);
            }
        } else {
            Matrix44 matrix44;
            Matrix44 matrix442;
            object2 = contextBlock2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$apply = object2;
            boolean bl3 = false;
            $this$apply.uniform("u_viewMatrix", this.view);
            $this$apply.uniform("u_modelMatrix", this.model);
            $this$apply.uniform("u_projectionMatrix", this.projection);
            $this$apply.uniform("u_viewDimensions", new Vector2(this.width, this.height));
            Object object3 = $this$apply;
            boolean bl4 = false;
            boolean bl5 = false;
            Object $this$run = object3;
            boolean bl6 = false;
            if (this.model == DrawContextKt.access$getLastModel$p()) {
                matrix442 = DrawContextKt.access$getLastModelNormal$p();
            } else {
                DrawContextKt.access$setLastModelNormal$p(this.model != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.model) : Matrix44.Companion.getIDENTITY());
                DrawContextKt.access$setLastModel$p(this.model);
                matrix442 = DrawContextKt.access$getLastModelNormal$p();
            }
            Matrix44 normalMatrix = matrix442;
            $this$run.uniform("u_modelNormalMatrix", normalMatrix);
            object3 = $this$apply;
            bl4 = false;
            bl5 = false;
            $this$run = object3;
            boolean bl7 = false;
            if (this.view == DrawContextKt.access$getLastView$p()) {
                matrix44 = DrawContextKt.access$getLastViewNormal$p();
            } else {
                DrawContextKt.access$setLastViewNormal$p(this.view != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.view) : Matrix44.Companion.getIDENTITY());
                DrawContextKt.access$setLastView$p(this.view);
                matrix44 = DrawContextKt.access$getLastViewNormal$p();
            }
            normalMatrix = matrix44;
            $this$run.uniform("u_viewNormalMatrix", normalMatrix);
            $this$apply.uniform("u_contentScale", (float)this.contentScale);
            if ($this$apply.getDirty()) {
                $this$apply.upload();
            }
            shader2.block("ContextBlock", (UniformBlock)$this$apply);
        }
    }

    @NotNull
    public final Matrix44 getModel() {
        return this.model;
    }

    @NotNull
    public final Matrix44 getView() {
        return this.view;
    }

    @NotNull
    public final Matrix44 getProjection() {
        return this.projection;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    public DrawContext(@NotNull Matrix44 model, @NotNull Matrix44 view2, @NotNull Matrix44 projection, int width, int height, double contentScale) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(view2, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        this.model = model;
        this.view = view2;
        this.projection = projection;
        this.width = width;
        this.height = height;
        this.contentScale = contentScale;
    }

    @NotNull
    public final Matrix44 component1() {
        return this.model;
    }

    @NotNull
    public final Matrix44 component2() {
        return this.view;
    }

    @NotNull
    public final Matrix44 component3() {
        return this.projection;
    }

    public final int component4() {
        return this.width;
    }

    public final int component5() {
        return this.height;
    }

    public final double component6() {
        return this.contentScale;
    }

    @NotNull
    public final DrawContext copy(@NotNull Matrix44 model, @NotNull Matrix44 view2, @NotNull Matrix44 projection, int width, int height, double contentScale) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(view2, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        return new DrawContext(model, view2, projection, width, height, contentScale);
    }

    @NotNull
    public static /* synthetic */ DrawContext copy$default(DrawContext drawContext, Matrix44 matrix44, Matrix44 matrix442, Matrix44 matrix443, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            matrix44 = drawContext.model;
        }
        if ((n3 & 2) != 0) {
            matrix442 = drawContext.view;
        }
        if ((n3 & 4) != 0) {
            matrix443 = drawContext.projection;
        }
        if ((n3 & 8) != 0) {
            n = drawContext.width;
        }
        if ((n3 & 0x10) != 0) {
            n2 = drawContext.height;
        }
        if ((n3 & 0x20) != 0) {
            d = drawContext.contentScale;
        }
        return drawContext.copy(matrix44, matrix442, matrix443, n, n2, d);
    }

    @NotNull
    public String toString() {
        return "DrawContext(model=" + this.model + ", view=" + this.view + ", projection=" + this.projection + ", width=" + this.width + ", height=" + this.height + ", contentScale=" + this.contentScale + ")";
    }

    public int hashCode() {
        Matrix44 matrix44 = this.model;
        Matrix44 matrix442 = this.view;
        Matrix44 matrix443 = this.projection;
        return (((((matrix44 != null ? ((Object)matrix44).hashCode() : 0) * 31 + (matrix442 != null ? ((Object)matrix442).hashCode() : 0)) * 31 + (matrix443 != null ? ((Object)matrix443).hashCode() : 0)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height)) * 31 + Double.hashCode(this.contentScale);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawContext)) break block3;
                DrawContext drawContext = (DrawContext)object;
                if (!Intrinsics.areEqual(this.model, drawContext.model) || !Intrinsics.areEqual(this.view, drawContext.view) || !Intrinsics.areEqual(this.projection, drawContext.projection) || !(this.width == drawContext.width) || !(this.height == drawContext.height) || Double.compare(this.contentScale, drawContext.contentScale) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

