/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/openrndr/shape/Circle;", "", "x", "", "y", "radius", "(DDD)V", "center", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;D)V", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getRadius", "()D", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "contains", "", "point", "moved", "offset", "movedTo", "position", "scaled", "scale", "scaledTo", "fitRadius", "Companion", "openrndr-shape"})
public final class Circle {
    @NotNull
    private final Vector2 center;
    private final double radius;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Circle moved(@NotNull Vector2 offset2) {
        Intrinsics.checkParameterIsNotNull(offset2, "offset");
        return new Circle(this.center.plus(offset2), this.radius);
    }

    @NotNull
    public final Circle movedTo(@NotNull Vector2 position) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        return new Circle(position, this.radius);
    }

    @NotNull
    public final Circle scaled(double scale2) {
        return new Circle(this.center, this.radius * scale2);
    }

    @NotNull
    public final Circle scaledTo(double fitRadius) {
        return new Circle(this.center, fitRadius);
    }

    public final boolean contains(@NotNull Vector2 point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return point.minus(this.center).getSquaredLength() < this.radius * this.radius;
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        double x = this.center.getX() - this.radius;
        double y = this.center.getY() - this.radius;
        double width = this.radius * 2.0;
        double height = this.radius * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        return ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(x, ym, oy, xm, ox, y, xe, ye){
            final /* synthetic */ double $x;
            final /* synthetic */ double $ym;
            final /* synthetic */ double $oy;
            final /* synthetic */ double $xm;
            final /* synthetic */ double $ox;
            final /* synthetic */ double $y;
            final /* synthetic */ double $xe;
            final /* synthetic */ double $ye;

            public final void invoke(@NotNull ContourBuilder $this$contour) {
                Intrinsics.checkParameterIsNotNull($this$contour, "$receiver");
                $this$contour.moveTo(new Vector2(this.$x, this.$ym));
                $this$contour.curveTo(new Vector2(this.$x, this.$ym - this.$oy), new Vector2(this.$xm - this.$ox, this.$y), new Vector2(this.$xm, this.$y));
                $this$contour.curveTo(new Vector2(this.$xm + this.$ox, this.$y), new Vector2(this.$xe, this.$ym - this.$oy), new Vector2(this.$xe, this.$ym));
                $this$contour.curveTo(new Vector2(this.$xe, this.$ym + this.$oy), new Vector2(this.$xm + this.$ox, this.$ye), new Vector2(this.$xm, this.$ye));
                $this$contour.curveTo(new Vector2(this.$xm - this.$ox, this.$ye), new Vector2(this.$x, this.$ym + this.$oy), new Vector2(this.$x, this.$ym));
                $this$contour.close();
            }
            {
                this.$x = d;
                this.$ym = d2;
                this.$oy = d3;
                this.$xm = d4;
                this.$ox = d5;
                this.$y = d6;
                this.$xe = d7;
                this.$ye = d8;
                super(1);
            }
        });
    }

    @NotNull
    public final Vector2 getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public Circle(@NotNull Vector2 center, double radius) {
        Intrinsics.checkParameterIsNotNull(center, "center");
        this.center = center;
        this.radius = radius;
    }

    public Circle(double x, double y, double radius) {
        this(new Vector2(x, y), radius);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/openrndr/shape/Circle$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/Circle;", "a", "Lorg/openrndr/math/Vector2;", "b", "openrndr-shape"})
    public static final class Companion {
        @NotNull
        public final Circle fromPoints(@NotNull Vector2 a2, @NotNull Vector2 b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Vector2 center = a2.plus(b).times(0.5);
            return new Circle(center, b.minus(center).getLength());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

