/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0000H\u0086\u0004J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/openrndr/math/IntVector2;", "Ljava/io/Serializable;", "x", "", "y", "(II)V", "length", "", "getLength", "()D", "squaredLength", "getSquaredLength", "()I", "vector2", "Lorg/openrndr/math/Vector2;", "getVector2", "()Lorg/openrndr/math/Vector2;", "getX", "xx", "getXx", "()Lorg/openrndr/math/IntVector2;", "getY", "yx", "getYx", "yy", "getYy", "component1", "component2", "copy", "div", "d", "dot", "right", "equals", "", "other", "", "hashCode", "minus", "v", "plus", "times", "toString", "", "Companion", "openrndr-math"})
public final class IntVector2
implements Serializable {
    private final int x;
    private final int y;
    @NotNull
    private static final IntVector2 ZERO;
    @NotNull
    private static final IntVector2 UNIT_X;
    @NotNull
    private static final IntVector2 UNIT_Y;
    public static final Companion Companion;

    public final double getLength() {
        double d = 1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y);
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final int getSquaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    public final int dot(@NotNull IntVector2 right) {
        Intrinsics.checkParameterIsNotNull(right, "right");
        return this.x * right.x + this.y * right.y;
    }

    @NotNull
    public final IntVector2 getYx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 getXx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 getYy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector2 plus(@NotNull IntVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector2(this.x + v.x, this.y + v.y);
    }

    @NotNull
    public final IntVector2 minus(@NotNull IntVector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector2(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final IntVector2 times(int d) {
        return new IntVector2(this.x * d, this.y * d);
    }

    @NotNull
    public final IntVector2 div(int d) {
        return new IntVector2(this.x / d, this.y / d);
    }

    @NotNull
    public final Vector2 getVector2() {
        return new Vector2(this.x, this.y);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public IntVector2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    static {
        Companion = new Companion(null);
        ZERO = new IntVector2(0, 0);
        UNIT_X = new IntVector2(1, 0);
        UNIT_Y = new IntVector2(0, 1);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final IntVector2 copy(int x, int y) {
        return new IntVector2(x, y);
    }

    public static /* synthetic */ IntVector2 copy$default(IntVector2 intVector2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = intVector2.x;
        }
        if ((n3 & 2) != 0) {
            n2 = intVector2.y;
        }
        return intVector2.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "IntVector2(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof IntVector2)) break block3;
                IntVector2 intVector2 = (IntVector2)object;
                if (!(this.x == intVector2.x) || !(this.y == intVector2.y)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/math/IntVector2$Companion;", "", "()V", "UNIT_X", "Lorg/openrndr/math/IntVector2;", "getUNIT_X", "()Lorg/openrndr/math/IntVector2;", "UNIT_Y", "getUNIT_Y", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final IntVector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector2 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector2 getUNIT_Y() {
            return UNIT_Y;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

