/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ChannelMask;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.StencilOperation;
import org.openrndr.draw.StencilStyle;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.internal.Command;
import org.openrndr.internal.Driver;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionDrawer;
import org.openrndr.internal.ExpansionType;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J,\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J$\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019J\u001e\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001dJ$\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J$\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J$\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019J\u001e\u0010'\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)J\"\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000f\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006+"}, d2={"Lorg/openrndr/internal/ExpansionDrawer;", "", "()V", "quad", "Lorg/openrndr/draw/VertexBuffer;", "getQuad", "()Lorg/openrndr/draw/VertexBuffer;", "setQuad", "(Lorg/openrndr/draw/VertexBuffer;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "getVertexFormat", "()Lorg/openrndr/draw/VertexFormat;", "vertices", "getVertices", "setVertices", "renderConvexFillCommands", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "commands", "", "Lorg/openrndr/internal/Command;", "renderFill", "expansions", "Lorg/openrndr/internal/Expansion;", "convex", "", "renderFillCommands", "renderFills", "renderStroke", "expansion", "renderStrokeCommands", "renderStrokeCommandsInterleaved", "renderStrokes", "toCommand", "vertexOffset", "", "toCommands", "openrndr-core"})
public final class ExpansionDrawer {
    private final ShadeStyleManager shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkParameterIsNotNull(p1, "p1");
            return ((ShaderGenerators)this.receiver).expansionVertexShader(p1);
        }

        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
        }

        public final String getName() {
            return "expansionVertexShader";
        }

        public final String getSignature() {
            return "expansionVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
        }
    }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

        @NotNull
        public final String invoke(@NotNull ShadeStructure p1) {
            Intrinsics.checkParameterIsNotNull(p1, "p1");
            return ((ShaderGenerators)this.receiver).expansionFragmentShader(p1);
        }

        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
        }

        public final String getName() {
            return "expansionFragmentShader";
        }

        public final String getSignature() {
            return "expansionFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
        }
    });
    @NotNull
    private final VertexFormat vertexFormat = VertexFormatKt.vertexFormat(vertexFormat.1.INSTANCE);
    @NotNull
    private VertexBuffer vertices = VertexBuffer.Companion.createDynamic(this.vertexFormat, 0x400000);
    @NotNull
    private VertexBuffer quad = VertexBuffer.Companion.createDynamic(this.vertexFormat, 6);

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    public final void setVertices(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.vertices = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getQuad() {
        return this.quad;
    }

    public final void setQuad(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.quad = vertexBuffer;
    }

    public final void renderStrokeCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), CollectionsKt.emptyList());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = DrawStyle.copy$default(drawStyle, null, null, null, null, null, 0.0, false, null, null, false, null, null, null, false, null, null, null, null, null, null, null, 0x1FFFFF, null);
        double fringe = 1.0;
        shader2.uniform("strokeMult", (drawStyle.getStrokeWeight() + fringe) / fringe);
        shader2.uniform("strokeFillFactor", 0.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Command command = (Command)element$iv;
            boolean bl = false;
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader2.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            shader2.uniform("strokeThr", -1.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
        shader2.end();
    }

    public final void renderStrokeCommandsInterleaved(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Collection collection = commands;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Shader shader2 = ShadeStyleManager.shader$default(this.shaderManager, drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()), null, 4, null);
            shader2.begin();
            drawContext.applyToShader(shader2);
            drawStyle.applyToShader(shader2);
            Driver.Companion.getInstance().setState(drawStyle);
            DrawStyle localStyle = drawStyle;
            Command command = CollectionsKt.last(commands);
            boolean bl2 = false;
            boolean bl3 = false;
            Command it = command;
            boolean bl4 = false;
            int vertexCount2 = it.getVertexOffset() + it.getVertexCount();
            shader2.uniform("strokeMult", drawStyle.getStrokeWeight() / 2.0 + 0.65);
            shader2.uniform("strokeFillFactor", 0.0);
            shader2.uniform("bounds", new Vector4(-1000.0, -1000.0, 2000.0, 2000.0));
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader2.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            shader2.uniform("strokeThr", 0.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
    }

    public final void renderConvexFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Command command;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        shader2.uniform("strokeThr", -1.0f);
        shader2.uniform("strokeMult", 1.0);
        shader2.uniform("strokeFillFactor", 1.0);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command = (Command)element$iv;
            boolean bl = false;
            if (command.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, command.getVertexOffset(), command.getVertexCount());
        }
        $this$forEach$iv = commands;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            command = (Command)element$iv;
            boolean bl = false;
            if (command.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
        }
    }

    public final void renderFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Command c2;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        if (commands.isEmpty()) {
            return;
        }
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        shader2.uniform("strokeThr", -1.0f);
        double fringe = 1.0;
        shader2.uniform("strokeMult", 1.0);
        shader2.uniform("strokeFillFactor", 1.0);
        Command command = commands.get(0);
        shader2.uniform("bounds", new Vector4(command.getMinX(), command.getMinY(), command.getMaxX() - command.getMinX(), command.getMaxY() - command.getMinY()));
        localStyle.setFrontStencil(new StencilStyle());
        localStyle.setBackStencil(new StencilStyle());
        localStyle.getFrontStencil().setStencilWriteMask(255);
        localStyle.getBackStencil().setStencilWriteMask(255);
        localStyle.getFrontStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE_WRAP);
        localStyle.getBackStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.DECREASE_WRAP);
        localStyle.getFrontStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.getBackStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getNONE());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        Driver.Companion.getInstance().setState(localStyle);
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            c2 = (Command)element$iv;
            boolean bl = false;
            if (c2.getType() != ExpansionType.FILL) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(c2.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, c2.getVertexOffset(), c2.getVertexCount());
        }
        localStyle.setFrontStencil(localStyle.getStencil());
        localStyle.setBackStencil(localStyle.getStencil());
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        shader2.uniform("strokeThr", 0.0f);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
        Driver.Companion.getInstance().setState(localStyle);
        $this$forEach$iv = commands;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            c2 = (Command)element$iv;
            boolean bl = false;
            if (c2.getType() != ExpansionType.FRINGE) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(c2.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, c2.getVertexOffset(), c2.getVertexCount());
        }
        shader2.uniform("strokeThr", -1.0f);
        localStyle.getStencil().stencilFunc(StencilTest.NOT_EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        double minX = command.getMinX();
        double maxX = command.getMaxX();
        double minY = command.getMinY();
        double maxY = command.getMaxY();
        BufferWriter bufferWriter2 = this.quad.getShadow().writer();
        boolean bl = false;
        boolean bl2 = false;
        BufferWriter $this$apply = bufferWriter2;
        boolean bl3 = false;
        $this$apply.rewind();
        $this$apply.write((float)minX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)minX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)maxY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)maxX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        $this$apply.write((float)minX, (float)minY);
        $this$apply.write(0.5f, 1.0f, 0.0f);
        VertexBufferShadow.DefaultImpls.upload$default(this.quad.getShadow(), 0, 0, 3, null);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.quad), DrawPrimitive.TRIANGLES, 0, 6);
        localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
        shader2.end();
    }

    @NotNull
    public final Command toCommand(@NotNull VertexBuffer vertices, @NotNull Expansion expansion, int vertexOffset) {
        Intrinsics.checkParameterIsNotNull(vertices, "vertices");
        Intrinsics.checkParameterIsNotNull(expansion, "expansion");
        if (expansion.getVertexCount() > 0) {
            Command command = new Command(vertices, expansion.getType(), vertexOffset, expansion.getVertexCount() + 2, expansion.getMinx(), expansion.getMiny(), expansion.getMaxx(), expansion.getMaxy());
            BufferWriter bufferWriter2 = vertices.getShadow().writer();
            boolean bl = false;
            boolean bl2 = false;
            BufferWriter $this$apply = bufferWriter2;
            boolean bl3 = false;
            $this$apply.setPositionElements(vertexOffset);
            BufferWriter w = bufferWriter2;
            int vertexSize = (expansion.getBufferPosition() - expansion.getBufferStart()) / expansion.getVertexCount();
            w.write(expansion.getFb(), expansion.getBufferStart(), vertexSize);
            w.write(expansion.getFb(), expansion.getBufferStart(), expansion.getBufferPosition() - expansion.getBufferStart());
            w.write(expansion.getFb(), expansion.getBufferStart() + vertexSize * (expansion.getVertexCount() - 1), vertexSize);
            return command;
        }
        return new Command(vertices, ExpansionType.SKIP, 0, 0, 0.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final List<Command> toCommands(@NotNull VertexBuffer vertices, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(vertices, "vertices");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        int vertexOffset = 0;
        boolean bl = false;
        List commands = new ArrayList();
        Iterable $this$forEach$iv = expansions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expansion it = (Expansion)element$iv;
            boolean bl2 = false;
            Command command = this.toCommand(vertices, it, vertexOffset);
            if (command.getType() == ExpansionType.SKIP) continue;
            commands.add(command);
            vertexOffset += it.getVertexCount() + 2;
        }
        vertices.getShadow().uploadElements(0, vertexOffset);
        return commands;
    }

    public final void renderStroke(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Expansion expansion) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansion, "expansion");
        this.renderStrokeCommands(drawContext, drawStyle, this.toCommands(this.vertices, CollectionsKt.listOf(expansion)));
    }

    public final void renderStrokes(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        this.renderStrokeCommandsInterleaved(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
    }

    public final void renderFill(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, boolean convex) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        if (convex) {
            this.renderConvexFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
        } else {
            this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
        }
    }

    public final void renderFills(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
    }
}

