/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extras.camera;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.draw.VertexFormatKt;
import org.openrndr.extras.camera.Debug3D;
import org.openrndr.extras.camera.OrbitalCamera;
import org.openrndr.extras.camera.OrbitalControls;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\n\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/openrndr/extras/camera/Debug3D;", "Lorg/openrndr/Extension;", "eye", "Lorg/openrndr/math/Vector3;", "lookAt", "fov", "", "userInteraction", "", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;DZ)V", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "grid", "Lorg/openrndr/draw/VertexBuffer;", "lastSeconds", "orbitalCamera", "Lorg/openrndr/extras/camera/OrbitalCamera;", "getOrbitalCamera", "()Lorg/openrndr/extras/camera/OrbitalCamera;", "orbitalControls", "Lorg/openrndr/extras/camera/OrbitalControls;", "showGrid", "getShowGrid", "setShowGrid", "afterDraw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "beforeDraw", "setup", "orx-camera"})
public final class Debug3D
implements Extension {
    private boolean enabled;
    private boolean showGrid;
    @NotNull
    private final OrbitalCamera orbitalCamera;
    private final OrbitalControls orbitalControls;
    private double lastSeconds;
    private final VertexBuffer grid;

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean getShowGrid() {
        return this.showGrid;
    }

    public final void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    @NotNull
    public final OrbitalCamera getOrbitalCamera() {
        return this.orbitalCamera;
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(program2, "program");
        if (this.lastSeconds == -1.0) {
            this.lastSeconds = program2.getSeconds();
        }
        double delta = program2.getSeconds() - this.lastSeconds;
        this.lastSeconds = program2.getSeconds();
        this.orbitalCamera.update(delta);
        drawer.background(ColorRGBa.Companion.getBLACK());
        drawer.perspective(this.orbitalCamera.getFov(), program2.getWindow().getSize().getX() / program2.getWindow().getSize().getY(), 0.1, 1000.0);
        drawer.setView(this.orbitalCamera.viewMatrix());
        if (this.showGrid) {
            DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer){
                final /* synthetic */ Debug3D this$0;
                final /* synthetic */ Drawer $drawer;

                public final void invoke(@NotNull Drawer $this$isolated) {
                    Intrinsics.checkParameterIsNotNull($this$isolated, "$receiver");
                    this.$drawer.setFill(ColorRGBa.Companion.getWHITE());
                    this.$drawer.setStroke(ColorRGBa.Companion.getWHITE());
                    Drawer.vertexBuffer$default(this.$drawer, Debug3D.access$getGrid$p(this.this$0), DrawPrimitive.LINES, 0, 0, 12, null);
                    this.$drawer.setFill(ColorRGBa.Companion.getRED());
                    this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_X());
                    this.$drawer.setFill(ColorRGBa.Companion.getGREEN());
                    this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_Y());
                    this.$drawer.setFill(ColorRGBa.Companion.getBLUE());
                    this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_Z());
                }
                {
                    this.this$0 = debug3D;
                    this.$drawer = drawer;
                    super(1);
                }
            });
        }
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(program2, "program");
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(drawer){
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull Drawer $this$isolated) {
                Intrinsics.checkParameterIsNotNull($this$isolated, "$receiver");
                this.$drawer.setView(Matrix44.Companion.getIDENTITY());
                this.$drawer.ortho();
            }
            {
                this.$drawer = drawer;
                super(1);
            }
        });
    }

    @Override
    public void setup(@NotNull Program program2) {
        Intrinsics.checkParameterIsNotNull(program2, "program");
        this.orbitalControls.setup(program2);
    }

    public Debug3D(@NotNull Vector3 eye, @NotNull Vector3 lookAt, double fov, boolean userInteraction) {
        VertexBuffer vertexBuffer;
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        this.enabled = true;
        this.orbitalCamera = new OrbitalCamera(eye, lookAt, fov);
        this.orbitalControls = new OrbitalControls(this.orbitalCamera, userInteraction);
        this.lastSeconds = -1.0;
        VertexBuffer vertexBuffer2 = VertexBufferKt.vertexBuffer(VertexFormatKt.vertexFormat(grid.1.INSTANCE), 84);
        Debug3D debug3D = this;
        boolean bl = false;
        boolean bl2 = false;
        VertexBuffer $this$apply = vertexBuffer2;
        boolean bl3 = false;
        $this$apply.put(grid.2.1.INSTANCE);
        debug3D.grid = vertexBuffer = vertexBuffer2;
    }

    public /* synthetic */ Debug3D(Vector3 vector3, Vector3 vector32, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3 = new Vector3(0.0, 0.0, 10.0);
        }
        if ((n & 2) != 0) {
            vector32 = Vector3.Companion.getZERO();
        }
        if ((n & 4) != 0) {
            d = 90.0;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(vector3, vector32, d, bl);
    }

    public Debug3D() {
        this(null, null, 0.0, false, 15, null);
    }

    public static final /* synthetic */ VertexBuffer access$getGrid$p(Debug3D $this) {
        return $this.grid;
    }
}

