/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.ValueNoise2DKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a7\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0014\b\u0006\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007H\u0086\b\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"value", "", "seed", "", "x", "y", "interpolation", "Lkotlin/Function1;", "valueHermite", "valueLinear", "valueQuintic", "orx-noise"})
public final class ValueNoise2DKt {
    public static final double valueLinear(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p1 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.linear(p1);
        double p12 = y - (double)y0$iv;
        $i$a$-unknown-ValueNoise2DKt$valueLinear$1 = false;
        double ys$iv = InterpolationKt.linear(p12);
        double xf0$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return InterpolationKt.lerp(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double valueQuintic(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p1 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.quintic(p1);
        double p12 = y - (double)y0$iv;
        $i$a$-unknown-ValueNoise2DKt$valueQuintic$1 = false;
        double ys$iv = InterpolationKt.quintic(p12);
        double xf0$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return InterpolationKt.lerp(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double valueHermite(int seed, double x, double y) {
        boolean $i$f$value = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        double p1 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.hermite(p1);
        double p12 = y - (double)y0$iv;
        $i$a$-unknown-ValueNoise2DKt$valueHermite$1 = false;
        double ys$iv = InterpolationKt.hermite(p12);
        double xf0$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y0$iv), GradCoordKt.valCoord2D(seed, x1$iv, y0$iv), xs$iv);
        double xf1$iv = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0$iv, y1$iv), GradCoordKt.valCoord2D(seed, x1$iv, y1$iv), xs$iv);
        return InterpolationKt.lerp(xf0$iv, xf1$iv, ys$iv);
    }

    public static final double value(int seed, double x, double y, @NotNull Function1<? super Double, Double> interpolation) {
        int $i$f$value = 0;
        Intrinsics.checkParameterIsNotNull(interpolation, "interpolation");
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolation.invoke((Double)(x - (double)x0))).doubleValue();
        double ys = ((Number)interpolation.invoke((Double)(y - (double)y0))).doubleValue();
        double xf0 = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), xs);
        double xf1 = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), xs);
        return InterpolationKt.lerp(xf0, xf1, ys);
    }

    public static /* synthetic */ double value$default(int seed, double x, double y, Function1 interpolation, int n, Object object) {
        if ((n & 8) != 0) {
            interpolation = value.1.INSTANCE;
        }
        boolean $i$f$value = false;
        Intrinsics.checkParameterIsNotNull(interpolation, "interpolation");
        int x0 = MathUtilsKt.fastFloor(x);
        int y0 = MathUtilsKt.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolation.invoke(x - (double)x0)).doubleValue();
        double ys = ((Number)interpolation.invoke(y - (double)y0)).doubleValue();
        double xf0 = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), xs);
        double xf1 = InterpolationKt.lerp(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), xs);
        return InterpolationKt.lerp(xf0, xf1, ys);
    }
}

