/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class NVNativeQuery {
    protected NVNativeQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryNativeDisplayNV, caps.eglQueryNativeWindowNV, caps.eglQueryNativePixmapNV);
    }

    public static int neglQueryNativeDisplayNV(long dpy, long display_id) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativeDisplayNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPI(dpy, display_id, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryNativeDisplayNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLNativeDisplayType *") PointerBuffer display_id) {
        if (Checks.CHECKS) {
            Checks.check(display_id, 1);
        }
        return NVNativeQuery.neglQueryNativeDisplayNV(dpy, MemoryUtil.memAddress(display_id)) != 0;
    }

    public static int neglQueryNativeWindowNV(long dpy, long surf, long window) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativeWindowNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surf);
        }
        return JNI.callPPPI(dpy, surf, window, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryNativeWindowNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surf, @NativeType(value="EGLNativeWindowType *") PointerBuffer window) {
        if (Checks.CHECKS) {
            Checks.check(window, 1);
        }
        return NVNativeQuery.neglQueryNativeWindowNV(dpy, surf, MemoryUtil.memAddress(window)) != 0;
    }

    public static int neglQueryNativePixmapNV(long dpy, long surf, long pixmap) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativePixmapNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(surf);
        }
        return JNI.callPPPI(dpy, surf, pixmap, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryNativePixmapNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLSurface") long surf, @NativeType(value="EGLNativePixmapType *") PointerBuffer pixmap) {
        if (Checks.CHECKS) {
            Checks.check(pixmap, 1);
        }
        return NVNativeQuery.neglQueryNativePixmapNV(dpy, surf, MemoryUtil.memAddress(pixmap)) != 0;
    }
}

