/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Vec1;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.Vec4;
import java.awt.geom.Point2D;
import java.util.PrimitiveIterator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;

public interface Vec<T extends Vec<T>>
extends Comparable<T> {
    public static final DoubleUnaryOperator NEGATE = n -> -n;
    public static final DoubleBinaryOperator ADD = (a2, b) -> a2 + b;
    public static final DoubleBinaryOperator MUL = (a2, b) -> a2 * b;
    public static final DoubleBinaryOperator SUB = (a2, b) -> a2 - b;
    public static final DoubleBinaryOperator DIV = (a2, b) -> a2 / b;
    public static final DoubleBinaryOperator DELTA = (a2, b) -> Math.abs(a2 - b);

    public static Vec2 from(Point2D p) {
        return new Vec2(p.getX(), p.getY());
    }

    public static Vec1 vec(double x) {
        return new Vec1(x);
    }

    public static Vec2 vec(double x, double y) {
        return new Vec2(x, y);
    }

    public static Vec3 vec(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    public static Vec4 vec(double x, double y, double z, double w) {
        return new Vec4(x, y, z, w);
    }

    public static Vec from(double[] ary) {
        switch (ary.length) {
            case 2: {
                return new Vec2(ary[0], ary[1]);
            }
            case 3: {
                return new Vec3(ary[0], ary[1], ary[2]);
            }
            case 4: {
                return new Vec4(ary[0], ary[1], ary[2], ary[3]);
            }
        }
        throw new IllegalArgumentException("ary must have a length in [1,4]");
    }

    public static <T extends Vec<T>> double dot(T a2, T b) {
        return a2.mul(b).reduce(ADD);
    }

    public static double dot(Vec2 a2, Vec2 b) {
        return a2.x * b.x + a2.y * b.y;
    }

    public static <T extends Vec<T>> T lerp(T a2, T b, double t) {
        return a2.add(b.sub(a2).mul(t));
    }

    public static Vec2 lerp(Vec2 a2, Vec2 b, double t) {
        return new Vec2(a2.x + (b.x - a2.x) * t, a2.y + (b.y - a2.y) * t);
    }

    public static <T extends Vec<T>> T lerp(T a2, T b, T t) {
        return a2.add(b.sub(a2).mul(t));
    }

    public static Vec2 lerp(Vec2 a2, Vec2 b, Vec2 t) {
        return new Vec2(a2.x + (b.x - a2.x) * t.x, a2.y + (b.y - a2.y) * t.y);
    }

    public static <T extends Vec<T>> boolean equals(T a2, T b, double tolerance) {
        return a2.zip(b, DELTA).every(i -> i <= tolerance);
    }

    public T map(DoubleUnaryOperator var1);

    public double reduce(DoubleBinaryOperator var1, double var2);

    public double reduce(DoubleBinaryOperator var1);

    public T zip(T var1, DoubleBinaryOperator var2);

    public boolean every(DoublePredicate var1);

    public boolean any(DoublePredicate var1);

    public double nth(int var1);

    public int dim();

    public double[] array();

    default public T negate() {
        return this.map(NEGATE);
    }

    default public T add(T v) {
        return this.zip(v, ADD);
    }

    default public T add(double n) {
        return this.map(i -> i + n);
    }

    default public T sub(T v) {
        return this.zip(v, SUB);
    }

    default public T sub(double n) {
        return this.map(i -> i - n);
    }

    default public T mul(T v) {
        return this.zip(v, MUL);
    }

    default public T mul(double k) {
        return this.map(i -> i * k);
    }

    default public T div(T v) {
        return this.zip(v, DIV);
    }

    default public T div(double k) {
        return this.mul(1.0 / k);
    }

    default public T abs() {
        return this.map(Math::abs);
    }

    default public double lengthSquared() {
        return Vec.dot(this, this);
    }

    default public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    default public T norm() {
        double l = this.lengthSquared();
        if (l == 1.0) {
            return (T)this;
        }
        return this.div(Math.sqrt(l));
    }

    default public T pseudoNorm() {
        int exponent = Math.getExponent(this.reduce(Math::max));
        return (T)(exponent < -8 | exponent > 8 ? this.mul(Math.pow(2.0, -exponent)) : this);
    }

    default public PrimitiveIterator.OfDouble iterator() {
        return this.stream().iterator();
    }

    default public DoubleStream stream() {
        return DoubleStream.of(this.array());
    }

    default public T clamp(double min, double max) {
        return this.map(i -> Math.max(min, Math.min(max, i)));
    }

    default public T clamp(T min, T max) {
        return this.zip(min, Math::max).zip(max, Math::min);
    }
}

