/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;
import org.openrndr.shape.LineSegment3D;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J(\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0015H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\tR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSampler3D;", "", "()V", "direction", "", "Lorg/openrndr/math/Vector3;", "getDirection$openrndr_core", "()Ljava/util/List;", "setDirection$openrndr_core", "(Ljava/util/List;)V", "distanceTolerance", "", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "points", "getPoints$openrndr_core", "setPoints$openrndr_core", "recursionLimit", "", "sample", "Lkotlin/Pair;", "", "x1", "x2", "x3", "", "level", "Companion", "openrndr-core"})
public final class BezierQuadraticSampler3D {
    private final int recursionLimit;
    private double distanceTolerance = 0.5;
    private double distanceToleranceSquare;
    @NotNull
    private List<Vector3> points;
    @NotNull
    private List<Vector3> direction;
    private static final double collinearityEpsilon = 1.0E-30;
    public static final Companion Companion = new Companion(null);

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final List<Vector3> getPoints$openrndr_core() {
        return this.points;
    }

    public final void setPoints$openrndr_core(@NotNull List<Vector3> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.points = list;
    }

    @NotNull
    public final List<Vector3> getDirection$openrndr_core() {
        return this.direction;
    }

    public final void setDirection$openrndr_core(@NotNull List<Vector3> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.direction = list;
    }

    private final void sample(Vector3 x1, Vector3 x2, Vector3 x3, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector3 x12 = x1.plus(x2).times(0.5);
        Vector3 x23 = x2.plus(x3).times(0.5);
        Vector3 x123 = x12.plus(x23).times(0.5);
        double dx = x3.getX() - x1.getX();
        double dy = x3.getY() - x1.getY();
        double dz = x3.getZ() - x1.getZ();
        double d = new LineSegment3D(x1, x3).squaredDistance(x2);
        if (d > 1.0E-30) {
            if (d * d <= this.distanceToleranceSquare * (dx * dx + dy * dy + dz * dz)) {
                this.direction.add(x3.minus(x1));
                this.points.add(x123);
                return;
            }
        } else {
            double da = dx * dx + dy * dy + dz * dz;
            if (da == 0.0) {
                d = BezierQuadraticSampler3D.Companion.squaredDistance(x1.getX(), x1.getY(), x1.getZ(), x2.getX(), x2.getY(), x2.getZ());
            } else {
                d = ((x2.getX() - x1.getX()) * dx + (x2.getY() - x1.getY()) * dy) / da;
                if (d > 0.0 && d < 1.0) {
                    return;
                }
                double d2 = d <= 0.0 ? BezierQuadraticSampler3D.Companion.squaredDistance(x2.getX(), x2.getY(), x2.getZ(), x1.getX(), x1.getY(), x1.getZ()) : (d = d >= 1.0 ? BezierQuadraticSampler3D.Companion.squaredDistance(x2.getX(), x2.getY(), x2.getZ(), x3.getX(), x3.getY(), x3.getZ()) : BezierQuadraticSampler3D.Companion.squaredDistance(x2.getX(), x2.getY(), x2.getZ(), x1.getX() + d * dx, x1.getY() + d * dy, x1.getZ() + d * dz));
            }
            if (d < this.distanceToleranceSquare) {
                this.direction.add(x3.minus(x1));
                this.points.add(x2);
                return;
            }
        }
        this.sample(x1, x12, x123, level + 1);
        this.sample(x123, x23, x3, level + 1);
    }

    @NotNull
    public final Pair<List<Vector3>, List<Vector3>> sample(@NotNull Vector3 x1, @NotNull Vector3 x2, @NotNull Vector3 x3) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.direction.clear();
        this.points.add(x1);
        this.direction.add(x2.minus(x1));
        this.sample(x1, x2, x3, 0);
        this.points.add(x3);
        this.direction.add(x3.minus(x2));
        return new Pair<List<Vector3>, List<Vector3>>(this.points, this.direction);
    }

    public BezierQuadraticSampler3D() {
        this.recursionLimit = 8;
        boolean bl = false;
        this.points = new ArrayList();
        bl = false;
        this.direction = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/openrndr/shape/internal/BezierQuadraticSampler3D$Companion;", "", "()V", "collinearityEpsilon", "", "squaredDistance", "x1", "y1", "z1", "x2", "y2", "z2", "openrndr-core"})
    public static final class Companion {
        private final double squaredDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            return dx * dx + dy * dy + dz * dz;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

