/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u00132\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bJ0\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler2D;", "", "()V", "angleTolerance", "", "cuspLimit", "direction", "", "Lorg/openrndr/math/Vector2;", "distanceTolerance", "getDistanceTolerance", "()D", "setDistanceTolerance", "(D)V", "distanceToleranceSquare", "points", "recursionLimit", "", "sample", "Lkotlin/Pair;", "", "x1", "x2", "x3", "x4", "", "level", "Companion", "openrndr-core"})
public final class BezierCubicSampler2D {
    private final int recursionLimit;
    private final List<Vector2> points;
    private final List<Vector2> direction;
    private double distanceToleranceSquare;
    private final double angleTolerance;
    private final double cuspLimit;
    private double distanceTolerance;
    private static final double colinearityEpsilon;
    private static final double angleToleranceEpsilon;
    public static final Companion Companion;

    public final double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public final void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    @NotNull
    public final Pair<List<Vector2>, List<Vector2>> sample(@NotNull Vector2 x1, @NotNull Vector2 x2, @NotNull Vector2 x3, @NotNull Vector2 x4) {
        Intrinsics.checkNotNullParameter(x1, "x1");
        Intrinsics.checkNotNullParameter(x2, "x2");
        Intrinsics.checkNotNullParameter(x3, "x3");
        Intrinsics.checkNotNullParameter(x4, "x4");
        this.distanceToleranceSquare = this.distanceTolerance * this.distanceTolerance;
        this.points.clear();
        this.direction.clear();
        this.points.add(x1);
        this.direction.add(x2.minus(x1));
        this.sample(x1, x2, x3, x4, 0);
        if (CollectionsKt.last(this.points).squaredDistanceTo(x4) > 0.0) {
            this.points.add(x4);
            this.direction.add(x4.minus(x3));
        }
        return new Pair<List<Vector2>, List<Vector2>>(this.points, this.direction);
    }

    private final void sample(Vector2 x1, Vector2 x2, Vector2 x3, Vector2 x4, int level) {
        if (level > this.recursionLimit) {
            return;
        }
        Vector2 x12 = x1.plus(x2).times(0.5);
        Vector2 x23 = x2.plus(x3).times(0.5);
        Vector2 x34 = x3.plus(x4).times(0.5);
        Vector2 x123 = x12.plus(x23).times(0.5);
        Vector2 x234 = x23.plus(x34).times(0.5);
        Vector2 x1234 = x123.plus(x234).times(0.5);
        double dx = x4.getX() - x1.getX();
        double dy = x4.getY() - x1.getY();
        double d = (x2.getX() - x4.getX()) * dy - (x2.getY() - x4.getY()) * dx;
        boolean bl = false;
        double d2 = Math.abs(d);
        double d3 = (x3.getX() - x4.getX()) * dy - (x3.getY() - x4.getY()) * dx;
        boolean bl2 = false;
        double d32 = Math.abs(d3);
        boolean p1 = d2 > colinearityEpsilon;
        boolean p0 = d32 > colinearityEpsilon;
        int p = (p1 ? 2 : 0) + (p0 ? 1 : 0);
        double k = 0.0;
        double da1 = 0.0;
        double da2 = 0.0;
        switch (p) {
            case 0: {
                k = dx * dx + dy * dy;
                if (k == 0.0) {
                    d2 = BezierCubicSampler2D.Companion.squareDistance(x1.getX(), x1.getY(), x2.getX(), x2.getY());
                    d32 = BezierCubicSampler2D.Companion.squareDistance(x4.getX(), x4.getY(), x3.getX(), x3.getY());
                } else {
                    k = 1.0 / k;
                    da1 = x2.getX() - x1.getX();
                    da2 = x2.getY() - x1.getY();
                    d2 = k * (da1 * dx + da2 * dy);
                    da1 = x3.getX() - x1.getX();
                    da2 = x3.getY() - x1.getY();
                    d32 = k * (da1 * dx + da2 * dy);
                    if (d2 > 0.0 && d2 < 1.0 && d32 > 0.0 && d32 < 1.0) {
                        return;
                    }
                    d2 = d2 <= 0.0 ? BezierCubicSampler2D.Companion.squareDistance(x2.getX(), x2.getY(), x1.getX(), x1.getY()) : (d2 >= 1.0 ? BezierCubicSampler2D.Companion.squareDistance(x2.getX(), x2.getY(), x4.getX(), x4.getY()) : BezierCubicSampler2D.Companion.squareDistance(x2.getX(), x2.getY(), x1.getX() + d2 * dx, x1.getY() + d2 * dy));
                    double d4 = d32 <= 0.0 ? BezierCubicSampler2D.Companion.squareDistance(x3.getX(), x3.getY(), x1.getX(), x1.getY()) : (d32 = d32 >= 1.0 ? BezierCubicSampler2D.Companion.squareDistance(x3.getX(), x3.getY(), x4.getX(), x4.getY()) : BezierCubicSampler2D.Companion.squareDistance(x3.getX(), x3.getY(), x1.getX() + d32 * dx, x1.getY() + d32 * dy));
                }
                if (d2 > d32) {
                    if (!(d2 < this.distanceToleranceSquare)) break;
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x2) > 0.0) {
                        this.points.add(x2);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                if (!(d32 < this.distanceToleranceSquare)) break;
                if (CollectionsKt.last(this.points).squaredDistanceTo(x3) > 0.0) {
                    this.points.add(x3);
                    this.direction.add(x4.minus(x1));
                }
                return;
            }
            case 1: {
                if (!(d32 * d32 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x23) > 0.0) {
                        this.points.add(x23);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                double d5 = x4.getY() - x3.getY();
                double d6 = x4.getX() - x3.getX();
                boolean bl3 = false;
                double d7 = Math.atan2(d5, d6);
                d5 = x3.getY() - x2.getY();
                d6 = x3.getX() - x2.getX();
                bl3 = false;
                d5 = d7 - Math.atan2(d5, d6);
                boolean bl4 = false;
                da1 = Math.abs(d5);
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x2) > 0.0) {
                        this.points.add(x2);
                        this.direction.add(x4.minus(x1));
                    }
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x3) > 0.0) {
                        this.points.add(x3);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                if (CollectionsKt.last(this.points).squaredDistanceTo(x3) > 0.0) {
                    this.points.add(x3);
                    this.direction.add(x4.minus(x1));
                }
                return;
            }
            case 2: {
                if (!(d2 * d2 <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x23) > 0.0) {
                        this.points.add(x23);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                double d8 = x3.getY() - x2.getY();
                double d9 = x3.getX() - x2.getX();
                boolean bl5 = false;
                double d10 = Math.atan2(d8, d9);
                d8 = x2.getY() - x1.getY();
                d9 = x2.getX() - x1.getX();
                bl5 = false;
                d8 = d10 - Math.atan2(d8, d9);
                boolean bl6 = false;
                da1 = Math.abs(d8);
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da1 < this.angleTolerance) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x2) > 0.0) {
                        this.points.add(x2);
                        this.direction.add(x4.minus(x1));
                    }
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x3) > 0.0) {
                        this.points.add(x3);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                if (this.cuspLimit == 0.0 || !(da1 > this.cuspLimit)) break;
                if (CollectionsKt.last(this.points).squaredDistanceTo(x2) > 0.0) {
                    this.points.add(x2);
                    this.direction.add(x4.minus(x1));
                }
                return;
            }
            case 3: {
                if (!((d2 + d32) * (d2 + d32) <= this.distanceToleranceSquare * (dx * dx + dy * dy))) break;
                if (this.angleTolerance < angleToleranceEpsilon) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x23) > 0.0) {
                        this.points.add(x23);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                double d11 = x3.getY() - x2.getY();
                double d12 = x3.getX() - x2.getX();
                boolean bl7 = false;
                k = Math.atan2(d11, d12);
                d11 = x2.getY() - x1.getY();
                d12 = x2.getX() - x1.getX();
                bl7 = false;
                d11 = k - Math.atan2(d11, d12);
                boolean bl8 = false;
                da1 = Math.abs(d11);
                d11 = x4.getY() - x3.getY();
                double d13 = x4.getX() - x3.getX();
                bl7 = false;
                d11 = Math.atan2(d11, d13) - k;
                boolean bl9 = false;
                da2 = Math.abs(d11);
                if (da1 >= Math.PI) {
                    da1 = Math.PI * 2 - da1;
                }
                if (da2 >= Math.PI) {
                    da2 = Math.PI * 2 - da2;
                }
                if (da1 + da2 < this.angleTolerance) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x23) > 0.0) {
                        this.points.add(x23);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                if (this.cuspLimit == 0.0) break;
                if (da1 > this.cuspLimit) {
                    if (CollectionsKt.last(this.points).squaredDistanceTo(x2) > 0.0) {
                        this.points.add(x2);
                        this.direction.add(x4.minus(x1));
                    }
                    return;
                }
                if (!(da2 > this.cuspLimit)) break;
                if (CollectionsKt.last(this.points).squaredDistanceTo(x3) > 0.0) {
                    this.points.add(x3);
                    this.direction.add(x4.minus(x1));
                }
                return;
            }
        }
        this.sample(x1, x12, x123, x1234, level + 1);
        this.sample(x1234, x234, x34, x4, level + 1);
    }

    public BezierCubicSampler2D() {
        this.recursionLimit = 8;
        boolean bl = false;
        this.points = new ArrayList();
        bl = false;
        this.direction = new ArrayList();
        this.distanceTolerance = 0.5;
    }

    static {
        Companion = new Companion(null);
        colinearityEpsilon = 1.0E-30;
        angleToleranceEpsilon = 0.01;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/shape/internal/BezierCubicSampler2D$Companion;", "", "()V", "angleToleranceEpsilon", "", "colinearityEpsilon", "squareDistance", "x", "y", "x1", "y1", "openrndr-core"})
    public static final class Companion {
        private final double squareDistance(double x, double y, double x1, double y1) {
            double dx = x1 - x;
            double dy = y1 - y;
            return dx * dx + dy * dy;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

