/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.shape.PathProjection3D;
import org.openrndr.shape.Segment3D;
import org.openrndr.shape.SegmentProjection3D;
import org.openrndr.shape.ShapeToolsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016J$\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u001f\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020\u00162\b\b\u0002\u0010&\u001a\u00020\u000e\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u000eJ\u000e\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ\u0016\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eJ\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u000203R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u00065"}, d2={"Lorg/openrndr/shape/Path3D;", "", "segments", "", "Lorg/openrndr/shape/Segment3D;", "closed", "", "(Ljava/util/List;Z)V", "getClosed", "()Z", "exploded", "getExploded", "()Ljava/util/List;", "length", "", "getLength", "()D", "reversed", "getReversed", "()Lorg/openrndr/shape/Path3D;", "getSegments", "adaptivePositions", "Lorg/openrndr/math/Vector3;", "distanceTolerance", "equals", "other", "equidistantPositions", "pointCount", "", "hashCode", "map", "mapper", "Lkotlin/Function1;", "mod", "a", "b", "on", "point", "error", "(Lorg/openrndr/math/Vector3;D)Ljava/lang/Double;", "plus", "position", "ut", "project", "Lorg/openrndr/shape/PathProjection3D;", "sampleEquidistant", "sampleLinear", "sub", "u0", "u1", "transform", "Lorg/openrndr/math/Matrix44;", "Companion", "openrndr-core"})
public final class Path3D {
    @NotNull
    private final List<Segment3D> segments;
    private final boolean closed;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path3D> getExploded() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path3D path3D = new Path3D(CollectionsKt.listOf(it), false);
            collection.add(path3D);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Path3D plus(@NotNull Path3D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double epsilon = 0.001;
        boolean bl = false;
        List segments = new ArrayList();
        segments.addAll((Collection)this.segments);
        if (this.segments.get(this.segments.size() - 1).getEnd().minus(other.segments.get(0).getStart()).getLength() > epsilon) {
            segments.add(new Segment3D(this.segments.get(this.segments.size() - 1).getEnd(), other.segments.get(0).getStart()));
        }
        segments.addAll((Collection)other.segments);
        return new Path3D(segments, false);
    }

    @NotNull
    public final Vector3 position(double ut) {
        double t2 = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t2 * (double)this.segments.size());
        double segmentOffset = t2 * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).position(segmentOffset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3> adaptivePositions(double distanceTolerance) {
        boolean bl = false;
        List adaptivePoints = new ArrayList();
        Vector3 last2 = null;
        for (Segment3D segment : this.segments) {
            List<Vector3> samples = segment.sampleAdaptive(distanceTolerance);
            Collection collection = samples;
            int n = 0;
            if (!(!collection.isEmpty())) continue;
            Vector3 r = samples.get(0);
            if (last2 == null || last2.minus(r).getLength() > 0.01) {
                adaptivePoints.add(r);
            }
            n = 1;
            int n2 = samples.size();
            while (n < n2) {
                void i;
                adaptivePoints.add(samples.get((int)i));
                last2 = samples.get((int)i);
                ++i;
            }
        }
        return adaptivePoints;
    }

    public static /* synthetic */ List adaptivePositions$default(Path3D path3D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return path3D.adaptivePositions(d);
    }

    @NotNull
    public final List<Vector3> equidistantPositions(int pointCount) {
        return ShapeToolsKt.sampleEquidistant3D(Path3D.adaptivePositions$default(this, 0.0, 1, null), pointCount);
    }

    @NotNull
    public final Path3D sampleLinear(double distanceTolerance) {
        return Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.closed);
    }

    public static /* synthetic */ Path3D sampleLinear$default(Path3D path3D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return path3D.sampleLinear(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D sampleEquidistant(int pointCount) {
        void $this$mapTo$iv$iv;
        List<Vector3> points = this.equidistantPositions(pointCount);
        Iterable $this$map$iv = RangesKt.until(0, points.size() - 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Segment3D segment3D = new Segment3D(points.get((int)it), points.get((int)(it + true)));
            collection.add(segment3D);
        }
        List segments = (List)destination$iv$iv;
        return new Path3D(segments, this.closed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D transform(@NotNull Matrix44 transform2) {
        Collection<Segment3D> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Segment3D segment3D2 = it.transform(transform2);
            collection.add(segment3D2);
        }
        collection = (List)destination$iv$iv;
        boolean bl = this.closed;
        List list = collection;
        return new Path3D(list, bl);
    }

    private final double mod(double a2, double b) {
        return (a2 % b + b) % b;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D sub(double u0, double u1) {
        double length2;
        int segment0;
        double t0 = u0;
        double t1 = u1;
        if (this.closed && (t1 < t0 || t1 > 1.0 || t0 > 1.0 || t0 < 0.0 || t1 < 0.0)) {
            double diff = t1 - t0;
            t0 = this.mod(t0, 1.0);
            if (Math.abs(diff) < 0.9999999999999998) {
                return diff > 0.0 ? ((t1 = t0 + diff) > 1.0 ? this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0)) : this.sub(t0, t1)) : ((t1 = t0 + diff) < 0.0 ? this.sub(t1 + 1.0, 1.0).plus(this.sub(0.0, t0)) : this.sub(t1, t0));
            }
            double d = t1 = diff < 0.0 ? t0 - 1.0 : t0 + 1.0;
            if (t1 > 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 - 1.0));
            }
            if (t1 < 1.0) {
                return this.sub(t0, 1.0).plus(this.sub(0.0, t1 + 1.0));
            }
        }
        t0 = RangesKt.coerceIn(t0, 0.0, 1.0);
        t1 = RangesKt.coerceIn(t1, 0.0, 1.0);
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z0 = t1;
            z1 = t0;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length2 = (double)this.segments.size()))) < this.segments.size() ? z0 * length2 % 1.0 : 1.0;
        int segment1 = (int)(z1 * length2);
        double segmentOffset1 = segment1 < this.segments.size() ? z1 * length2 % 1.0 : 1.0;
        segment1 = Math.min(this.segments.size() - 1, segment1);
        segment0 = Math.min(this.segments.size() - 1, segment0);
        boolean bl = false;
        List newSegments = new ArrayList();
        double epsilon = 1.0E-6;
        int n = segment0;
        int n2 = segment1;
        if (n <= n2) {
            while (true) {
                void s2;
                if (s2 == segment0 && s2 == segment1) {
                    newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, segmentOffset1));
                } else if (s2 == segment0) {
                    if (segmentOffset0 < 1.0 - epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(segmentOffset0, 1.0));
                    }
                } else if (s2 == segment1) {
                    if (segmentOffset1 > epsilon) {
                        newSegments.add(this.segments.get((int)s2).sub(0.0, segmentOffset1));
                    }
                } else {
                    newSegments.add(this.segments.get((int)s2));
                }
                if (s2 == n2) break;
                ++s2;
            }
        }
        return new Path3D(newSegments, false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector3 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        int n = 0;
        int n2 = this.segments.size();
        while (n < n2) {
            void i;
            Double st = this.segments.get((int)i).on(point, error);
            if (st != null) {
                return ((double)i + st) / (double)this.segments.size();
            }
            ++i;
        }
        return null;
    }

    public static /* synthetic */ Double on$default(Path3D path3D, Vector3 vector3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return path3D.on(vector3, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathProjection3D project(@NotNull Vector3 point) {
        Object v0;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        Iterable $this$mapIndexed$iv = this.segments;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void index;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment3D segment3D = (Segment3D)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair<Integer, SegmentProjection3D> pair = new Pair<Integer, SegmentProjection3D>((int)index, it.project(point));
            collection.add(pair);
        }
        Iterable $this$minBy$iv = (List)destination$iv$iv;
        boolean $i$f$minBy = false;
        Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v0 = minElem$iv$iv;
            } else {
                Pair it = (Pair)minElem$iv$iv;
                boolean bl = false;
                double minValue$iv$iv = ((SegmentProjection3D)it.getSecond()).getDistance();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    Pair it2 = (Pair)e$iv$iv;
                    $i$a$-minBy-Path3D$project$nearest$2 = false;
                    double v$iv$iv = ((SegmentProjection3D)it2.getSecond()).getDistance();
                    if (Double.compare(minValue$iv$iv, v$iv$iv) <= 0) continue;
                    minElem$iv$iv = e$iv$iv;
                    minValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v0 = minElem$iv$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        Pair nearest2 = v0;
        return new PathProjection3D((SegmentProjection3D)nearest2.getSecond(), (((Number)nearest2.getFirst()).doubleValue() + ((SegmentProjection3D)nearest2.getSecond()).getProjection()) / (double)this.segments.size(), ((SegmentProjection3D)nearest2.getSecond()).getDistance(), ((SegmentProjection3D)nearest2.getSecond()).getPoint());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D getReversed() {
        Collection<Segment3D> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.segments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Segment3D segment3D2 = it.getReverse();
            collection.add(segment3D2);
        }
        collection = (List)destination$iv$iv;
        boolean bl = this.closed;
        List<Segment3D> list = CollectionsKt.reversed((Iterable)collection);
        return new Path3D(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final double getLength() {
        void var3_3;
        Iterable $this$sumByDouble$iv = this.segments;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            Segment3D segment3D = (Segment3D)element$iv;
            double d = sum$iv;
            boolean bl = false;
            double d2 = it.getLength();
            sum$iv = d + d2;
        }
        return (double)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D map(boolean closed, @NotNull Function1<? super Segment3D, Segment3D> mapper) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Iterable $this$map$iv = this.segments;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(mapper.invoke((Segment3D)item$iv$iv));
        }
        List segments = (List)destination$iv$iv;
        $i$f$map = 0;
        List fixedSegments = new ArrayList();
        if (segments.size() > 1) {
            $i$f$map = 0;
            int $this$mapTo$iv$iv2 = segments.size() - 1;
            while ($i$f$map < $this$mapTo$iv$iv2) {
                void i;
                Segment3D left = (Segment3D)segments.get((int)i);
                Segment3D right = (Segment3D)segments.get((int)(i + true));
                Segment3D fixLeft = new Segment3D(left.getStart(), left.getControl(), right.getStart());
                fixedSegments.add(fixLeft);
                ++i;
            }
            if (closed) {
                Segment3D left = (Segment3D)CollectionsKt.last(segments);
                Segment3D right = (Segment3D)CollectionsKt.first(segments);
                fixedSegments.add(new Segment3D(left.getStart(), left.getControl(), right.getStart()));
            } else {
                fixedSegments.add(CollectionsKt.last(segments));
            }
        }
        return new Path3D(segments.size() > 1 ? fixedSegments : segments, closed);
    }

    public static /* synthetic */ Path3D map$default(Path3D path3D, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = path3D.closed;
        }
        return path3D.map(bl, function1);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrndr.shape.Path3D");
        }
        Path3D cfr_ignored_0 = (Path3D)object2;
        if (Intrinsics.areEqual(this.segments, ((Path3D)other).segments) ^ true) {
            return false;
        }
        return this.closed == ((Path3D)other).closed;
    }

    public int hashCode() {
        int result2 = ((Object)this.segments).hashCode();
        result2 = 31 * result2 + ((Object)this.closed).hashCode();
        return result2;
    }

    @NotNull
    public final List<Segment3D> getSegments() {
        return this.segments;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public Path3D(@NotNull List<Segment3D> segments, boolean closed) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        this.segments = segments;
        this.closed = closed;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/Path3D$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/Path3D;", "points", "", "Lorg/openrndr/math/Vector3;", "closed", "", "openrndr-core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path3D fromPoints(@NotNull List<Vector3> points, boolean closed) {
            Path3D path3D;
            Intrinsics.checkNotNullParameter(points, "points");
            if (!closed) {
                Collection<Segment3D> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, points.size() - 1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Segment3D segment3D = new Segment3D(points.get((int)it), points.get((int)(it + true)));
                    collection.add(segment3D);
                }
                collection = (List)destination$iv$iv;
                boolean bl = closed;
                List list = collection;
                path3D = new Path3D(list, bl);
            } else {
                Collection<Segment3D> collection;
                Iterable $this$map$iv = RangesKt.until(0, points.size());
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    int item$iv$iv;
                    int it = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Segment3D segment3D = new Segment3D(points.get(it), points.get((it + 1) % points.size()));
                    collection.add(segment3D);
                }
                collection = (List)destination$iv$iv;
                boolean bl = closed;
                List list = collection;
                path3D = new Path3D(list, bl);
            }
            return path3D;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

