/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.YPolarity;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J1\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\nJ\u0016\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u0018\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u0003J\t\u00107\u001a\u000208H\u00d6\u0001J\u000e\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000e\u00a8\u0006<"}, d2={"Lorg/openrndr/shape/OrientedRectangle;", "", "x", "", "y", "width", "height", "rotation", "(DDDDD)V", "corner", "Lorg/openrndr/math/Vector2;", "(Lorg/openrndr/math/Vector2;DDD)V", "area", "getArea", "()D", "center", "getCenter", "()Lorg/openrndr/math/Vector2;", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "getCorner", "dimensions", "getDimensions", "getHeight", "getRotation", "shape", "Lorg/openrndr/shape/Shape;", "getShape", "()Lorg/openrndr/shape/Shape;", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "heightScaledTo", "Lorg/openrndr/shape/Rectangle;", "fitHeight", "moved", "offset", "position", "u", "v", "scaled", "scale", "scaleY", "toString", "", "widthScaledTo", "fitWidth", "Companion", "openrndr-core"})
public final class OrientedRectangle {
    @NotNull
    private final Vector2 corner;
    private final double width;
    private final double height;
    private final double rotation;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Vector2 getCenter() {
        return this.corner.plus(new Vector2(this.width / (double)2, this.height / (double)2));
    }

    public final double getArea() {
        return this.width * this.height;
    }

    @NotNull
    public final Vector2 getDimensions() {
        return new Vector2(this.width, this.height);
    }

    @NotNull
    public final Vector2 position(double u, double v) {
        return this.corner.plus(new Vector2(u * this.width, v * this.height));
    }

    public final double getX() {
        return this.corner.getX();
    }

    public final double getY() {
        return this.corner.getY();
    }

    @NotNull
    public final Shape getShape() {
        return new Shape(CollectionsKt.listOf(this.getContour()));
    }

    @NotNull
    public final ShapeContour getContour() {
        ShapeContour shapeContour = ShapeContour.Companion.fromPoints(CollectionsKt.listOf(this.corner, this.corner.plus(new Vector2(this.width, 0.0)), this.corner.plus(new Vector2(this.width, this.height)), this.corner.plus(new Vector2(0.0, this.height))), true, YPolarity.CW_NEGATIVE_Y);
        boolean bl = false;
        boolean bl2 = false;
        ShapeContour $this$apply = shapeContour;
        boolean bl3 = false;
        Matrix44 t2 = TransformBuilderKt.transform$default(null, new Function1<TransformBuilder, Unit>(this){
            final /* synthetic */ OrientedRectangle this$0;
            {
                this.this$0 = orientedRectangle;
                super(1);
            }

            public final void invoke(@NotNull TransformBuilder $this$transform) {
                Intrinsics.checkNotNullParameter($this$transform, "$receiver");
                $this$transform.translate(this.this$0.getCenter());
                $this$transform.rotate(Vector3.Companion.getUNIT_Z(), this.this$0.getRotation());
                $this$transform.translate(this.this$0.getCenter().unaryMinus());
            }
        }, 1, null);
        $this$apply.transform(t2);
        return shapeContour;
    }

    @NotNull
    public final Rectangle scaled(double scale2, double scaleY) {
        return new Rectangle(this.corner, this.width * scale2, this.height * scaleY);
    }

    public static /* synthetic */ Rectangle scaled$default(OrientedRectangle orientedRectangle, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return orientedRectangle.scaled(d, d2);
    }

    @NotNull
    public final Rectangle widthScaledTo(double fitWidth) {
        double scale2 = fitWidth / this.width;
        return new Rectangle(this.corner, fitWidth, this.height * scale2);
    }

    @NotNull
    public final Rectangle heightScaledTo(double fitHeight) {
        double scale2 = fitHeight / this.height;
        return new Rectangle(this.corner, this.width * scale2, fitHeight);
    }

    @NotNull
    public final Rectangle moved(@NotNull Vector2 offset2) {
        Intrinsics.checkNotNullParameter(offset2, "offset");
        return new Rectangle(this.corner.plus(offset2), this.width, this.height);
    }

    @NotNull
    public final Vector2 getCorner() {
        return this.corner;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getRotation() {
        return this.rotation;
    }

    public OrientedRectangle(@NotNull Vector2 corner, double width, double height, double rotation) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.corner = corner;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
    }

    public OrientedRectangle(double x, double y, double width, double height, double rotation) {
        this(new Vector2(x, y), width, height, rotation);
    }

    @NotNull
    public final Vector2 component1() {
        return this.corner;
    }

    public final double component2() {
        return this.width;
    }

    public final double component3() {
        return this.height;
    }

    public final double component4() {
        return this.rotation;
    }

    @NotNull
    public final OrientedRectangle copy(@NotNull Vector2 corner, double width, double height, double rotation) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        return new OrientedRectangle(corner, width, height, rotation);
    }

    public static /* synthetic */ OrientedRectangle copy$default(OrientedRectangle orientedRectangle, Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = orientedRectangle.corner;
        }
        if ((n & 2) != 0) {
            d = orientedRectangle.width;
        }
        if ((n & 4) != 0) {
            d2 = orientedRectangle.height;
        }
        if ((n & 8) != 0) {
            d3 = orientedRectangle.rotation;
        }
        return orientedRectangle.copy(vector2, d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "OrientedRectangle(corner=" + this.corner + ", width=" + this.width + ", height=" + this.height + ", rotation=" + this.rotation + ")";
    }

    public int hashCode() {
        Vector2 vector2 = this.corner;
        long l = Double.doubleToLongBits(this.width);
        long l2 = Double.doubleToLongBits(this.height);
        long l3 = Double.doubleToLongBits(this.rotation);
        return (((vector2 != null ? ((Object)vector2).hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof OrientedRectangle)) break block3;
                OrientedRectangle orientedRectangle = (OrientedRectangle)object;
                if (!Intrinsics.areEqual(this.corner, orientedRectangle.corner) || Double.compare(this.width, orientedRectangle.width) != 0 || Double.compare(this.height, orientedRectangle.height) != 0 || Double.compare(this.rotation, orientedRectangle.rotation) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/OrientedRectangle$Companion;", "", "()V", "fromCenter", "Lorg/openrndr/shape/Rectangle;", "center", "Lorg/openrndr/math/Vector2;", "width", "", "height", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final Rectangle fromCenter(@NotNull Vector2 center, double width, double height) {
            Intrinsics.checkNotNullParameter(center, "center");
            return new Rectangle(center.getX() - width / 2.0, center.getY() - height / 2.0, width, height);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

