/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.ShaderGeneratorsGL3Kt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0003\u001aD\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0001H\u0007\u001a\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0003\u001a\u001c\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0007\u001a\u001a\u0010\u0015\u001a\u00020\u0001*\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"postTransform", "", "preTransform", "rotate2", "transformVaryingIn", "transformVaryingOut", "drawerUniforms", "contextBlock", "", "styleBlock", "fragmentConstants", "instance", "element", "screenPosition", "contourPosition", "boundsPosition", "boundsSize", "glslVersion", "primitiveTypes", "type", "vertexConstants", "trueOrEmpty", "f", "Lkotlin/Function0;", "openrndr-gl3"})
public final class ShaderGeneratorsGL3Kt {
    @Language(value="GLSL")
    private static final String rotate2 = "mat2 rotate2(float rotationInDegrees) {\n    float r = radians(rotationInDegrees);\n    float cr = cos(r);\n    float sr = sin(r);\n    return mat2(vec2(cr, sr), vec2(-sr, cr));\n}";
    @Language(value="GLSL")
    private static final String transformVaryingOut = "\n// -- transformVaryingOut    \nout vec3 v_worldNormal;\nout vec3 v_viewNormal;\nout vec3 v_worldPosition;\nout vec3 v_viewPosition;\nout vec4 v_clipPosition;\n\nflat out mat4 v_modelNormalMatrix;\n";
    @Language(value="GLSL")
    private static final String transformVaryingIn = "\n// -- transformVaryingIn\nin vec3 v_worldNormal;\nin vec3 v_viewNormal;\nin vec3 v_worldPosition;\nin vec3 v_viewPosition;\nin vec4 v_clipPosition;\nflat in mat4 v_modelNormalMatrix;\n";
    @Language(value="GLSL")
    private static final String preTransform = "\n    // -- preTransform\n    mat4 x_modelMatrix = u_modelMatrix;\n    mat4 x_viewMatrix = u_viewMatrix;\n    mat4 x_modelNormalMatrix = u_modelNormalMatrix;\n    mat4 x_viewNormalMatrix = u_viewNormalMatrix;\n    mat4 x_projectionMatrix = u_projectionMatrix;\n";
    private static final String postTransform = "\n    // -- postTransform\n    v_worldNormal = (x_modelNormalMatrix * vec4(x_normal,0.0)).xyz;\n    v_viewNormal = (x_viewNormalMatrix * vec4(v_worldNormal,0.0)).xyz;\n    v_worldPosition = (x_modelMatrix * vec4(x_position, 1.0)).xyz;\n    v_viewPosition = (x_viewMatrix * vec4(v_worldPosition, 1.0)).xyz;\n    v_clipPosition = x_projectionMatrix * vec4(v_viewPosition, 1.0);\n    v_modelNormalMatrix = x_modelNormalMatrix;\n";

    @NotNull
    public static final String glslVersion() {
        Driver driver = Driver.Companion.getInstance();
        if (driver == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.openrndr.internal.gl3.DriverGL3");
        }
        return ((DriverGL3)driver).getVersion().getGlslVersion();
    }

    @Language(value="GLSL")
    private static final String primitiveTypes(String type2) {
        return "\n// -- primitiveTypes\n#define d_vertex_buffer 0\n#define d_image 1\n#define d_circle 2\n#define d_rectangle 3\n#define d_font_image_map 4\n#define d_expansion 5\n#define d_fast_line 6\n#define d_mesh_line 7\n#define d_point 8\n#define d_primitive " + type2 + '\n';
    }

    @Language(value="GLSL")
    @NotNull
    public static final String vertexConstants(@NotNull String instance, @NotNull String element) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(element, "element");
        return StringsKt.trimMargin$default("\n|    int c_instance = " + instance + ";\n|    int c_element = " + element + ";\n", null, 1, null);
    }

    public static /* synthetic */ String vertexConstants$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gl_InstanceID";
        }
        if ((n & 2) != 0) {
            string2 = "0";
        }
        return ShaderGeneratorsGL3Kt.vertexConstants(string, string2);
    }

    @Language(value="GLSL")
    @NotNull
    public static final String fragmentConstants(@NotNull String instance, @NotNull String element, @NotNull String screenPosition, @NotNull String contourPosition, @NotNull String boundsPosition, @NotNull String boundsSize) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(screenPosition, "screenPosition");
        Intrinsics.checkNotNullParameter(contourPosition, "contourPosition");
        Intrinsics.checkNotNullParameter(boundsPosition, "boundsPosition");
        Intrinsics.checkNotNullParameter(boundsSize, "boundsSize");
        return StringsKt.trimMargin$default("\n|    // -- fragmentConstants\n|    int c_instance = " + instance + ";\n|    int c_element = " + element + ";\n|    vec2 c_screenPosition = " + screenPosition + ";\n|    float c_contourPosition = " + contourPosition + ";\n|    vec3 c_boundsPosition = " + boundsPosition + ";\n|    vec3 c_boundsSize = " + boundsSize + ";\n", null, 1, null);
    }

    public static /* synthetic */ String fragmentConstants$default(String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 1) != 0) {
            string = "v_instance";
        }
        if ((n & 2) != 0) {
            string2 = "0";
        }
        if ((n & 4) != 0) {
            string3 = "gl_FragCoord.xy / u_contentScale";
        }
        if ((n & 8) != 0) {
            string4 = "0";
        }
        if ((n & 0x10) != 0) {
            string5 = "vec3(0.0)";
        }
        if ((n & 0x20) != 0) {
            string6 = "vec3(0.0)";
        }
        return ShaderGeneratorsGL3Kt.fragmentConstants(string, string2, string3, string4, string5, string6);
    }

    private static final String trueOrEmpty(boolean $this$trueOrEmpty, Function0<String> f) {
        return $this$trueOrEmpty ? f.invoke() : "";
    }

    @Language(value="GLSL")
    private static final String drawerUniforms(boolean contextBlock2, boolean styleBlock2) {
        return "\n// -- drawerUniforms(" + contextBlock2 + ", " + styleBlock2 + ")    \n\n" + ShaderGeneratorsGL3Kt.trueOrEmpty(contextBlock2, drawerUniforms.1.INSTANCE) + '\n' + ShaderGeneratorsGL3Kt.trueOrEmpty(styleBlock2, drawerUniforms.2.INSTANCE) + '\n';
    }

    static /* synthetic */ String drawerUniforms$default(boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return ShaderGeneratorsGL3Kt.drawerUniforms(bl, bl2);
    }

    public static final /* synthetic */ String access$primitiveTypes(String type2) {
        return ShaderGeneratorsGL3Kt.primitiveTypes(type2);
    }

    public static final /* synthetic */ String access$getRotate2$p() {
        return rotate2;
    }
}

