/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.shapes.BezierPatch;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Segment;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u000e\u001a\u00020\r*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"bezierPatch", "Lorg/openrndr/extra/shapes/BezierPatch;", "corners", "", "Lorg/openrndr/math/Vector2;", "alpha", "", "c0", "Lorg/openrndr/shape/Segment;", "c1", "c2", "c3", "shapeContour", "Lorg/openrndr/shape/ShapeContour;", "distort", "referenceRectangle", "Lorg/openrndr/shape/Rectangle;", "map", "rect", "orx-shapes"})
public final class BezierPatchKt {
    @NotNull
    public static final BezierPatch bezierPatch(@NotNull Segment c0, @NotNull Segment c1, @NotNull Segment c2, @NotNull Segment c3) {
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(c2, "c2");
        Intrinsics.checkNotNullParameter(c3, "c3");
        Segment c0c = c0.getCubic();
        Segment c1c = c1.getCubic();
        Segment c2c = c2.getCubic();
        Segment c3c = c3.getCubic();
        List<Vector2> c0l = CollectionsKt.listOf(c0c.getStart(), c0c.getControl()[0], c0c.getControl()[1], c0c.getEnd());
        List<Vector2> c1l = CollectionsKt.listOf(c1c.getStart(), c1c.getControl()[0], c1c.getControl()[1], c1c.getEnd());
        List<Vector2> c2l = CollectionsKt.listOf(c2c.getStart(), c2c.getControl()[0], c2c.getControl()[1], c2c.getEnd());
        List<Vector2> c3l = CollectionsKt.listOf(c3c.getStart(), c3c.getControl()[0], c3c.getControl()[1], c3c.getEnd());
        return new BezierPatch(CollectionsKt.listOf(c0l, c1l, c2l, c3l));
    }

    @NotNull
    public static final BezierPatch bezierPatch(@NotNull ShapeContour shapeContour, double alpha) {
        Intrinsics.checkNotNullParameter(shapeContour, "shapeContour");
        boolean bl = shapeContour.getSegments().size() == 4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "contour needs exactly 4 segments (has " + shapeContour.getSegments().size() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Segment c0 = shapeContour.getSegments().get(0).getCubic();
        Segment c1 = shapeContour.getSegments().get(1).getCubic();
        Segment c2 = shapeContour.getSegments().get(2).getCubic();
        Segment c3 = shapeContour.getSegments().get(3).getCubic();
        double fa = 1.0 - alpha;
        double fb = alpha;
        Vector2 x00 = c0.getControl()[0].times(fa).plus(c2.getControl()[1].times(fb)).plus(c3.getControl()[1].times(fa)).plus(c1.getControl()[0].times(fb)).div(2.0);
        Vector2 x01 = c0.getControl()[1].times(fa).plus(c2.getControl()[0].times(fb)).plus(c3.getControl()[1].times(fb)).plus(c1.getControl()[0].times(fa)).div(2.0);
        Vector2 x10 = c0.getControl()[0].times(fb).plus(c2.getControl()[1].times(fa)).plus(c3.getControl()[0].times(fa)).plus(c1.getControl()[1].times(fb)).div(2.0);
        Vector2 x11 = c0.getControl()[1].times(fb).plus(c2.getControl()[0].times(fa)).plus(c3.getControl()[0].times(fb)).plus(c1.getControl()[1].times(fa)).div(2.0);
        List<List> cps = CollectionsKt.listOf(CollectionsKt.listOf(c0.getStart(), c0.getControl()[0], c0.getControl()[1], c0.getEnd()), CollectionsKt.listOf(c3.getControl()[1], x00, x01, c1.getControl()[0]), CollectionsKt.listOf(c3.getControl()[0], x10, x11, c1.getControl()[1]), CollectionsKt.listOf(c2.getEnd(), c2.getControl()[1], c2.getControl()[0], c2.getStart()));
        return new BezierPatch(cps);
    }

    public static /* synthetic */ BezierPatch bezierPatch$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.3333333333333333;
        }
        return BezierPatchKt.bezierPatch(shapeContour, d);
    }

    @NotNull
    public static final BezierPatch bezierPatch(@NotNull List<Vector2> corners, double alpha) {
        Intrinsics.checkNotNullParameter(corners, "corners");
        boolean bl = corners.size() == 4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "need exactly 4 corners (got " + corners.size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return BezierPatchKt.bezierPatch(ShapeContour.Companion.fromPoints$default(ShapeContour.Companion, corners, true, null, 4, null), alpha);
    }

    public static /* synthetic */ BezierPatch bezierPatch$default(List list, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.3333333333333333;
        }
        return BezierPatchKt.bezierPatch(list, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ShapeContour distort(@NotNull BezierPatch $this$distort, @NotNull ShapeContour shapeContour, @NotNull Rectangle referenceRectangle) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$distort, "$this$distort");
        Intrinsics.checkNotNullParameter(shapeContour, "shapeContour");
        Intrinsics.checkNotNullParameter(referenceRectangle, "referenceRectangle");
        Iterable $this$map$iv = shapeContour.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Segment c = it.getCubic();
            Vector2 e = BezierPatchKt.map(c.getEnd(), referenceRectangle);
            Vector2 c0 = BezierPatchKt.map(c.getControl()[0], referenceRectangle);
            Vector2 c1 = BezierPatchKt.map(c.getControl()[1], referenceRectangle);
            Vector2 s2 = BezierPatchKt.map(c.getStart(), referenceRectangle);
            Vector2 ne = $this$distort.position(e.getX(), e.getY());
            Vector2 ns = $this$distort.position(s2.getX(), s2.getY());
            Vector2 nc0 = $this$distort.position(c0.getX(), c0.getY());
            Vector2 nc1 = $this$distort.position(c1.getX(), c1.getY());
            Segment segment2 = new Segment(ns, nc0, nc1, ne, false, 16, null);
            collection.add(segment2);
        }
        List distortedSegments = (List)destination$iv$iv;
        return new ShapeContour(distortedSegments, shapeContour.getClosed(), shapeContour.getPolarity());
    }

    public static /* synthetic */ ShapeContour distort$default(BezierPatch bezierPatch, ShapeContour shapeContour, Rectangle rectangle, int n, Object object) {
        if ((n & 2) != 0) {
            rectangle = shapeContour.getBounds();
        }
        return BezierPatchKt.distort(bezierPatch, shapeContour, rectangle);
    }

    private static final Vector2 map(Vector2 $this$map, Rectangle rect) {
        double nx = ($this$map.getX() - rect.getX()) / rect.getWidth();
        double ny = ($this$map.getY() - rect.getY()) / rect.getHeight();
        return new Vector2(nx, ny);
    }
}

