/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.fx.blur;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Filter;
import org.openrndr.draw.FilterKt;
import org.openrndr.extra.fx.FilterToolsKt;
import org.openrndr.extra.fx.blur.BloomCombine;
import org.openrndr.extra.fx.blur.BloomDownscale;
import org.openrndr.extra.fx.blur.BloomUpscale;
import org.openrndr.extra.parameters.BooleanParameter;
import org.openrndr.extra.parameters.Description;
import org.openrndr.extra.parameters.DoubleParameter;
import org.openrndr.filter.color.ColorFiltersKt;
import org.openrndr.filter.color.Linearize;

@Description(title="MipBloom")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J)\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001a0<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001a0<H\u0016\u00a2\u0006\u0002\u0010>R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b'\u0010\u0013\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b-\u0010\u0013\u001a\u0004\b.\u0010\u0015\"\u0004\b/\u0010\u0017R\u001c\u00100\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006?"}, d2={"Lorg/openrndr/extra/fx/blur/MipBloom;", "T", "Lorg/openrndr/draw/Filter;", "blur", "(Lorg/openrndr/draw/Filter;)V", "getBlur", "()Lorg/openrndr/draw/Filter;", "Lorg/openrndr/draw/Filter;", "combine", "Lorg/openrndr/extra/fx/blur/BloomCombine;", "getCombine", "()Lorg/openrndr/extra/fx/blur/BloomCombine;", "downScale", "Lorg/openrndr/extra/fx/blur/BloomDownscale;", "getDownScale", "()Lorg/openrndr/extra/fx/blur/BloomDownscale;", "gain", "", "getGain$annotations", "()V", "getGain", "()D", "setGain", "(D)V", "intermediates", "", "Lorg/openrndr/draw/ColorBuffer;", "getIntermediates", "()Ljava/util/List;", "setIntermediates", "(Ljava/util/List;)V", "passes", "", "getPasses", "()I", "setPasses", "(I)V", "sRGB", "", "getSRGB$annotations", "getSRGB", "()Z", "setSRGB", "(Z)V", "shape", "getShape$annotations", "getShape", "setShape", "sourceCopy", "getSourceCopy", "()Lorg/openrndr/draw/ColorBuffer;", "setSourceCopy", "(Lorg/openrndr/draw/ColorBuffer;)V", "upscale", "Lorg/openrndr/extra/fx/blur/BloomUpscale;", "getUpscale", "()Lorg/openrndr/extra/fx/blur/BloomUpscale;", "apply", "", "source", "", "target", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "orx-fx"})
public class MipBloom<T extends Filter>
extends Filter {
    private int passes;
    private double shape;
    private double gain;
    private boolean sRGB;
    @NotNull
    private List<ColorBuffer> intermediates;
    @Nullable
    private ColorBuffer sourceCopy;
    @NotNull
    private final BloomUpscale upscale;
    @NotNull
    private final BloomDownscale downScale;
    @NotNull
    private final BloomCombine combine;
    @NotNull
    private final T blur;

    public final int getPasses() {
        return this.passes;
    }

    public final void setPasses(int n) {
        this.passes = n;
    }

    @DoubleParameter(label="shape", low=0.0, high=4.0)
    public static /* synthetic */ void getShape$annotations() {
    }

    public final double getShape() {
        return this.shape;
    }

    public final void setShape(double d) {
        this.shape = d;
    }

    @DoubleParameter(label="gain", low=0.0, high=4.0)
    public static /* synthetic */ void getGain$annotations() {
    }

    public final double getGain() {
        return this.gain;
    }

    public final void setGain(double d) {
        this.gain = d;
    }

    @BooleanParameter(label="sRGB")
    public static /* synthetic */ void getSRGB$annotations() {
    }

    public final boolean getSRGB() {
        return this.sRGB;
    }

    public final void setSRGB(boolean bl) {
        this.sRGB = bl;
    }

    @NotNull
    public final List<ColorBuffer> getIntermediates() {
        return this.intermediates;
    }

    public final void setIntermediates(@NotNull List<ColorBuffer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.intermediates = list;
    }

    @Nullable
    public final ColorBuffer getSourceCopy() {
        return this.sourceCopy;
    }

    public final void setSourceCopy(@Nullable ColorBuffer colorBuffer) {
        this.sourceCopy = colorBuffer;
    }

    @NotNull
    public final BloomUpscale getUpscale() {
        return this.upscale;
    }

    @NotNull
    public final BloomDownscale getDownScale() {
        return this.downScale;
    }

    @NotNull
    public final BloomCombine getCombine() {
        return this.combine;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target2) {
        int $i$f$forEach;
        block13: {
            block12: {
                boolean bl;
                boolean bl2;
                Object object;
                Intrinsics.checkNotNullParameter(source, "source");
                Intrinsics.checkNotNullParameter(target2, "target");
                ColorBuffer colorBuffer = this.sourceCopy;
                if (colorBuffer != null) {
                    object = colorBuffer;
                    bl2 = false;
                    bl = false;
                    ColorBuffer it = object;
                    boolean bl3 = false;
                    if (!ColorBuffer.DefaultImpls.isEquivalentTo$default(it, source[0], false, false, false, false, true, false, false, 222, null)) {
                        it.destroy();
                        this.sourceCopy = null;
                    }
                }
                if (this.sourceCopy == null) {
                    this.sourceCopy = ColorBuffer.DefaultImpls.createEquivalent$default(source[0], 0, 0, 0.0, null, ColorType.FLOAT16, null, 0, 111, null);
                }
                ColorBuffer colorBuffer2 = source[0];
                ColorBuffer colorBuffer3 = this.sourceCopy;
                Intrinsics.checkNotNull(colorBuffer3);
                ColorBuffer.DefaultImpls.copyTo$default(colorBuffer2, colorBuffer3, 0, 0, null, null, null, 62, null);
                this.upscale.setShape(this.shape);
                if (this.intermediates.size() != this.passes) break block12;
                object = this.intermediates;
                bl2 = false;
                if (!(!object.isEmpty())) break block13;
                boolean bl4 = false;
                bl2 = false;
                bl = true;
                boolean it = true;
                if (ColorBuffer.DefaultImpls.isEquivalentTo$default(this.intermediates.get(0), target2[0], false, false, false, bl, it, bl2, bl4, 206, null)) break block13;
            }
            Iterable $this$forEach$iv22 = this.intermediates;
            $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv22) {
                ColorBuffer it = (ColorBuffer)element$iv;
                boolean bl = false;
                it.destroy();
            }
            this.intermediates.clear();
            int $this$forEach$iv22 = 0;
            $i$f$forEach = this.passes;
            while ($this$forEach$iv22 < $i$f$forEach) {
                void pass;
                int tdiv = 1 << pass + true;
                ColorBuffer cb = ColorBufferKt.colorBuffer$default(target2[0].getWidth() / tdiv, target2[0].getHeight() / tdiv, 0.0, null, ColorType.FLOAT16, null, 0, null, 236, null);
                this.intermediates.add(cb);
                ++pass;
            }
        }
        if (this.sRGB) {
            Linearize linearize2 = ColorFiltersKt.getLinearize();
            ColorBuffer colorBuffer = this.sourceCopy;
            Intrinsics.checkNotNull(colorBuffer);
            ColorBuffer colorBuffer4 = this.sourceCopy;
            Intrinsics.checkNotNull(colorBuffer4);
            linearize2.apply(colorBuffer, colorBuffer4);
        }
        ColorBuffer colorBuffer = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer);
        this.downScale.apply(colorBuffer, this.intermediates.get(0));
        ((Filter)this.blur).apply(this.intermediates.get(0), this.intermediates.get(0));
        $i$f$forEach = this.passes;
        for (int pass = 1; pass < $i$f$forEach; ++pass) {
            this.downScale.apply(this.intermediates.get(pass - 1), this.intermediates.get(pass));
            ((Filter)this.blur).apply(this.intermediates.get(pass), this.intermediates.get(pass));
        }
        Collection $this$toTypedArray$iv = this.intermediates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ColorBuffer[] colorBufferArray = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.upscale.apply(colorBufferArray, new ColorBuffer[]{target2[0]});
        this.combine.setGain(this.gain);
        ColorBuffer[] colorBufferArray2 = new ColorBuffer[2];
        ColorBuffer colorBuffer5 = this.sourceCopy;
        Intrinsics.checkNotNull(colorBuffer5);
        colorBufferArray2[0] = colorBuffer5;
        colorBufferArray2[1] = target2[0];
        this.combine.apply(colorBufferArray2, target2);
        if (this.sRGB) {
            ColorFiltersKt.getDelinearize().apply(target2[0], target2[0]);
        }
    }

    @NotNull
    public final T getBlur() {
        return this.blur;
    }

    public MipBloom(@NotNull T blur) {
        Intrinsics.checkNotNullParameter(blur, "blur");
        super(FilterKt.filterShaderFromUrl(FilterToolsKt.filterFragmentUrl("blur/bloom-combine.frag")), null, 2, null);
        this.blur = blur;
        this.passes = 6;
        this.shape = 1.0;
        this.gain = 1.0;
        this.sRGB = true;
        boolean bl = false;
        this.intermediates = new ArrayList();
        this.upscale = new BloomUpscale();
        this.downScale = new BloomDownscale();
        this.combine = new BloomCombine();
    }
}

