/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.exceptions;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"stackRootClassName", "", "thread", "Ljava/lang/Thread;", "sanitize", "", "openrndr-core"})
public final class StacktraceToolsKt {
    @NotNull
    public static final String stackRootClassName(@NotNull Thread thread2, boolean sanitize) {
        String string;
        Intrinsics.checkNotNullParameter(thread2, "thread");
        Thread thread3 = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue(thread3, "Thread.currentThread()");
        StackTraceElement[] stackTraceElementArray = thread3.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "Thread.currentThread().stackTrace");
        StackTraceElement stackTraceElement = ArraysKt.last(stackTraceElementArray);
        Intrinsics.checkNotNullExpressionValue(stackTraceElement, "Thread.currentThread().stackTrace.last()");
        String rootClass = stackTraceElement.getClassName();
        if (sanitize) {
            String string2 = rootClass;
            Intrinsics.checkNotNullExpressionValue(string2, "rootClass");
            CharSequence charSequence = string2;
            Regex regex = new Regex("Kt$");
            String string3 = "";
            boolean bl = false;
            string = regex.replace(charSequence, string3);
        } else {
            String string4 = rootClass;
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "rootClass");
        }
        return string;
    }

    public static /* synthetic */ String stackRootClassName$default(Thread thread2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            Thread thread3 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread3, "Thread.currentThread()");
            thread2 = thread3;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return StacktraceToolsKt.stackRootClassName(thread2, bl);
    }
}

