/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BatchBuilder;
import org.openrndr.draw.BatchesKt;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RectangleBatch;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0010J\u0014\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/draw/RectangleBatchBuilder;", "Lorg/openrndr/draw/BatchBuilder;", "drawer", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "entries", "", "Lorg/openrndr/draw/RectangleBatchBuilder$Entry;", "getEntries", "()Ljava/util/List;", "batch", "Lorg/openrndr/draw/RectangleBatch;", "existingBatch", "rectangle", "", "x", "", "y", "width", "height", "rotationInDegrees", "corner", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/Rectangle;", "rectangles", "", "Entry", "openrndr-core"})
public final class RectangleBatchBuilder
extends BatchBuilder {
    @NotNull
    private final List<Entry> entries;

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    public final void rectangle(double x, double y, double width, double height, double rotationInDegrees) {
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), new Vector3(x, y, 0.0), new Vector2(width, height), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, double d, double d2, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        rectangleBatchBuilder.rectangle(d, d2, d3, d4, d5);
    }

    public final void rectangle(@NotNull Vector2 corner, double width, double height, double rotationInDegrees) {
        Intrinsics.checkNotNullParameter(corner, "corner");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), corner.getXy0(), new Vector2(width, height), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        rectangleBatchBuilder.rectangle(vector2, d, d2, d3);
    }

    public final void rectangle(@NotNull Rectangle rectangle, double rotationInDegrees) {
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        this.entries.add(new Entry(this.getFill(), this.getStroke(), this.getStrokeWeight(), rectangle.getCorner().getXy0(), new Vector2(rectangle.getWidth(), rectangle.getHeight()), rotationInDegrees));
    }

    public static /* synthetic */ void rectangle$default(RectangleBatchBuilder rectangleBatchBuilder, Rectangle rectangle, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        rectangleBatchBuilder.rectangle(rectangle, d);
    }

    public final void rectangles(@NotNull List<Rectangle> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, "rectangles");
        for (Rectangle rectangle : rectangles) {
            RectangleBatchBuilder.rectangle$default(this, rectangle, 0.0, 2, null);
        }
    }

    @NotNull
    public final RectangleBatch batch(@Nullable RectangleBatch existingBatch) {
        Object object = existingBatch;
        if (object == null || (object = ((RectangleBatch)object).getGeometry()) == null) {
            object = VertexBufferKt.vertexBuffer$default(BatchesKt.getRectangleFormat(), this.entries.size(), null, 4, null);
        }
        Object geometry = object;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)geometry, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ RectangleBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    $this$put.write(entry.getOffset());
                    $this$put.write(entry.getDimensions());
                    $this$put.write((float)entry.getRotation());
                }
            }
            {
                this.this$0 = rectangleBatchBuilder;
                super(1);
            }
        }, 1, null);
        Object object2 = existingBatch;
        if (object2 == null || (object2 = ((RectangleBatch)object2).getDrawStyle()) == null) {
            object2 = VertexBufferKt.vertexBuffer$default(BatchesKt.getDrawStyleFormat(), this.entries.size(), null, 4, null);
        }
        Object drawStyle = object2;
        VertexBuffer.DefaultImpls.put$default((VertexBuffer)drawStyle, 0, new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ RectangleBatchBuilder this$0;

            public final void invoke(@NotNull BufferWriter $this$put) {
                Intrinsics.checkNotNullParameter($this$put, "$receiver");
                for (Entry entry : this.this$0.getEntries()) {
                    ColorRGBa colorRGBa = entry.getFill();
                    if (colorRGBa == null) {
                        colorRGBa = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa);
                    ColorRGBa colorRGBa2 = entry.getStroke();
                    if (colorRGBa2 == null) {
                        colorRGBa2 = ColorRGBa.Companion.getTRANSPARENT();
                    }
                    $this$put.write(colorRGBa2);
                    $this$put.write(entry.getStroke() == null ? 0.0f : (float)entry.getStrokeWeight());
                }
            }
            {
                this.this$0 = rectangleBatchBuilder;
                super(1);
            }
        }, 1, null);
        RectangleBatch rectangleBatch = existingBatch;
        if (rectangleBatch == null) {
            rectangleBatch = new RectangleBatch((VertexBuffer)geometry, (VertexBuffer)drawStyle);
        }
        return rectangleBatch;
    }

    public static /* synthetic */ RectangleBatch batch$default(RectangleBatchBuilder rectangleBatchBuilder, RectangleBatch rectangleBatch, int n, Object object) {
        if ((n & 1) != 0) {
            rectangleBatch = null;
        }
        return rectangleBatchBuilder.batch(rectangleBatch);
    }

    public RectangleBatchBuilder(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        super(drawer);
        boolean bl = false;
        this.entries = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/draw/RectangleBatchBuilder$Entry;", "", "fill", "Lorg/openrndr/color/ColorRGBa;", "stroke", "strokeWeight", "", "offset", "Lorg/openrndr/math/Vector3;", "dimensions", "Lorg/openrndr/math/Vector2;", "rotation", "(Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/color/ColorRGBa;DLorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector2;D)V", "getDimensions", "()Lorg/openrndr/math/Vector2;", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "getOffset", "()Lorg/openrndr/math/Vector3;", "getRotation", "()D", "getStroke", "getStrokeWeight", "openrndr-core"})
    public static final class Entry {
        @Nullable
        private final ColorRGBa fill;
        @Nullable
        private final ColorRGBa stroke;
        private final double strokeWeight;
        @NotNull
        private final Vector3 offset;
        @NotNull
        private final Vector2 dimensions;
        private final double rotation;

        @Nullable
        public final ColorRGBa getFill() {
            return this.fill;
        }

        @Nullable
        public final ColorRGBa getStroke() {
            return this.stroke;
        }

        public final double getStrokeWeight() {
            return this.strokeWeight;
        }

        @NotNull
        public final Vector3 getOffset() {
            return this.offset;
        }

        @NotNull
        public final Vector2 getDimensions() {
            return this.dimensions;
        }

        public final double getRotation() {
            return this.rotation;
        }

        public Entry(@Nullable ColorRGBa fill2, @Nullable ColorRGBa stroke, double strokeWeight, @NotNull Vector3 offset2, @NotNull Vector2 dimensions, double rotation) {
            Intrinsics.checkNotNullParameter(offset2, "offset");
            Intrinsics.checkNotNullParameter(dimensions, "dimensions");
            this.fill = fill2;
            this.stroke = stroke;
            this.strokeWeight = strokeWeight;
            this.offset = offset2;
            this.dimensions = dimensions;
            this.rotation = rotation;
        }
    }
}

