/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferTextureFileFormat;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Session;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a&\u0010\n\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0013"}, d2={"bufferTexture", "Lorg/openrndr/draw/BufferTexture;", "elementCount", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "session", "Lorg/openrndr/draw/Session;", "loadBufferTexture", "file", "Ljava/io/File;", "formatHint", "Lorg/openrndr/draw/BufferTextureFileFormat;", "url", "Ljava/net/URL;", "fileOrUrl", "", "openrndr-core"})
public final class BufferTextureKt {
    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull String fileOrUrl, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(fileOrUrl, "fileOrUrl");
        try {
            if (!StringsKt.startsWith$default(fileOrUrl, "data:", false, 2, null)) {
                URL url = new URL(fileOrUrl);
                return BufferTextureKt.loadBufferTexture(url, formatHint, session);
            }
            String string = "data scheme not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        catch (MalformedURLException e) {
            BufferTexture bufferTexture = BufferTextureKt.loadBufferTexture$default(new File(fileOrUrl), null, session, 2, null);
            return bufferTexture;
        }
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(String string, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(string, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull File file, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(file, "file");
        boolean bl = file.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "file " + file.getAbsolutePath() + " does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        ByteBuffer header = ByteBuffer.allocateDirect(12);
        header.order(ByteOrder.nativeOrder());
        FileChannel chan = raf.getChannel();
        chan.read(header);
        header.rewind();
        ByteBuffer byteBuffer = header;
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "header");
        int size = byteBuffer.getInt();
        ColorFormat format = ColorFormat.values()[header.getInt()];
        ColorType type2 = ColorType.values()[header.getInt()];
        ByteBuffer buffer2 = ByteBuffer.allocateDirect(size);
        buffer2.order(ByteOrder.nativeOrder());
        chan.read(buffer2);
        chan.close();
        int elementCount = size / (format.getComponentCount() * type2.getComponentSize());
        BufferTexture bufferTexture = BufferTextureKt.bufferTexture(elementCount, format, type2, session);
        buffer2.rewind();
        ByteBuffer byteBuffer2 = buffer2;
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "buffer");
        BufferTexture.DefaultImpls.write$default(bufferTexture, byteBuffer2, 0, 0, 6, null);
        return bufferTexture;
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(File file, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(file, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture loadBufferTexture(@NotNull URL url, @Nullable BufferTextureFileFormat formatHint, @Nullable Session session) {
        Intrinsics.checkNotNullParameter(url, "url");
        InputStream stream = url.openStream();
        byte[] headerData = new byte[12];
        stream.read(headerData);
        ByteBuffer header = ByteBuffer.wrap(headerData);
        header.order(ByteOrder.nativeOrder());
        header.rewind();
        ByteBuffer byteBuffer = header;
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "header");
        int size = byteBuffer.getInt();
        ColorFormat format = ColorFormat.values()[header.getInt()];
        ColorType type2 = ColorType.values()[header.getInt()];
        ByteBuffer buffer2 = ByteBuffer.allocateDirect(size);
        buffer2.order(ByteOrder.nativeOrder());
        byte[] bodyData = new byte[size];
        ByteBuffer body = ByteBuffer.wrap(bodyData);
        stream.read(bodyData);
        body.rewind();
        buffer2.rewind();
        buffer2.put(body);
        buffer2.rewind();
        int elementCount = size / (format.getComponentCount() * type2.getComponentSize());
        BufferTexture bufferTexture = BufferTextureKt.bufferTexture(elementCount, format, type2, session);
        ByteBuffer byteBuffer2 = buffer2;
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "buffer");
        BufferTexture.DefaultImpls.write$default(bufferTexture, byteBuffer2, 0, 0, 6, null);
        return bufferTexture;
    }

    public static /* synthetic */ BufferTexture loadBufferTexture$default(URL uRL, BufferTextureFileFormat bufferTextureFileFormat, Session session, int n, Object object) {
        if ((n & 2) != 0) {
            bufferTextureFileFormat = BufferTextureFileFormat.ORB;
        }
        if ((n & 4) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.loadBufferTexture(uRL, bufferTextureFileFormat, session);
    }

    @NotNull
    public static final BufferTexture bufferTexture(int elementCount, @NotNull ColorFormat format, @NotNull ColorType type2, @Nullable Session session) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return BufferTexture.Companion.create(elementCount, format, type2, session);
    }

    public static /* synthetic */ BufferTexture bufferTexture$default(int n, ColorFormat colorFormat, ColorType colorType, Session session, int n2, Object object) {
        if ((n2 & 2) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n2 & 4) != 0) {
            colorType = ColorType.FLOAT32;
        }
        if ((n2 & 8) != 0) {
            session = Session.Companion.getActive();
        }
        return BufferTextureKt.bufferTexture(n, colorFormat, colorType, session);
    }
}

