/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorLCHUVaKt;
import org.openrndr.color.ColorLSHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.OpacifiableColor;
import org.openrndr.color.ShadableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u00012B1\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0007H\u0096\u0002J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lorg/openrndr/color/ColorLCHUVa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/OpacifiableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "c", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "getAlpha", "()D", "getC", "getH", "getL", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "minus", "mix", "factor", "opacify", "plus", "shade", "shiftHue", "shiftInDegrees", "times", "toLSHUVa", "Lorg/openrndr/color/ColorLSHUVa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "Companion", "openrndr-color"})
public final class ColorLCHUVa
implements ConvertibleToColorRGBa,
ShadableColor<ColorLCHUVa>,
OpacifiableColor<ColorLCHUVa>,
HueShiftableColor<ColorLCHUVa>,
AlgebraicColor<ColorLCHUVa> {
    private final double l;
    private final double c;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorLUVa toLUVa() {
        double d = Math.toRadians(this.h);
        boolean bl = false;
        double u = this.c * Math.cos(d);
        double d2 = Math.toRadians(this.h);
        boolean bl2 = false;
        double v = this.c * Math.sin(d2);
        return new ColorLUVa(this.l, u, v, this.alpha, this.ref);
    }

    @NotNull
    public final ColorLSHUVa toLSHUVa() {
        return ColorLSHUVa.Companion.fromLCHUVa(this);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toLUVa().toRGBa();
    }

    @Override
    @NotNull
    public ColorLCHUVa opacify(double factor) {
        return ColorLCHUVa.copy$default(this, 0.0, 0.0, 0.0, this.alpha * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa shade(double factor) {
        return ColorLCHUVa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa shiftHue(double shiftInDegrees) {
        return ColorLCHUVa.copy$default(this, 0.0, 0.0, this.h + shiftInDegrees, 0.0, null, 27, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa plus(@NotNull ColorLCHUVa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHUVa.copy$default(this, this.l + other.l, this.c + other.c, this.h + other.h, this.alpha + other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa minus(@NotNull ColorLCHUVa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHUVa.copy$default(this, this.l - other.l, this.c - other.c, this.h - other.h, this.alpha - other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa times(double factor) {
        return ColorLCHUVa.copy$default(this, this.l * factor, this.c * factor, this.h * factor, this.alpha * factor, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLCHUVa mix(@NotNull ColorLCHUVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLCHUVaKt.mix(this, other, factor);
    }

    public final double getL() {
        return this.l;
    }

    public final double getC() {
        return this.c;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa getRef() {
        return this.ref;
    }

    public ColorLCHUVa(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLCHUVa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    @Override
    @NotNull
    public ColorLCHUVa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.c;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLCHUVa copy(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLCHUVa(l, c, h, alpha, ref);
    }

    public static /* synthetic */ ColorLCHUVa copy$default(ColorLCHUVa colorLCHUVa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLCHUVa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLCHUVa.c;
        }
        if ((n & 4) != 0) {
            d3 = colorLCHUVa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorLCHUVa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLCHUVa.ref;
        }
        return colorLCHUVa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLCHUVa(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.l);
        long l2 = Double.doubleToLongBits(this.c);
        long l3 = Double.doubleToLongBits(this.h);
        long l4 = Double.doubleToLongBits(this.alpha);
        ColorXYZa colorXYZa = this.ref;
        return ((((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (colorXYZa != null ? ((Object)colorXYZa).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorLCHUVa)) break block3;
                ColorLCHUVa colorLCHUVa = (ColorLCHUVa)object;
                if (Double.compare(this.l, colorLCHUVa.l) != 0 || Double.compare(this.c, colorLCHUVa.c) != 0 || Double.compare(this.h, colorLCHUVa.h) != 0 || Double.compare(this.alpha, colorLCHUVa.alpha) != 0 || !Intrinsics.areEqual(this.ref, colorLCHUVa.ref)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/color/ColorLCHUVa$Companion;", "", "()V", "findMaxChroma", "", "l", "h", "ref", "Lorg/openrndr/color/ColorXYZa;", "fromLUVa", "Lorg/openrndr/color/ColorLCHUVa;", "luva", "Lorg/openrndr/color/ColorLUVa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorLCHUVa fromLUVa(@NotNull ColorLUVa luva) {
            Intrinsics.checkNotNullParameter(luva, "luva");
            double l = luva.getL();
            double d = luva.getU() * luva.getU() + luva.getV() * luva.getV();
            boolean bl = false;
            double c = Math.sqrt(d);
            double d2 = luva.getV();
            double d3 = luva.getU();
            boolean bl2 = false;
            double h = Math.atan2(d2, d3);
            if (h < 0.0) {
                h += Math.PI * 2;
            }
            h = Math.toDegrees(h);
            return new ColorLCHUVa(l, c, h, luva.getAlpha(), luva.getRef());
        }

        public final double findMaxChroma(double l, double h, @NotNull ColorXYZa ref) {
            boolean rightValid;
            boolean middleValid;
            boolean leftValid;
            Intrinsics.checkNotNullParameter(ref, "ref");
            double left = 0.0;
            double right = 2000.0;
            double bestGuess = left;
            do {
                if (right - left < 1.0E-4) {
                    return bestGuess;
                }
                ColorLCHUVa leftTry = new ColorLCHUVa(l, left, h, 1.0, ref);
                ColorLCHUVa rightTry = new ColorLCHUVa(l, right, h, 1.0, ref);
                double middle = (left + right) / (double)2;
                ColorLCHUVa middleTry = new ColorLCHUVa(l, middle, h, 1.0, ref);
                ColorRGBa colorRGBa = leftTry.toRGBa();
                boolean bl = false;
                boolean bl2 = false;
                ColorRGBa it = colorRGBa;
                boolean bl3 = false;
                leftValid = it.getMinValue() >= 0.0 && it.getMaxValue() <= 1.0;
                ColorRGBa colorRGBa2 = rightTry.toRGBa();
                bl2 = false;
                boolean bl4 = false;
                ColorRGBa it22 = colorRGBa2;
                boolean bl5 = false;
                rightValid = it22.getMinValue() >= 0.0 && it22.getMaxValue() <= 1.0;
                ColorRGBa colorRGBa3 = middleTry.toRGBa();
                bl4 = false;
                boolean it22 = false;
                ColorRGBa it3 = colorRGBa3;
                boolean bl6 = false;
                boolean bl7 = middleValid = it3.getMinValue() >= 0.0 && it3.getMaxValue() <= 1.0;
                if (leftValid && middleValid && !rightValid) {
                    double newLeft = middle;
                    double newRight = right;
                    bestGuess = middle;
                    left = newLeft;
                    right = newRight;
                }
                if (!leftValid || middleValid || rightValid) continue;
                double newLeft = left;
                double newRight = middle;
                left = newLeft;
                right = newRight;
            } while (leftValid != middleValid || middleValid != rightValid);
            return bestGuess;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

