/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABaKt;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLSHABa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.OpacifiableColor;
import org.openrndr.color.ShadableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 52\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u00015B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u000201H\u0016J\t\u00102\u001a\u000203H\u00d6\u0001J\u0006\u00104\u001a\u00020\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00066"}, d2={"Lorg/openrndr/color/ColorLABa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/OpacifiableColor;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/AlgebraicColor;", "l", "", "a", "b", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "getA", "()D", "getAlpha", "getB", "getL", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "minus", "opacify", "factor", "plus", "shade", "times", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLSHABa", "Lorg/openrndr/color/ColorLSHABa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXYZa", "Companion", "openrndr-color"})
public final class ColorLABa
implements ConvertibleToColorRGBa,
OpacifiableColor<ColorLABa>,
ShadableColor<ColorLABa>,
AlgebraicColor<ColorLABa> {
    private final double l;
    private final double a;
    private final double b;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorXYZa toXYZa() {
        double d;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        ColorLABa lab = this;
        double fy = (lab.l + 16.0) / 116.0;
        double fx = lab.a / 500.0 + fy;
        double fz = fy - lab.b / 200.0;
        double d2 = x = fx * fx * fx > 0.008856 ? fx * fx * fx : ((double)116 * fx - (double)16) / 903.3;
        if (lab.l > 7.9996247999999985) {
            double d3 = (lab.l + (double)16) / 116.0;
            double d4 = 3.0;
            boolean bl = false;
            d = Math.pow(d3, d4);
        } else {
            d = lab.l / 903.3;
        }
        y = d;
        z = fz * fz * fz > 0.008856 ? fz * fz * fz : (116.0 * fz - 16.0) / 903.3;
        return new ColorXYZa(x *= this.ref.getX(), y *= this.ref.getY(), z *= this.ref.getZ(), this.alpha);
    }

    @NotNull
    public final ColorLCHABa toLCHABa() {
        return ColorLCHABa.Companion.fromLABa(this);
    }

    @NotNull
    public final ColorLSHABa toLSHABa() {
        return this.toLCHABa().toLSHABa();
    }

    @NotNull
    public final ColorLUVa toLUVa() {
        return this.toXYZa().toLUVa(this.ref);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        return this.toXYZa().toRGBa();
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toXYZa().toRGBa().toHSVa();
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return this.toXYZa().toRGBa().toHSLa();
    }

    @Override
    @NotNull
    public ColorLABa opacify(double factor) {
        return ColorLABa.copy$default(this, 0.0, 0.0, 0.0, this.alpha * factor, null, 23, null);
    }

    @Override
    @NotNull
    public ColorLABa shade(double factor) {
        return ColorLABa.copy$default(this, this.l * factor, 0.0, 0.0, 0.0, null, 30, null);
    }

    @Override
    @NotNull
    public ColorLABa plus(@NotNull ColorLABa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLABa.copy$default(this, this.l + other.l, this.a + other.a, this.b + other.b, this.alpha + other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLABa minus(@NotNull ColorLABa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorLABa.copy$default(this, this.l - other.l, this.a - other.a, this.b - other.b, this.alpha - other.alpha, null, 16, null);
    }

    @Override
    @NotNull
    public ColorLABa times(double factor) {
        return ColorLABa.copy$default(this, this.l * factor, this.a * factor, this.b * factor, this.alpha * factor, null, 16, null);
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa getRef() {
        return this.ref;
    }

    public ColorLABa(double l, double a2, double b, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.l = l;
        this.a = a2;
        this.b = b;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLABa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    @Override
    @NotNull
    public ColorLABa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    @Override
    @NotNull
    public ColorLABa mix(@NotNull ColorLABa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return (ColorLABa)AlgebraicColor.DefaultImpls.mix(this, (AlgebraicColor)other, factor);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLABa copy(double l, double a2, double b, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return new ColorLABa(l, a2, b, alpha, ref);
    }

    public static /* synthetic */ ColorLABa copy$default(ColorLABa colorLABa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLABa.a;
        }
        if ((n & 4) != 0) {
            d3 = colorLABa.b;
        }
        if ((n & 8) != 0) {
            d4 = colorLABa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLABa.ref;
        }
        return colorLABa.copy(d, d2, d3, d4, colorXYZa);
    }

    @NotNull
    public String toString() {
        return "ColorLABa(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.l);
        long l2 = Double.doubleToLongBits(this.a);
        long l3 = Double.doubleToLongBits(this.b);
        long l4 = Double.doubleToLongBits(this.alpha);
        ColorXYZa colorXYZa = this.ref;
        return ((((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (colorXYZa != null ? ((Object)colorXYZa).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorLABa)) break block3;
                ColorLABa colorLABa = (ColorLABa)object;
                if (Double.compare(this.l, colorLABa.l) != 0 || Double.compare(this.a, colorLABa.a) != 0 || Double.compare(this.b, colorLABa.b) != 0 || Double.compare(this.alpha, colorLABa.alpha) != 0 || !Intrinsics.areEqual(this.ref, colorLABa.ref)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/color/ColorLABa$Companion;", "", "()V", "fromRGBa", "Lorg/openrndr/color/ColorLABa;", "rgba", "Lorg/openrndr/color/ColorRGBa;", "ref", "Lorg/openrndr/color/ColorXYZa;", "fromXYZa", "xyz", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorLABa fromXYZa(@NotNull ColorXYZa xyz, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(xyz, "xyz");
            Intrinsics.checkNotNullParameter(ref, "ref");
            double x = xyz.getX() / ref.getX();
            double y = xyz.getY() / ref.getY();
            double z = xyz.getZ() / ref.getZ();
            double l = (double)116 * ColorLABaKt.access$f(y) - 16.0;
            double a2 = (double)500 * (ColorLABaKt.access$f(x) - ColorLABaKt.access$f(y));
            double b = (double)200 * (ColorLABaKt.access$f(y) - ColorLABaKt.access$f(z));
            return new ColorLABa(l, a2, b, xyz.getA(), ref);
        }

        @NotNull
        public final ColorLABa fromRGBa(@NotNull ColorRGBa rgba, @NotNull ColorXYZa ref) {
            Intrinsics.checkNotNullParameter(rgba, "rgba");
            Intrinsics.checkNotNullParameter(ref, "ref");
            return this.fromXYZa(ColorXYZa.Companion.fromRGBa(rgba), ref);
        }

        public static /* synthetic */ ColorLABa fromRGBa$default(Companion companion, ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
            if ((n & 2) != 0) {
                colorXYZa = ColorXYZa.Companion.getNEUTRAL();
            }
            return companion.fromRGBa(colorRGBa, colorXYZa);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

