/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSVaKt;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSVa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.Linearity;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;
import org.openrndr.math.FunctionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 /2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u0001/B'\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0006\u0010-\u001a\u00020.R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u00060"}, d2={"Lorg/openrndr/color/ColorHSVa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/AlgebraicColor;", "h", "", "s", "v", "a", "(DDDD)V", "getA", "()D", "getH", "getS", "unit", "getUnit", "()Lorg/openrndr/color/ColorHSVa;", "getV", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "minus", "mix", "factor", "plus", "saturate", "shade", "shiftHue", "shiftInDegrees", "times", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXSVa", "Lorg/openrndr/color/ColorXSVa;", "Companion", "openrndr-color"})
public final class ColorHSVa
implements ConvertibleToColorRGBa,
ShadableColor<ColorHSVa>,
HueShiftableColor<ColorHSVa>,
SaturatableColor<ColorHSVa>,
AlgebraicColor<ColorHSVa> {
    private final double h;
    private final double s;
    private final double v;
    private final double a;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorHSVa invoke(double h, double s2, double v, double a2) {
        return new ColorHSVa(h, s2, v, a2);
    }

    public static /* synthetic */ ColorHSVa invoke$default(ColorHSVa colorHSVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSVa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorHSVa.a;
        }
        return colorHSVa.invoke(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public ColorHSVa shiftHue(double shiftInDegrees) {
        return ColorHSVa.copy$default(this, this.h + shiftInDegrees, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorHSVa saturate(double factor) {
        return ColorHSVa.copy$default(this, 0.0, this.s * factor, 0.0, 0.0, 13, null);
    }

    @Override
    @NotNull
    public ColorHSVa shade(double factor) {
        return ColorHSVa.copy$default(this, 0.0, 0.0, this.v * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorHSVa mix(@NotNull ColorHSVa other, double factor) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorHSVaKt.mix(this, other, factor);
    }

    @NotNull
    public final ColorHSVa getUnit() {
        return ColorHSVa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        int i = 0;
        double f = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        ColorHSVa hsv = this;
        double sh = FunctionsKt.mod(hsv.h, 360.0) / (double)60;
        i = (int)Math.floor(sh);
        f = sh - (double)i;
        double p = hsv.v * (1.0 - hsv.s);
        double q = hsv.v * (1.0 - hsv.s * f);
        double t2 = hsv.v * (1.0 - hsv.s * (1.0 - f));
        if (this.s > 1.0E-5) {
            switch (i) {
                case 0: {
                    r = hsv.v;
                    g = t2;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = hsv.v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = hsv.v;
                    b = t2;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = hsv.v;
                    break;
                }
                case 4: {
                    r = t2;
                    g = p;
                    b = hsv.v;
                    break;
                }
                default: {
                    r = hsv.v;
                    g = p;
                    b = q;
                    break;
                }
            }
        } else {
            r = hsv.v;
            g = hsv.v;
            b = hsv.v;
        }
        return new ColorRGBa(r, g, b, hsv.a, Linearity.SRGB);
    }

    @Override
    @NotNull
    public ColorHSVa plus(@NotNull ColorHSVa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.h + other.h, this.s + other.s, this.v + other.v, this.a + other.a);
    }

    @Override
    @NotNull
    public ColorHSVa minus(@NotNull ColorHSVa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.h - other.h, this.s - other.s, this.v - other.v, this.a - other.a);
    }

    @Override
    @NotNull
    public ColorHSVa times(double factor) {
        return this.copy(this.h * factor, this.s * factor, this.v * factor, this.a * factor);
    }

    @NotNull
    public final ColorXSVa toXSVa() {
        return ColorXSVa.Companion.fromHSVa(this);
    }

    public final double getH() {
        return this.h;
    }

    public final double getS() {
        return this.s;
    }

    public final double getV() {
        return this.v;
    }

    public final double getA() {
        return this.a;
    }

    public ColorHSVa(double h, double s2, double v, double a2) {
        this.h = h;
        this.s = s2;
        this.v = v;
        this.a = a2;
    }

    public /* synthetic */ ColorHSVa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public ColorHSVa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.v;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorHSVa copy(double h, double s2, double v, double a2) {
        return new ColorHSVa(h, s2, v, a2);
    }

    public static /* synthetic */ ColorHSVa copy$default(ColorHSVa colorHSVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSVa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorHSVa.a;
        }
        return colorHSVa.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorHSVa(h=" + this.h + ", s=" + this.s + ", v=" + this.v + ", a=" + this.a + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.h);
        long l2 = Double.doubleToLongBits(this.s);
        long l3 = Double.doubleToLongBits(this.v);
        long l4 = Double.doubleToLongBits(this.a);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorHSVa)) break block3;
                ColorHSVa colorHSVa = (ColorHSVa)object;
                if (Double.compare(this.h, colorHSVa.h) != 0 || Double.compare(this.s, colorHSVa.s) != 0 || Double.compare(this.v, colorHSVa.v) != 0 || Double.compare(this.a, colorHSVa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorHSVa$Companion;", "", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSVa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorHSVa fromRGBa(@NotNull ColorRGBa rgb) {
            Intrinsics.checkNotNullParameter(rgb, "rgb");
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            double h = 0.0;
            ColorRGBa.Component maxArg = null;
            if (rgb.getR() <= rgb.getB() && rgb.getR() <= rgb.getG()) {
                min = rgb.getR();
            }
            if (rgb.getG() <= rgb.getB() && rgb.getG() <= rgb.getR()) {
                min = rgb.getG();
            }
            if (rgb.getB() <= rgb.getR() && rgb.getB() <= rgb.getG()) {
                min = rgb.getB();
            }
            if (rgb.getR() >= rgb.getB() && rgb.getR() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = rgb.getR();
            }
            if (rgb.getG() >= rgb.getB() && rgb.getG() >= rgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = rgb.getG();
            }
            if (rgb.getB() >= rgb.getR() && rgb.getB() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.B;
                max = rgb.getB();
            }
            double s2 = 0.0;
            double v = max;
            double delta = max - min;
            if (max == 0.0) {
                s2 = 0.0;
                h = 0.0;
                return new ColorHSVa(h, s2, v, rgb.getA());
            }
            s2 = delta / max;
            h = maxArg == ColorRGBa.Component.R ? (rgb.getG() - rgb.getB()) / delta : (maxArg == ColorRGBa.Component.G ? (double)2 + (rgb.getB() - rgb.getR()) / delta : (double)4 + (rgb.getR() - rgb.getG()) / delta);
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
            return new ColorHSVa(h, s2, v, rgb.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

