/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.AlgebraicColor;
import org.openrndr.color.ColorHSLa$Companion$WhenMappings;
import org.openrndr.color.ColorHSLaKt;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.ConvertibleToColorRGBa;
import org.openrndr.color.HueShiftableColor;
import org.openrndr.color.Linearity;
import org.openrndr.color.SaturatableColor;
import org.openrndr.color.ShadableColor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 =2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u0001=B'\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0096\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0002012\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00102\u001a\u0002032\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00104\u001a\u0002052\b\b\u0002\u0010.\u001a\u00020/J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016J\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020/R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006>"}, d2={"Lorg/openrndr/color/ColorHSLa;", "Lorg/openrndr/color/ConvertibleToColorRGBa;", "Lorg/openrndr/color/ShadableColor;", "Lorg/openrndr/color/HueShiftableColor;", "Lorg/openrndr/color/SaturatableColor;", "Lorg/openrndr/color/AlgebraicColor;", "h", "", "s", "l", "a", "(DDDD)V", "getA", "()D", "getH", "getL", "getS", "unit", "getUnit", "()Lorg/openrndr/color/ColorHSLa;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "invoke", "minus", "mix", "x", "plus", "saturate", "factor", "shade", "shiftHue", "shiftInDegrees", "times", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "Lorg/openrndr/color/ColorXYZa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXSLa", "Lorg/openrndr/color/ColorXSLa;", "toXYZa", "Companion", "openrndr-color"})
public final class ColorHSLa
implements ConvertibleToColorRGBa,
ShadableColor<ColorHSLa>,
HueShiftableColor<ColorHSLa>,
SaturatableColor<ColorHSLa>,
AlgebraicColor<ColorHSLa> {
    private final double h;
    private final double s;
    private final double l;
    private final double a;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorHSLa invoke(double h, double s2, double l, double a2) {
        return new ColorHSLa(h, s2, l, a2);
    }

    public static /* synthetic */ ColorHSLa invoke$default(ColorHSLa colorHSLa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSLa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSLa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSLa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorHSLa.a;
        }
        return colorHSLa.invoke(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ColorHSL{h=" + this.h + ", s=" + this.s + ", l=" + this.l + '}';
    }

    @Override
    @NotNull
    public ColorHSLa shiftHue(double shiftInDegrees) {
        return ColorHSLa.copy$default(this, this.h + shiftInDegrees, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorHSLa saturate(double factor) {
        return ColorHSLa.copy$default(this, 0.0, this.s * factor, 0.0, 0.0, 13, null);
    }

    @Override
    @NotNull
    public ColorHSLa shade(double factor) {
        return ColorHSLa.copy$default(this, 0.0, 0.0, this.l * factor, 0.0, 11, null);
    }

    @Override
    @NotNull
    public ColorHSLa mix(@NotNull ColorHSLa other, double x) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ColorHSLaKt.mix(this, other, x);
    }

    @NotNull
    public final ColorHSLa getUnit() {
        return ColorHSLa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @Override
    @NotNull
    public ColorRGBa toRGBa() {
        ColorRGBa colorRGBa;
        if (this.s == 0.0) {
            colorRGBa = new ColorRGBa(this.l, this.l, this.l, this.a, null, 16, null);
        } else {
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double p = (double)2 * this.l - q;
            double r = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 + 0.3333333333333333);
            double g = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0);
            double b = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 - 0.3333333333333333);
            colorRGBa = new ColorRGBa(r, g, b, this.a, Linearity.SRGB);
        }
        return colorRGBa;
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toRGBa().toHSVa();
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toRGBa().toXYZa();
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toRGBa().toXYZa().toLABa(ref);
    }

    public static /* synthetic */ ColorLABa toLABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toRGBa().toXYZa().toLUVa(ref);
    }

    public static /* synthetic */ ColorLUVa toLUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLUVa(colorXYZa);
    }

    @NotNull
    public final ColorLCHABa toLCHABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toLABa(ref).toLCHABa();
    }

    public static /* synthetic */ ColorLCHABa toLCHABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        return this.toLUVa(ref).toLCHUVa();
    }

    public static /* synthetic */ ColorLCHUVa toLCHUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHUVa(colorXYZa);
    }

    @NotNull
    public final ColorXSLa toXSLa() {
        return ColorXSLa.Companion.fromHSLa(this);
    }

    @Override
    @NotNull
    public ColorHSLa plus(@NotNull ColorHSLa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.h + other.h, this.s + other.s, this.l + other.l, this.a + other.a);
    }

    @Override
    @NotNull
    public ColorHSLa minus(@NotNull ColorHSLa other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.copy(this.h - other.h, this.s - other.s, this.l - other.l, this.a - other.a);
    }

    @Override
    @NotNull
    public ColorHSLa times(double factor) {
        return this.copy(this.h * factor, this.s * factor, this.l * factor, this.a * factor);
    }

    public final double getH() {
        return this.h;
    }

    public final double getS() {
        return this.s;
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public ColorHSLa(double h, double s2, double l, double a2) {
        this.h = h;
        this.s = s2;
        this.l = l;
        this.a = a2;
    }

    public /* synthetic */ ColorHSLa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public ColorHSLa div(double factor) {
        return AlgebraicColor.DefaultImpls.div(this, factor);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorHSLa copy(double h, double s2, double l, double a2) {
        return new ColorHSLa(h, s2, l, a2);
    }

    public static /* synthetic */ ColorHSLa copy$default(ColorHSLa colorHSLa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSLa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSLa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSLa.l;
        }
        if ((n & 8) != 0) {
            d4 = colorHSLa.a;
        }
        return colorHSLa.copy(d, d2, d3, d4);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.h);
        long l2 = Double.doubleToLongBits(this.s);
        long l3 = Double.doubleToLongBits(this.l);
        long l4 = Double.doubleToLongBits(this.a);
        return (((int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorHSLa)) break block3;
                ColorHSLa colorHSLa = (ColorHSLa)object;
                if (Double.compare(this.h, colorHSLa.h) != 0 || Double.compare(this.s, colorHSLa.s) != 0 || Double.compare(this.l, colorHSLa.l) != 0 || Double.compare(this.a, colorHSLa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorHSLa$Companion;", "", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSLa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorHSLa fromRGBa(@NotNull ColorRGBa rgb) {
            Intrinsics.checkNotNullParameter(rgb, "rgb");
            double min = rgb.getR() <= rgb.getB() && rgb.getR() <= rgb.getG() ? rgb.getR() : (rgb.getG() <= rgb.getB() && rgb.getG() <= rgb.getR() ? rgb.getG() : (rgb.getB() <= rgb.getR() && rgb.getB() <= rgb.getG() ? rgb.getB() : 0.0));
            double max = 0.0;
            ColorRGBa.Component maxArg = null;
            if (rgb.getR() >= rgb.getB() && rgb.getR() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = rgb.getR();
            } else if (rgb.getG() >= rgb.getB() && rgb.getG() >= rgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = rgb.getG();
            } else {
                maxArg = ColorRGBa.Component.B;
                max = rgb.getB();
            }
            double l = (max + min) / 2.0;
            double s2 = 0.0;
            double h = 0.0;
            if (max == min) {
                h = s2 = 0.0;
            } else {
                double d;
                double d2 = max - min;
                s2 = l > 0.5 ? d2 / (2.0 - max - min) : d2 / (max + min);
                switch (ColorHSLa$Companion$WhenMappings.$EnumSwitchMapping$0[maxArg.ordinal()]) {
                    case 1: {
                        d = 60.0 * ((rgb.getG() - rgb.getB()) / d2 + (double)(rgb.getG() < rgb.getB() ? 6 : 0));
                        break;
                    }
                    case 2: {
                        d = 60.0 * ((rgb.getB() - rgb.getR()) / d2 + 2.0);
                        break;
                    }
                    case 3: {
                        d = 60.0 * ((rgb.getR() - rgb.getG()) / d2 + 4.0);
                        break;
                    }
                    case 4: {
                        d = 0.0;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                h = d;
            }
            return new ColorHSLa(h, s2, l, rgb.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

