/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.tinyexr.EXRTile;

public class EXRImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TILES;
    public static final int IMAGES;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int NUM_CHANNELS;
    public static final int NUM_TILES;

    public EXRImage(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), EXRImage.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="EXRTile *")
    public EXRTile.Buffer tiles() {
        return EXRImage.ntiles(this.address());
    }

    @Nullable
    @NativeType(value="unsigned char **")
    public PointerBuffer images() {
        return EXRImage.nimages(this.address());
    }

    public int width() {
        return EXRImage.nwidth(this.address());
    }

    public int height() {
        return EXRImage.nheight(this.address());
    }

    public int num_channels() {
        return EXRImage.nnum_channels(this.address());
    }

    public int num_tiles() {
        return EXRImage.nnum_tiles(this.address());
    }

    public EXRImage tiles(@Nullable @NativeType(value="EXRTile *") EXRTile.Buffer value) {
        EXRImage.ntiles(this.address(), value);
        return this;
    }

    public EXRImage images(@Nullable @NativeType(value="unsigned char **") PointerBuffer value) {
        EXRImage.nimages(this.address(), value);
        return this;
    }

    public EXRImage width(int value) {
        EXRImage.nwidth(this.address(), value);
        return this;
    }

    public EXRImage height(int value) {
        EXRImage.nheight(this.address(), value);
        return this;
    }

    public EXRImage num_channels(int value) {
        EXRImage.nnum_channels(this.address(), value);
        return this;
    }

    public EXRImage set(@Nullable EXRTile.Buffer tiles, @Nullable PointerBuffer images, int width, int height, int num_channels) {
        this.tiles(tiles);
        this.images(images);
        this.width(width);
        this.height(height);
        this.num_channels(num_channels);
        return this;
    }

    public EXRImage set(EXRImage src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EXRImage malloc() {
        return EXRImage.wrap(EXRImage.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static EXRImage calloc() {
        return EXRImage.wrap(EXRImage.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static EXRImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return EXRImage.wrap(EXRImage.class, MemoryUtil.memAddress(container), container);
    }

    public static EXRImage create(long address) {
        return EXRImage.wrap(EXRImage.class, address);
    }

    @Nullable
    public static EXRImage createSafe(long address) {
        return address == 0L ? null : EXRImage.wrap(EXRImage.class, address);
    }

    public static Buffer malloc(int capacity) {
        return EXRImage.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(EXRImage.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EXRImage.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRImage.__create(capacity, SIZEOF);
        return EXRImage.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return EXRImage.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : EXRImage.wrap(Buffer.class, address, capacity);
    }

    public static EXRImage mallocStack() {
        return EXRImage.mallocStack(MemoryStack.stackGet());
    }

    public static EXRImage callocStack() {
        return EXRImage.callocStack(MemoryStack.stackGet());
    }

    public static EXRImage mallocStack(MemoryStack stack) {
        return EXRImage.wrap(EXRImage.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRImage callocStack(MemoryStack stack) {
        return EXRImage.wrap(EXRImage.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EXRImage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EXRImage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRImage.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRImage.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static EXRTile.Buffer ntiles(long struct) {
        return EXRTile.createSafe(MemoryUtil.memGetAddress(struct + (long)TILES), EXRImage.nnum_tiles(struct));
    }

    @Nullable
    public static PointerBuffer nimages(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)IMAGES), EXRImage.nnum_channels(struct));
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nnum_channels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_CHANNELS);
    }

    public static int nnum_tiles(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_TILES);
    }

    public static void ntiles(long struct, @Nullable EXRTile.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)TILES, MemoryUtil.memAddressSafe(value));
        EXRImage.nnum_tiles(struct, value == null ? 0 : value.remaining());
    }

    public static void nimages(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)IMAGES, MemoryUtil.memAddressSafe(value));
        EXRImage.nnum_channels(struct, value == null ? 0 : value.remaining());
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nnum_channels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_CHANNELS, value);
    }

    public static void nnum_tiles(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_TILES, value);
    }

    public static void validate(long struct) {
        int num_tiles = EXRImage.nnum_tiles(struct);
        if (num_tiles != 0) {
            long tiles = MemoryUtil.memGetAddress(struct + (long)TILES);
            Checks.check(tiles);
            EXRTile.validate(tiles, num_tiles);
        }
    }

    public static void validate(long array, int count2) {
        for (int i = 0; i < count2; ++i) {
            EXRImage.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = EXRImage.__struct(EXRImage.__member(POINTER_SIZE), EXRImage.__member(POINTER_SIZE), EXRImage.__member(4), EXRImage.__member(4), EXRImage.__member(4), EXRImage.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TILES = layout.offsetof(0);
        IMAGES = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        NUM_CHANNELS = layout.offsetof(4);
        NUM_TILES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<EXRImage, Buffer>
    implements NativeResource {
        private static final EXRImage ELEMENT_FACTORY = EXRImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected EXRImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="EXRTile *")
        public EXRTile.Buffer tiles() {
            return EXRImage.ntiles(this.address());
        }

        @Nullable
        @NativeType(value="unsigned char **")
        public PointerBuffer images() {
            return EXRImage.nimages(this.address());
        }

        public int width() {
            return EXRImage.nwidth(this.address());
        }

        public int height() {
            return EXRImage.nheight(this.address());
        }

        public int num_channels() {
            return EXRImage.nnum_channels(this.address());
        }

        public int num_tiles() {
            return EXRImage.nnum_tiles(this.address());
        }

        public Buffer tiles(@Nullable @NativeType(value="EXRTile *") EXRTile.Buffer value) {
            EXRImage.ntiles(this.address(), value);
            return this;
        }

        public Buffer images(@Nullable @NativeType(value="unsigned char **") PointerBuffer value) {
            EXRImage.nimages(this.address(), value);
            return this;
        }

        public Buffer width(int value) {
            EXRImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            EXRImage.nheight(this.address(), value);
            return this;
        }

        public Buffer num_channels(int value) {
            EXRImage.nnum_channels(this.address(), value);
            return this;
        }
    }
}

