/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRStreamAttrib {
    protected KHRStreamAttrib() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateStreamAttribKHR, caps.eglSetStreamAttribKHR, caps.eglQueryStreamAttribKHR, caps.eglStreamConsumerAcquireAttribKHR, caps.eglStreamConsumerReleaseAttribKHR);
    }

    public static long neglCreateStreamAttribKHR(long dpy, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(dpy, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLStreamKHR")
    public static long eglCreateStreamAttribKHR(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglCreateStreamAttribKHR(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglSetStreamAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLAttrib") long value) {
        long __functionAddress = EGL.getCapabilities().eglSetStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress) != 0;
    }

    public static int neglQueryStreamAttribKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attribute, value, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryStreamAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @NativeType(value="EGLenum") int attribute, @NativeType(value="EGLAttrib *") PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return KHRStreamAttrib.neglQueryStreamAttribKHR(dpy, stream, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglStreamConsumerAcquireAttribKHR(long dpy, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamConsumerAcquireAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamConsumerAcquireAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglStreamConsumerAcquireAttribKHR(dpy, stream, MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }

    public static int neglStreamConsumerReleaseAttribKHR(long dpy, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamConsumerReleaseAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(dpy, stream, attrib_list, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglStreamConsumerReleaseAttribKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLStreamKHR") long stream, @Nullable @NativeType(value="EGLAttrib const *") PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglStreamConsumerReleaseAttribKHR(dpy, stream, MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }
}

