/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.callbacks;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jouvieje.bass.callbacks.BPMBEATPROC;
import jouvieje.bass.callbacks.BPMPROC;
import jouvieje.bass.callbacks.BPMPROCESSPROC;
import jouvieje.bass.callbacks.CallbackManager;
import jouvieje.bass.callbacks.DOWNLOADPROC;
import jouvieje.bass.callbacks.DSPPROC;
import jouvieje.bass.callbacks.ENCODECLIENTPROC;
import jouvieje.bass.callbacks.ENCODENOTIFYPROC;
import jouvieje.bass.callbacks.ENCODEPROC;
import jouvieje.bass.callbacks.ENCODEPROCEX;
import jouvieje.bass.callbacks.FILECLOSEPROC;
import jouvieje.bass.callbacks.FILELENPROC;
import jouvieje.bass.callbacks.FILEREADPROC;
import jouvieje.bass.callbacks.FILESEEKPROC;
import jouvieje.bass.callbacks.MIDIINPROC;
import jouvieje.bass.callbacks.RECORDPROC;
import jouvieje.bass.callbacks.STREAMPROC;
import jouvieje.bass.callbacks.SYNCPROC;
import jouvieje.bass.structures.HDSP;
import jouvieje.bass.structures.HENCODE;
import jouvieje.bass.structures.HRECORD;
import jouvieje.bass.structures.HSTREAM;
import jouvieje.bass.structures.HSYNC;
import jouvieje.bass.utils.Pointer;

class CallbackBridge
extends Pointer {
    protected static final int NB_CALLBACKS = 17;

    CallbackBridge() {
    }

    public static void BPMBEATPROC_BRIDGE(int chan, double beatpos, long user) {
        BPMBEATPROC callback = (BPMBEATPROC)CallbackManager.getCallback(0, chan, false);
        try {
            callback.BPMBEATPROC(chan, beatpos, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void BPMPROC_BRIDGE(int chan, float bpm, long user) {
        BPMPROC callback = (BPMPROC)CallbackManager.getCallback(1, chan, false);
        try {
            callback.BPMPROC(chan, bpm, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void BPMPROCESSPROC_BRIDGE(int chan, float percent) {
        BPMPROCESSPROC callback = (BPMPROCESSPROC)CallbackManager.getCallback(2, chan, false);
        try {
            callback.BPMPROCESSPROC(chan, percent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void DOWNLOADPROC_BRIDGE(ByteBuffer buffer2, int length2, long user) {
        DOWNLOADPROC callback = (DOWNLOADPROC)CallbackManager.getCallback(3);
        if (buffer2 != null) {
            buffer2.order(ByteOrder.nativeOrder());
        }
        try {
            callback.DOWNLOADPROC(buffer2, length2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void DSPPROC_BRIDGE(long handle, int channel, ByteBuffer buffer2, int length2, long user) {
        DSPPROC callback = (DSPPROC)CallbackManager.getCallback(4, handle, false);
        if (buffer2 != null) {
            buffer2.order(ByteOrder.nativeOrder());
        }
        try {
            callback.DSPPROC(handle == 0L ? null : HDSP.asHDSP(Pointer.newPointer(handle)), channel, buffer2, length2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean ENCODECLIENTPROC_BRIDGE(long handle, boolean connect, String client, String headers, long user) {
        ENCODECLIENTPROC callback = (ENCODECLIENTPROC)CallbackManager.getCallback(5, handle, false);
        try {
            boolean javaResult = callback.ENCODECLIENTPROC(handle == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(handle)), connect, client, headers, user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void ENCODENOTIFYPROC_BRIDGE(long handle, int status, long user) {
        ENCODENOTIFYPROC callback = (ENCODENOTIFYPROC)CallbackManager.getCallback(6, handle, false);
        try {
            callback.ENCODENOTIFYPROC(handle == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(handle)), status, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void ENCODEPROC_BRIDGE(long handle, int channel, long buffer2, int length2, long user) {
        ENCODEPROC callback = (ENCODEPROC)CallbackManager.getCallback(7, handle, false);
        try {
            callback.ENCODEPROC(handle == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(handle)), channel, buffer2 == 0L ? null : Pointer.newPointer(buffer2), length2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void ENCODEPROCEX_BRIDGE(long handle, int channel, long buffer2, int length2, long offset2, long user) {
        ENCODEPROCEX callback = (ENCODEPROCEX)CallbackManager.getCallback(8, handle, false);
        try {
            callback.ENCODEPROCEX(handle == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(handle)), channel, buffer2 == 0L ? null : Pointer.newPointer(buffer2), length2, offset2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void FILECLOSEPROC_BRIDGE(long user) {
        FILECLOSEPROC callback = (FILECLOSEPROC)CallbackManager.getCallback(9, user, false);
        try {
            callback.FILECLOSEPROC(user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static long FILELENPROC_BRIDGE(long user) {
        FILELENPROC callback = (FILELENPROC)CallbackManager.getCallback(10, user, false);
        try {
            long javaResult = callback.FILELENPROC(user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    public static int FILEREADPROC_BRIDGE(long buffer2, int length2, long user) {
        FILEREADPROC callback = (FILEREADPROC)CallbackManager.getCallback(11, buffer2, false);
        try {
            int javaResult = callback.FILEREADPROC(buffer2 == 0L ? null : Pointer.newPointer(buffer2), length2, user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public static boolean FILESEEKPROC_BRIDGE(long offset2, long user) {
        FILESEEKPROC callback = (FILESEEKPROC)CallbackManager.getCallback(12, offset2, false);
        try {
            boolean javaResult = callback.FILESEEKPROC(offset2, user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void MIDIINPROC_BRIDGE(int device, double time2, long buffer2, int length2, long user) {
        MIDIINPROC callback = (MIDIINPROC)CallbackManager.getCallback(13, device, false);
        try {
            callback.MIDIINPROC(device, time2, buffer2 == 0L ? null : Pointer.newPointer(buffer2), length2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean RECORDPROC_BRIDGE(long handle, ByteBuffer buffer2, int length2, long user) {
        RECORDPROC callback = (RECORDPROC)CallbackManager.getCallback(14, handle, false);
        if (buffer2 != null) {
            buffer2.order(ByteOrder.nativeOrder());
        }
        try {
            boolean javaResult = callback.RECORDPROC(handle == 0L ? null : HRECORD.asHRECORD(Pointer.newPointer(handle)), buffer2, length2, user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static int STREAMPROC_BRIDGE(long handle, ByteBuffer buffer2, int length2, long user) {
        STREAMPROC callback = (STREAMPROC)CallbackManager.getCallback(15, handle, false);
        if (buffer2 != null) {
            buffer2.order(ByteOrder.nativeOrder());
        }
        try {
            int javaResult = callback.STREAMPROC(handle == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(handle)), buffer2, length2, user == 0L ? null : Pointer.newPointer(user));
            return javaResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public static void SYNCPROC_BRIDGE(long handle, int channel, int data2, long user) {
        SYNCPROC callback = (SYNCPROC)CallbackManager.getCallback(16, handle, false);
        try {
            callback.SYNCPROC(handle == 0L ? null : HSYNC.asHSYNC(Pointer.newPointer(handle)), channel, data2, user == 0L ? null : Pointer.newPointer(user));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static String getCallbackName(int type2) {
        switch (type2) {
            case 0: {
                return "BPMBEATPROC";
            }
            case 1: {
                return "BPMPROC";
            }
            case 2: {
                return "BPMPROCESSPROC";
            }
            case 3: {
                return "DOWNLOADPROC";
            }
            case 4: {
                return "DSPPROC";
            }
            case 5: {
                return "ENCODECLIENTPROC";
            }
            case 6: {
                return "ENCODENOTIFYPROC";
            }
            case 7: {
                return "ENCODEPROC";
            }
            case 8: {
                return "ENCODEPROCEX";
            }
            case 9: {
                return "FILECLOSEPROC";
            }
            case 10: {
                return "FILELENPROC";
            }
            case 11: {
                return "FILEREADPROC";
            }
            case 12: {
                return "FILESEEKPROC";
            }
            case 13: {
                return "MIDIINPROC";
            }
            case 14: {
                return "RECORDPROC";
            }
            case 15: {
                return "STREAMPROC";
            }
            case 16: {
                return "SYNCPROC";
            }
        }
        return "UNKNOW_" + type2;
    }
}

