/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

import io.lacuna.bifurcan.utils.Bits;

public final class BitVector {
    public static long[] create(int length2) {
        return new long[(Math.max(0, length2 - 1) >> 6) + 1];
    }

    public static long[] clone(long[] vector) {
        long[] nVector = new long[vector.length];
        System.arraycopy(vector, 0, nVector, 0, vector.length);
        return nVector;
    }

    public static boolean test(long[] vector, int bitIndex) {
        return (vector[bitIndex >> 6] & 1L << (bitIndex & 0x3F)) != 0L;
    }

    public static long[] interleave(int bitLen, long[] vectors) {
        long[] interleaved = BitVector.create(bitLen * vectors.length);
        int offset2 = (interleaved.length << 6) - 1;
        for (int i = 0; i < bitLen; ++i) {
            long mask = 1L << i;
            for (int j = vectors.length - 1; j >= 0; --j) {
                long val = (vectors[j] & mask) >>> i;
                int n = offset2 >> 6;
                interleaved[n] = interleaved[n] | val << 63 - (offset2 & 0x3F);
                --offset2;
            }
        }
        return interleaved;
    }

    public static int branchingBit(long[] a2, long[] b, int aIdx, int bIdx, int bitOffset, int bitLen) {
        long mask = Bits.maskAbove(bitOffset & 0x3F);
        int branch = Bits.branchingBit(a2[aIdx] & mask, b[bIdx] & mask);
        if (branch >= 0) {
            return branch;
        }
        ++aIdx;
        ++bIdx;
        int branchIdx = 64 - bitOffset;
        int len = (bitLen - (bitOffset + 1) >> 6) + 1;
        for (int i = 0; i < len; ++i) {
            branch = Bits.branchingBit(a2[aIdx + i], b[bIdx + 1]);
            if (branch >= 0) {
                return branchIdx + branch;
            }
            branchIdx += 64;
        }
        return branchIdx > bitLen ? -1 : branchIdx;
    }

    public static long get(long[] vector, int offset2, int len) {
        int idx = offset2 >> 6;
        int bitIdx = offset2 & 0x3F;
        int truncatedLen = Math.min(len, 64 - bitIdx);
        long val = vector[idx] >>> bitIdx & Bits.maskBelow(truncatedLen);
        if (len != truncatedLen) {
            val |= (vector[idx + 1] & Bits.maskBelow(len - truncatedLen)) << truncatedLen;
        }
        return val;
    }

    public static void overwrite(long[] vector, long val, int offset2, int len) {
        int idx = offset2 >> 6;
        int bitIdx = offset2 & 0x3F;
        int truncatedValLen = Math.min(len, 64 - bitIdx);
        int n = idx;
        vector[n] = vector[n] & (Bits.maskBelow(truncatedValLen) << bitIdx ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = idx;
        vector[n2] = vector[n2] | val << bitIdx;
        if (len != truncatedValLen) {
            long mask = Bits.maskBelow(len - truncatedValLen);
            int n3 = idx + 1;
            vector[n3] = vector[n3] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = idx + 1;
            vector[n4] = vector[n4] | val >>> truncatedValLen;
        }
    }

    public static void overwrite(long[] vector, int bitIdx, boolean flag) {
        long mask = 1L << (bitIdx & 0x3F);
        if (flag) {
            int n = bitIdx >> 6;
            vector[n] = vector[n] | mask;
        } else {
            int n = bitIdx >> 6;
            vector[n] = vector[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static void copy(long[] src, int srcOffset, long[] dst, int dstOffset, int len) {
        int srcLimit = srcOffset + len;
        while (srcOffset < srcLimit) {
            int srcIdx = srcOffset & 0x3F;
            int dstIdx = dstOffset & 0x3F;
            int srcRemainder = 64 - srcIdx;
            int dstRemainder = 64 - dstIdx;
            int chunkLen = Math.min(srcRemainder, dstRemainder);
            long mask = Bits.maskBelow(chunkLen) << srcIdx;
            int n = dstOffset >> 6;
            dst[n] = dst[n] | (src[srcOffset >> 6] & mask) >>> srcIdx << dstOffset;
            srcOffset += chunkLen;
            dstOffset += chunkLen;
        }
    }

    public static long[] interpose(long[] vector, int vectorLen, int offset2, int len) {
        long[] updated = BitVector.create(vectorLen + len);
        int idx = offset2 >> 6;
        System.arraycopy(vector, 0, updated, 0, idx);
        if (idx < vector.length) {
            int delta = offset2 & 0x3F;
            int n = idx;
            updated[n] = updated[n] | vector[idx] & Bits.maskBelow(delta);
        }
        BitVector.copy(vector, offset2, updated, offset2 + len, vectorLen - offset2);
        return updated;
    }

    public static long[] insert(long[] vector, int vectorLen, long val, int offset2, int len) {
        long[] updated = BitVector.interpose(vector, vectorLen, offset2, len);
        BitVector.overwrite(updated, val, offset2, len);
        return updated;
    }

    public static long[] remove(long[] vector, int vectorLen, int offset2, int len) {
        long[] updated = BitVector.create(vectorLen - len);
        int idx = offset2 >> 6;
        System.arraycopy(vector, 0, updated, 0, idx);
        if (idx < updated.length) {
            int delta = offset2 & 0x3F;
            int n = idx;
            updated[n] = updated[n] | vector[idx] & Bits.maskBelow(delta);
        }
        BitVector.copy(vector, offset2 + len, updated, offset2, vectorLen - (offset2 + len));
        return updated;
    }
}

