/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.Set;
import io.lacuna.bifurcan.nodes.MapNodes;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;

public class Map<K, V>
implements IMap<K, V>,
Cloneable {
    private static final Object DEFAULT_VALUE = new Object();
    private final BiPredicate<K, K> equalsFn;
    private final ToIntFunction<K> hashFn;
    public MapNodes.Node<K, V> root;
    private int hash = -1;
    final Object editor;

    public static <K, V> Map<K, V> from(IMap<K, V> map2) {
        if (map2 instanceof Map) {
            return (Map)map2.forked();
        }
        IMap result2 = new Map<K, V>(map2.keyHash(), map2.keyEquality()).linear();
        map2.forEach(arg_0 -> Map.lambda$from$0((Map)result2, arg_0));
        return ((Map)result2).forked();
    }

    public static <K, V> Map<K, V> from(java.util.Map<K, V> map2) {
        return Map.from(map2.entrySet());
    }

    public static <K, V> Map<K, V> from(Iterable<IEntry<K, V>> entries2) {
        return Map.from(entries2.iterator());
    }

    public static <K, V> Map<K, V> from(Iterator<IEntry<K, V>> entries2) {
        IMap m = new Map<K, V>().linear();
        entries2.forEachRemaining(arg_0 -> Map.lambda$from$1((Map)m, arg_0));
        return ((Map)m).forked();
    }

    public static <K, V> Map<K, V> from(IList<IEntry<K, V>> entries2) {
        return entries2.stream().collect(Maps.collector(IEntry::key, IEntry::value));
    }

    public static <K, V> Map<K, V> from(Collection<Map.Entry<K, V>> entries2) {
        return entries2.stream().collect(Maps.collector(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map(ToIntFunction<K> hashFn, BiPredicate<K, K> equalsFn) {
        this(MapNodes.Node.EMPTY, hashFn, equalsFn, false);
    }

    public Map() {
        this(MapNodes.Node.EMPTY, Objects::hashCode, Objects::equals, false);
    }

    private Map(MapNodes.Node<K, V> root, ToIntFunction<K> hashFn, BiPredicate<K, K> equalsFn, boolean linear) {
        this.root = root;
        this.hashFn = hashFn;
        this.equalsFn = equalsFn;
        this.editor = linear ? new Object() : null;
    }

    @Override
    public Set<K> keys() {
        return new Set(this);
    }

    @Override
    public ToIntFunction<K> keyHash() {
        return this.hashFn;
    }

    @Override
    public BiPredicate<K, K> keyEquality() {
        return this.equalsFn;
    }

    @Override
    public V get(K key, V defaultValue) {
        Object val = MapNodes.get(this.root, 0, this.keyHash(key), key, this.equalsFn, DEFAULT_VALUE);
        return (V)(val == DEFAULT_VALUE ? defaultValue : val);
    }

    @Override
    public Map<K, V> put(K key, V value) {
        return this.put((Object)key, (Object)value, Maps.MERGE_LAST_WRITE_WINS);
    }

    @Override
    public Map<K, V> put(K key, V value, BinaryOperator<V> merge) {
        return this.put(key, value, merge, this.isLinear() ? this.editor : new Object());
    }

    public Map<K, V> put(K key, V value, BinaryOperator<V> merge, Object editor) {
        MapNodes.INode rootPrime = this.root.put(0, editor, this.keyHash(key), (Object)key, (Object)value, (BiPredicate)this.equalsFn, (BinaryOperator)merge);
        if (this.isLinear() && editor == this.editor) {
            this.root = rootPrime;
            this.hash = -1;
            return this;
        }
        return new Map<K, V>(rootPrime, this.hashFn, this.equalsFn, false);
    }

    @Override
    public Map<K, V> update(K key, UnaryOperator<V> update) {
        return this.update(key, update, this.isLinear() ? this.editor : new Object());
    }

    public Map<K, V> update(K key, UnaryOperator<V> update, Object editor) {
        return this.put(key, update.apply(this.get(key, null)), Maps.MERGE_LAST_WRITE_WINS, editor);
    }

    @Override
    public Map<K, V> remove(K key) {
        return this.remove(key, this.isLinear() ? this.editor : new Object());
    }

    public Map<K, V> remove(K key, Object editor) {
        MapNodes.Node rootPrime = (MapNodes.Node)this.root.remove(0, editor, this.keyHash(key), key, this.equalsFn);
        if (this.isLinear() && editor == this.editor) {
            this.root = rootPrime;
            this.hash = -1;
            return this;
        }
        return new Map<K, V>(rootPrime, this.hashFn, this.equalsFn, false);
    }

    @Override
    public boolean contains(K key) {
        return MapNodes.contains(this.root, 0, this.keyHash(key), key, this.equalsFn);
    }

    @Override
    public long indexOf(K key) {
        return this.root.indexOf(0, this.keyHash(key), key, this.keyEquality());
    }

    @Override
    public IEntry<K, V> nth(long index) {
        if (index < 0L || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.root.nth(index);
    }

    @Override
    public Map<K, V> forked() {
        if (this.isLinear()) {
            return new Map<K, V>(this.root, this.hashFn, this.equalsFn, false);
        }
        return this;
    }

    @Override
    public Map<K, V> linear() {
        if (this.isLinear()) {
            return this;
        }
        return new Map<K, V>(this.root, this.hashFn, this.equalsFn, true);
    }

    @Override
    public <U> Map<K, U> mapValues(BiFunction<K, V, U> f) {
        return new Map<K, V>(this.root.mapVals(new Object(), (BiFunction)f), this.hashFn, this.equalsFn, this.isLinear());
    }

    @Override
    public List<Map<K, V>> split(int parts) {
        IList list = new List().linear();
        MapNodes.split(new Object(), this.root, (int)Math.ceil((float)this.size() / (float)parts)).stream().map(n -> new Map<K, V>(n, this.hashFn, this.equalsFn, false)).forEach(((List)list)::addLast);
        return ((List)list).forked();
    }

    @Override
    public Map<K, V> union(IMap<K, V> m) {
        return this.merge((IMap)m, Maps.MERGE_LAST_WRITE_WINS);
    }

    @Override
    public Map<K, V> merge(IMap<K, V> b, BinaryOperator<V> mergeFn) {
        if (b instanceof Map) {
            MapNodes.Node<K, V> rootPrime = MapNodes.merge(0, this.editor, this.root, ((Map)b).root, this.equalsFn, mergeFn);
            return new Map<K, V>(rootPrime, this.hashFn, this.equalsFn, this.isLinear());
        }
        return (Map)Maps.merge(this.clone(), b, mergeFn);
    }

    @Override
    public Map<K, V> difference(ISet<K> keys2) {
        if (keys2 instanceof Set) {
            return this.difference((IMap)((Set)keys2).map);
        }
        return (Map)Maps.difference(this.clone(), keys2);
    }

    @Override
    public Map<K, V> intersection(ISet<K> keys2) {
        if (keys2 instanceof Set) {
            return this.intersection((IMap)((Set)keys2).map);
        }
        Map map2 = (Map)Maps.intersection(new Map<K, V>().linear(), this, keys2);
        return this.isLinear() ? map2 : map2.forked();
    }

    @Override
    public Map<K, V> difference(IMap<K, ?> m) {
        if (m instanceof Map) {
            MapNodes.Node<K, V> rootPrime = MapNodes.difference(0, this.editor, this.root, ((Map)m).root, this.equalsFn);
            return new Map<K, V>(rootPrime == null ? MapNodes.Node.EMPTY : rootPrime, this.hashFn, this.equalsFn, this.isLinear());
        }
        return this.difference((ISet)m.keys());
    }

    @Override
    public Map<K, V> intersection(IMap<K, ?> m) {
        if (m instanceof Map) {
            MapNodes.Node<K, V> rootPrime = MapNodes.intersection(0, this.editor, this.root, ((Map)m).root, this.equalsFn);
            return new Map<K, V>(rootPrime == null ? MapNodes.Node.EMPTY : rootPrime, this.hashFn, this.equalsFn, this.isLinear());
        }
        return this.intersection((ISet)m.keys());
    }

    @Override
    public long size() {
        return this.root.size();
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public Iterator<IEntry<K, V>> iterator() {
        return this.root.iterator();
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = (int)Maps.hash(this);
        }
        return this.hash;
    }

    @Override
    public boolean equals(IMap<K, V> m, BiPredicate<V, V> valEquals) {
        if (m instanceof Map) {
            return this.root.equals(((Map)m).root, this.equalsFn, valEquals);
        }
        return Maps.equals(this, m, valEquals);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMap) {
            return this.equals((IMap)obj, Objects::equals);
        }
        return false;
    }

    public String toString() {
        return Maps.toString(this);
    }

    @Override
    public Map<K, V> clone() {
        return this.isLinear() ? ((Map)this.forked()).linear() : this;
    }

    private int keyHash(K key) {
        int hash = this.hashFn.applyAsInt(key);
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    private static /* synthetic */ void lambda$from$1(Map m, IEntry e) {
        m.put(e.key(), e.value());
    }

    private static /* synthetic */ void lambda$from$0(Map result2, IEntry e) {
        result2.put(e.key(), e.value());
    }
}

