/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISortedMap;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.nodes.IntMapNodes;
import io.lacuna.bifurcan.utils.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;

public class IntMap<V>
implements ISortedMap<Long, V>,
Cloneable {
    static final ToIntFunction<Long> HASH = n -> (int)(n ^ n >>> 32);
    private static final Object DEFAULT_VALUE = new Object();
    final Object editor;
    private IntMapNodes.Node<V> neg;
    private IntMapNodes.Node<V> pos;

    public static <V> IntMap<V> from(IMap<Number, V> m) {
        if (m instanceof IntMap) {
            return (IntMap)m.forked();
        }
        return IntMap.from(m.entries());
    }

    public static <V> IntMap<V> from(Map<Number, V> m) {
        return IntMap.from(m.entrySet());
    }

    public static <V> IntMap<V> from(Collection<Map.Entry<Number, V>> collection) {
        IntMap<V> map2 = new IntMap<V>().linear();
        for (Map.Entry<Number, V> entry : collection) {
            map2 = map2.put((long)((Long)entry.getKey()), entry.getValue());
        }
        return map2.forked();
    }

    public static <V> IntMap<V> from(IList<IEntry<Number, V>> list) {
        IntMap<V> map2 = new IntMap<V>().linear();
        for (IEntry<Number, V> entry : list) {
            map2 = map2.put((long)((Long)entry.key()), entry.value());
        }
        return map2.forked();
    }

    public IntMap() {
        this.neg = IntMapNodes.Node.NEG_EMPTY;
        this.pos = IntMapNodes.Node.POS_EMPTY;
        this.editor = null;
    }

    private IntMap(IntMapNodes.Node<V> neg, IntMapNodes.Node<V> pos, boolean linear) {
        this.neg = neg;
        this.pos = pos;
        this.editor = linear ? new Object() : null;
    }

    @Override
    public ToIntFunction<Long> keyHash() {
        return HASH;
    }

    @Override
    public BiPredicate<Long, Long> keyEquality() {
        return Long::equals;
    }

    public IntMap<V> slice(long min, long max) {
        IntMapNodes.Node<V> negPrime = this.neg.slice(this.editor, min, max);
        IntMapNodes.Node<V> posPrime = this.pos.slice(this.editor, min, max);
        return new IntMap<V>(negPrime == null ? IntMapNodes.Node.NEG_EMPTY : negPrime, posPrime == null ? IntMapNodes.Node.POS_EMPTY : posPrime, this.isLinear());
    }

    public IntMap<V> slice(Long min, Long max) {
        return this.slice((long)min, (long)max);
    }

    public IntMap<V> merge(IMap<Long, V> b, BinaryOperator<V> mergeFn) {
        if (b instanceof IntMap) {
            IntMap m = (IntMap)b;
            return new IntMap<V>(IntMapNodes.merge(new Object(), this.neg, m.neg, mergeFn), IntMapNodes.merge(new Object(), this.pos, m.pos, mergeFn), this.isLinear());
        }
        return (IntMap)Maps.merge(this.clone(), b, mergeFn);
    }

    public IntMap<V> difference(IMap<Long, ?> b) {
        if (b instanceof IntMap) {
            IntMap m = (IntMap)b;
            IntMapNodes.Node<V> negPrime = IntMapNodes.difference(new Object(), this.neg, m.neg);
            IntMapNodes.Node<V> posPrime = IntMapNodes.difference(new Object(), this.pos, m.pos);
            return new IntMap<V>(negPrime == null ? IntMapNodes.Node.NEG_EMPTY : negPrime, posPrime == null ? IntMapNodes.Node.POS_EMPTY : posPrime, this.isLinear());
        }
        return (IntMap)Maps.difference(this.clone(), b.keys());
    }

    public IntMap<V> intersection(IMap<Long, ?> b) {
        if (b instanceof IntMap) {
            IntMap m = (IntMap)b;
            IntMapNodes.Node<V> negPrime = IntMapNodes.intersection(new Object(), this.neg, m.neg);
            IntMapNodes.Node<V> posPrime = IntMapNodes.intersection(new Object(), this.pos, m.pos);
            return new IntMap<V>(negPrime == null ? IntMapNodes.Node.NEG_EMPTY : negPrime, posPrime == null ? IntMapNodes.Node.POS_EMPTY : posPrime, this.isLinear());
        }
        IntMap result2 = (IntMap)Maps.intersection(new IntMap<V>().linear(), this, b.keys());
        return this.isLinear() ? result2 : result2.forked();
    }

    public IntMap<V> put(long key, V value) {
        return this.put(key, value, (BinaryOperator<V>)Maps.MERGE_LAST_WRITE_WINS);
    }

    public IntMap<V> put(long key, V value, Object editor) {
        return this.put(key, value, Maps.MERGE_LAST_WRITE_WINS, editor);
    }

    public IntMap<V> put(long key, V value, BinaryOperator<V> merge) {
        return this.put(key, value, merge, this.isLinear() ? this.editor : new Object());
    }

    public IntMap<V> put(long key, V value, BinaryOperator<V> merge, Object editor) {
        if (key < 0L) {
            IntMapNodes.Node<V> negPrime = this.neg.put(editor, key, value, merge);
            if (this.neg == negPrime) {
                return this;
            }
            if (this.isLinear()) {
                this.neg = negPrime;
                return this;
            }
            return new IntMap<V>(negPrime, this.pos, false);
        }
        IntMapNodes.Node<V> posPrime = this.pos.put(editor, key, value, merge);
        if (this.pos == posPrime) {
            return this;
        }
        if (this.isLinear()) {
            this.pos = posPrime;
            return this;
        }
        return new IntMap<V>(this.neg, posPrime, false);
    }

    public IntMap<V> put(Long key, V value) {
        return this.put(key, value, (BinaryOperator<V>)Maps.MERGE_LAST_WRITE_WINS);
    }

    public IntMap<V> put(Long key, V value, BinaryOperator<V> merge) {
        return this.put((long)key, value, merge);
    }

    public IntMap<V> remove(long key) {
        return this.remove(key, this.isLinear() ? this.editor : new Object());
    }

    public IntMap<V> remove(long key, Object editor) {
        if (key < 0L) {
            IntMapNodes.Node<V> negPrime = this.neg.remove(editor, key);
            if (this.neg == negPrime) {
                return this;
            }
            if (this.isLinear()) {
                this.neg = negPrime;
                return this;
            }
            return new IntMap<V>(negPrime, this.pos, false);
        }
        IntMapNodes.Node<V> posPrime = this.pos.remove(editor, key);
        if (this.pos == posPrime) {
            return this;
        }
        if (this.isLinear()) {
            this.pos = posPrime;
            return this;
        }
        return new IntMap<V>(this.neg, posPrime, false);
    }

    public IntMap<V> remove(Long key) {
        return this.remove((long)key);
    }

    public <U> IntMap<U> mapValues(BiFunction<Long, V, U> f) {
        Object editor = new Object();
        return new IntMap<U>(this.neg.mapVals(editor, f), this.pos.mapVals(editor, f), this.isLinear());
    }

    @Override
    public Optional<V> get(long key) {
        Object o = (key < 0L ? this.neg : this.pos).get(key, DEFAULT_VALUE);
        return o == DEFAULT_VALUE ? Optional.empty() : Optional.of(o);
    }

    @Override
    public V get(long key, V defaultValue) {
        return (V)(key < 0L ? this.neg : this.pos).get(key, defaultValue);
    }

    @Override
    public V get(Long key, V defaultValue) {
        return this.get((long)key, defaultValue);
    }

    @Override
    public IMap<Long, V> update(Long key, UnaryOperator<V> update) {
        return this.update((long)key, update);
    }

    public IntMap<V> update(long key, UnaryOperator<V> update) {
        return this.put(key, update.apply(this.get(key, (V)null)), this.isLinear() ? this.editor : new Object());
    }

    public IntMap<V> update(long key, UnaryOperator<V> update, Object editor) {
        return this.put(key, update.apply(this.get(key, (V)null)), editor);
    }

    @Override
    public boolean contains(long key) {
        return (key < 0L ? this.neg : this.pos).get(key, DEFAULT_VALUE) != DEFAULT_VALUE;
    }

    @Override
    public boolean contains(Long key) {
        return this.contains((long)key);
    }

    @Override
    public long indexOf(Long key) {
        return this.indexOf((long)key);
    }

    @Override
    public long indexOf(long key) {
        return key < 0L ? this.neg.indexOf(key) : (long)this.neg.size() + this.pos.indexOf(key);
    }

    @Override
    public IEntry<Long, V> nth(long index) {
        return index < (long)this.neg.size() ? this.neg.nth(index) : this.pos.nth(index - (long)this.neg.size());
    }

    @Override
    public Iterator<IEntry<Long, V>> iterator() {
        return Iterators.concat(this.neg.iterator(), this.pos.iterator());
    }

    @Override
    public IEntry<Long, V> floor(long key) {
        if (key < 0L) {
            return this.neg.floor(key);
        }
        IEntry<Long, V> entry = this.pos.floor(key);
        if (entry != null) {
            return entry;
        }
        return this.neg.size() > 0 ? this.neg.nth(this.neg.size() - 1) : null;
    }

    @Override
    public IEntry<Long, V> floor(Long key) {
        return this.floor((long)key);
    }

    @Override
    public IEntry<Long, V> ceil(long key) {
        if (key >= 0L) {
            return this.pos.ceil(key);
        }
        IEntry<Long, V> entry = this.neg.ceil(key);
        if (entry != null) {
            return entry;
        }
        return this.pos.size() > 0 ? this.pos.nth(0L) : null;
    }

    @Override
    public IEntry<Long, V> ceil(Long key) {
        return this.ceil((long)key);
    }

    @Override
    public long size() {
        return this.neg.size() + this.pos.size();
    }

    @Override
    public boolean isLinear() {
        return this.editor != null;
    }

    @Override
    public IntMap<V> forked() {
        return this.isLinear() ? new IntMap<V>(this.neg, this.pos, false) : this;
    }

    @Override
    public IntMap<V> linear() {
        return this.isLinear() ? this : new IntMap<V>(this.neg, this.pos, true);
    }

    @Override
    public List<IntMap<V>> split(int parts) {
        IList result2 = new List().linear();
        parts = Math.max(1, Math.min((int)this.size(), parts));
        if (parts == 1 || this.size() == 0L) {
            return ((List)((List)result2).addLast(this)).forked();
        }
        int estParts = (int)Math.min((double)(parts - 1), Math.max(1.0, (double)this.neg.size() / (double)this.size() * (double)parts));
        int negParts = this.pos.size() == 0 ? parts : (this.neg.size == 0 ? 0 : estParts);
        int posParts = parts - negParts;
        if (negParts > 0) {
            IntMapNodes.split(new Object(), this.neg, this.neg.size() / negParts).stream().map(n -> new IntMap<V>(n, IntMapNodes.Node.POS_EMPTY, this.isLinear())).forEach(arg_0 -> IntMap.lambda$split$2((List)result2, arg_0));
        }
        if (posParts > 0) {
            IntMapNodes.split(new Object(), this.pos, this.pos.size() / posParts).stream().map(n -> new IntMap(IntMapNodes.Node.NEG_EMPTY, n, false)).forEach(arg_0 -> IntMap.lambda$split$4((List)result2, arg_0));
        }
        return ((List)result2).forked();
    }

    public int hashCode() {
        return (int)Maps.hash(this);
    }

    @Override
    public boolean equals(IMap<Long, V> o, BiPredicate<V, V> valEquals) {
        if (o instanceof IntMap) {
            IntMap m = (IntMap)o;
            return this.neg.equals(m.neg, valEquals) && this.pos.equals(m.pos, valEquals);
        }
        return Maps.equals(this, o, valEquals);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMap) {
            return this.equals((IMap)obj, (BiPredicate<V, V>)((BiPredicate<Object, Object>)Objects::equals));
        }
        return false;
    }

    public String toString() {
        return Maps.toString(this);
    }

    public IntMap<V> clone() {
        return new IntMap<V>(this.neg, this.pos, this.isLinear());
    }

    private static /* synthetic */ void lambda$split$4(List result2, Object m) {
        result2.addLast((IntMap)m);
    }

    private static /* synthetic */ void lambda$split$2(List result2, Object m) {
        result2.addLast((IntMap)m);
    }
}

