/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEntry;
import io.lacuna.bifurcan.IForkable;
import io.lacuna.bifurcan.ILinearizable;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.ISplittable;
import io.lacuna.bifurcan.Lists;
import io.lacuna.bifurcan.Map;
import io.lacuna.bifurcan.Maps;
import io.lacuna.bifurcan.Sets;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IMap<K, V>
extends Iterable<IEntry<K, V>>,
ISplittable<IMap<K, V>>,
ILinearizable<IMap<K, V>>,
IForkable<IMap<K, V>>,
Function<K, V> {
    default public ToIntFunction<K> keyHash() {
        return Objects::hashCode;
    }

    default public BiPredicate<K, K> keyEquality() {
        return Objects::equals;
    }

    public V get(K var1, V var2);

    default public Optional<V> get(K key) {
        return Optional.ofNullable(this.get(key, null));
    }

    default public V getOrCreate(K key, Supplier<V> f) {
        V val = this.get(key, null);
        if (val == null) {
            val = f.get();
            this.put(key, val);
        }
        return val;
    }

    public boolean contains(K var1);

    default public IList<IEntry<K, V>> entries() {
        return Lists.from(this.size(), this::nth, this::iterator);
    }

    public long indexOf(K var1);

    public IEntry<K, V> nth(long var1);

    default public ISet<K> keys() {
        return Sets.from(Lists.lazyMap(this.entries(), IEntry::key), this::contains);
    }

    default public IList<V> values() {
        return Lists.lazyMap(this.entries(), IEntry::value);
    }

    public long size();

    default public <U> IMap<K, U> mapValues(BiFunction<K, V, U> f) {
        IMap m = new Map(this.keyHash(), this.keyEquality()).linear();
        this.forEach(arg_0 -> IMap.lambda$mapValues$0((Map)m, f, arg_0));
        return this.isLinear() ? m : ((Map)m).forked();
    }

    default public boolean containsAll(ISet<K> set) {
        return set.elements().stream().allMatch(this::contains);
    }

    default public boolean containsAll(IMap<K, ?> map2) {
        return this.containsAll(map2.keys());
    }

    default public boolean containsAny(ISet<K> set) {
        return set.elements().stream().anyMatch(this::contains);
    }

    default public boolean containsAny(IMap<K, ?> map2) {
        return this.containsAny(map2.keys());
    }

    @Override
    default public boolean isLinear() {
        return false;
    }

    default public java.util.Map<K, V> toMap() {
        return Maps.toMap(this);
    }

    @Override
    default public Iterator<IEntry<K, V>> iterator() {
        return this.entries().iterator();
    }

    default public Stream<IEntry<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public Spliterator<IEntry<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), this.size(), 1);
    }

    default public IMap<K, V> merge(IMap<K, V> b, BinaryOperator<V> mergeFn) {
        return Maps.merge(this, b, mergeFn);
    }

    default public IMap<K, V> difference(ISet<K> keys2) {
        return Maps.difference(this, keys2);
    }

    default public IMap<K, V> intersection(ISet<K> keys2) {
        IMap result2 = Maps.intersection(new Map(this.keyHash(), this.keyEquality()).linear(), this, keys2);
        return this.isLinear() ? result2 : result2.forked();
    }

    default public IMap<K, V> union(IMap<K, V> m) {
        return this.merge(m, Maps.MERGE_LAST_WRITE_WINS);
    }

    default public IMap<K, V> difference(IMap<K, ?> m) {
        return this.difference(m.keys());
    }

    default public IMap<K, V> intersection(IMap<K, ?> m) {
        return this.intersection(m.keys());
    }

    default public IMap<K, V> put(K key, V value, BinaryOperator<V> merge) {
        return new Maps.VirtualMap<K, V>(this).put(key, value, merge);
    }

    default public IMap<K, V> update(K key, UnaryOperator<V> update) {
        return this.put(key, update.apply(this.get(key, null)));
    }

    default public IMap<K, V> put(K key, V value) {
        return this.put(key, value, Maps.MERGE_LAST_WRITE_WINS);
    }

    default public IMap<K, V> remove(K key) {
        return new Maps.VirtualMap(this).remove(key);
    }

    @Override
    default public IMap<K, V> forked() {
        return this;
    }

    @Override
    default public IMap<K, V> linear() {
        return new Maps.VirtualMap(this).linear();
    }

    @Override
    default public IList<? extends IMap<K, V>> split(int parts) {
        return this.keys().split(parts).stream().map(ks -> Maps.from(ks, k -> this.get(k, null))).collect(Lists.collector());
    }

    public IMap<K, V> clone();

    default public boolean equals(IMap<K, V> m, BiPredicate<V, V> equals) {
        return Maps.equals(this, m, equals);
    }

    @Override
    default public V apply(K k) {
        return this.get(k, null);
    }

    private static /* synthetic */ void lambda$mapValues$0(Map m, BiFunction f, IEntry e) {
        m.put(e.key(), f.apply(e.key(), e.value()));
    }
}

