/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.IEdge;
import io.lacuna.bifurcan.IGraph;
import io.lacuna.bifurcan.IList;
import io.lacuna.bifurcan.IMap;
import io.lacuna.bifurcan.ISet;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.LinearMap;
import io.lacuna.bifurcan.LinearSet;
import io.lacuna.bifurcan.List;
import io.lacuna.bifurcan.Set;
import io.lacuna.bifurcan.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class Graphs {
    static final BinaryOperator MERGE_LAST_WRITE_WINS = (a2, b) -> b;

    public static <V, E> boolean equals(IGraph<V, E> a2, IGraph<V, E> b) {
        if (a2.isDirected() != b.isDirected() || !a2.vertices().equals(b.vertices())) {
            return false;
        }
        for (V v : a2.vertices()) {
            ISet<V> bOut;
            ISet<V> aOut = a2.out(v);
            if (!aOut.equals(bOut = b.out(v))) {
                return false;
            }
            for (V w : aOut) {
                if (Objects.equals(a2.edge(v, w), b.edge(v, w))) continue;
                return false;
            }
        }
        return true;
    }

    public static <V, E> int hash(IGraph<V, E> g) {
        int hash = g.vertices().stream().mapToInt(Objects::hashCode).reduce(0, (a2, b) -> a2 ^ b);
        if (g.isDirected()) {
            for (V v : g.vertices()) {
                for (V w : g.out(v)) {
                    hash = hash ^ Objects.hashCode(w) * 31 ^ Objects.hashCode(g.edge(v, w));
                }
            }
        } else {
            for (V v : g.vertices()) {
                for (V w : g.out(v)) {
                    hash = hash ^ Objects.hashCode(v) ^ Objects.hashCode(w) ^ Objects.hashCode(g.edge(v, w));
                }
            }
        }
        return hash;
    }

    public static <V, E> IGraph<V, E> merge(IGraph<V, E> a2, IGraph<V, E> b, BinaryOperator<E> merge) {
        if (a2.isDirected() != b.isDirected()) {
            throw new IllegalArgumentException("cannot merge directed and undirected graphs");
        }
        if (a2.vertices().size() < b.vertices().size()) {
            return Graphs.merge(b, a2, (x, y) -> merge.apply(y, x));
        }
        IGraph result2 = (IGraph)((IGraph)a2.forked()).linear();
        for (V src : b.vertices()) {
            for (V dst : b.out(src)) {
                a2 = a2.link(src, dst, b.edge(src, dst), merge);
            }
        }
        return (IGraph)result2.forked();
    }

    public static <V, E> Optional<IList<V>> shortestPath(IGraph<V, E> graph, V from, Predicate<V> accept, ToDoubleFunction<IEdge<V, E>> cost) {
        return Graphs.shortestPath(graph, LinearList.of(from), accept, cost);
    }

    /*
     * Unable to fully structure code
     */
    public static <V, E> Optional<IList<V>> shortestPath(IGraph<V, E> graph, Iterable<V> start, Predicate<V> accept, ToDoubleFunction<IEdge<V, E>> cost) {
        originStates = new LinearMap<V, IMap>();
        queue = new PriorityQueue<ShortestPathState>(Comparator.comparingDouble((ToDoubleFunction<ShortestPathState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$shortestPath$3(io.lacuna.bifurcan.Graphs$ShortestPathState ), (Lio/lacuna/bifurcan/Graphs$ShortestPathState;)D)()));
        for (V v : start) {
            if (!graph.vertices().contains(v)) continue;
            init = new ShortestPathState<V>(v);
            originStates.getOrCreate(v, (Supplier<IMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lio/lacuna/bifurcan/IMap;)()).put(v, init);
            queue.add(init);
        }
        block1: while (true) {
            if ((curr = queue.poll()) == null) {
                return Optional.empty();
            }
            states = (IMap)originStates.get(curr.origin).get();
            if (states.get(curr.node).get() != curr) continue;
            if (curr.prev != null && accept.test(curr.node)) {
                return Optional.of(List.from(curr.path()));
            }
            var8_8 = graph.out(curr.node).iterator();
            while (true) {
                if (var8_8.hasNext()) ** break;
                continue block1;
                v = var8_8.next();
                edge = cost.applyAsDouble(new Edge<V, E>(graph.edge(curr.node, v), curr.node, v));
                if (edge < 0.0) {
                    throw new IllegalArgumentException("negative edge weights are unsupported");
                }
                next = states.get(v, null);
                if (next == null) {
                    next = new ShortestPathState<V>(v, curr, edge);
                } else {
                    if (!(curr.distance + edge < next.distance)) continue;
                    next = new ShortestPathState<V>(v, curr, edge);
                }
                states.put(v, next);
                queue.add(next);
            }
            break;
        }
    }

    public static <V> Set<Set<V>> connectedComponents(IGraph<V, ?> graph) {
        if (graph.isDirected()) {
            throw new IllegalArgumentException("graph must be undirected, try Graphs.stronglyConnectedComponents instead");
        }
        LinearSet<V> traversed = new LinearSet<V>((int)graph.vertices().size(), graph.vertexHash(), graph.vertexEquality());
        ISet result2 = new Set().linear();
        for (V seed : graph.vertices()) {
            if (traversed.contains(seed)) continue;
            traversed.add((Object)seed);
            ISet group = new Set<V>(graph.vertexHash(), graph.vertexEquality()).linear();
            Graphs.bfsVertices(LinearList.of(seed), graph::out).forEachRemaining(((Set)group)::add);
            ((Set)result2).add(((Set)group).forked());
        }
        return ((Set)result2).forked();
    }

    public static <V> Set<Set<V>> biconnectedComponents(IGraph<V, ?> graph) {
        Set<V> cuts = Graphs.articulationPoints(graph);
        ISet result2 = new Set().linear();
        for (Set component : Graphs.connectedComponents(graph.select(graph.vertices().difference(cuts)))) {
            ((Set)result2).add(component.union((ISet)cuts.stream().filter(v -> graph.out(v).containsAny(component)).collect(Sets.collector())));
        }
        int i = 0;
        while ((long)i < cuts.size() - 1L) {
            int j = i + 1;
            while ((long)j < cuts.size()) {
                V a2 = cuts.nth(i);
                V b = cuts.nth(i + 1);
                if (graph.out(a2).contains(b)) {
                    ((Set)result2).add(Set.of(a2, b));
                }
                ++j;
            }
            ++i;
        }
        return ((Set)result2).forked();
    }

    public static <V> Set<V> articulationPoints(IGraph<V, ?> graph) {
        if (graph.isDirected()) {
            throw new IllegalArgumentException("graph must be undirected");
        }
        LinearMap<ArticulationPointState<V>, ArticulationPointState<V>> state = new LinearMap<ArticulationPointState<V>, ArticulationPointState<V>>((int)graph.vertices().size(), graph.vertexHash(), graph.vertexEquality());
        LinearList path = new LinearList();
        LinearList branches = new LinearList();
        ISet result2 = new Set().linear();
        for (V seed : graph.vertices()) {
            if (state.contains((ArticulationPointState<V>)seed)) continue;
            ArticulationPointState<V> s2 = new ArticulationPointState<V>(seed, 0);
            path.addLast(s2);
            branches.addLast(graph.out(seed).iterator());
            state.put((ArticulationPointState<V>)seed, s2);
            while (path.size() > 0L) {
                ArticulationPointState vs;
                if (((Iterator)branches.last()).hasNext()) {
                    Object w = ((Iterator)branches.last()).next();
                    vs = (ArticulationPointState)path.last();
                    ArticulationPointState ws = state.get((ArticulationPointState<V>)w, (ArticulationPointState<V>)null);
                    if (ws == null) {
                        ws = new ArticulationPointState(w, (int)path.size());
                        ++vs.childCount;
                        state.put((ArticulationPointState<V>)w, ws);
                        path.addLast(ws);
                        branches.addLast(graph.out(w).iterator());
                        continue;
                    }
                    vs.lowlink = Math.min(vs.lowlink, ws.depth);
                    continue;
                }
                branches.popLast();
                ArticulationPointState ws = (ArticulationPointState)path.popLast();
                if (path.size() <= 0L) continue;
                vs = (ArticulationPointState)path.last();
                vs.lowlink = Math.min(ws.lowlink, vs.lowlink);
                if ((path.size() <= 1L || ws.lowlink < vs.depth) && (path.size() != 1L || vs.childCount <= 1)) continue;
                ((Set)result2).add(vs.node);
            }
        }
        return ((Set)result2).forked();
    }

    public static <V> Set<Set<V>> stronglyConnectedComponents(IGraph<V, ?> graph, boolean includeSingletons) {
        if (!graph.isDirected()) {
            throw new IllegalArgumentException("graph must be directed, try Graphs.connectedComponents instead");
        }
        LinearMap<TarjanState, TarjanState> state = new LinearMap<TarjanState, TarjanState>((int)graph.vertices().size(), graph.vertexHash(), graph.vertexEquality());
        LinearList stack = new LinearList();
        LinearList path = new LinearList();
        LinearList branches = new LinearList();
        ISet result2 = new Set().linear();
        for (V seed : graph.vertices()) {
            if (state.contains((TarjanState)seed)) continue;
            branches.addLast(LinearList.of(seed).iterator());
            do {
                Object x;
                TarjanState ws;
                Object w;
                if (((Iterator)branches.last()).hasNext()) {
                    w = ((Iterator)branches.last()).next();
                    ws = state.get((TarjanState)w, (TarjanState)null);
                    if (ws == null) {
                        ws = new TarjanState((int)state.size());
                        state.put((TarjanState)w, ws);
                        stack.addLast(w);
                        path.addLast(w);
                        branches.addLast(graph.out(w).iterator());
                        continue;
                    }
                    if (!ws.onStack) continue;
                    TarjanState vs = (TarjanState)state.get((TarjanState)path.last()).get();
                    vs.lowlink = Math.min(vs.lowlink, ws.index);
                    continue;
                }
                branches.popLast();
                w = path.popLast();
                ws = (TarjanState)state.get((TarjanState)w).get();
                if (path.size() > 0L) {
                    Object v = path.last();
                    TarjanState vs = (TarjanState)state.get((TarjanState)v).get();
                    vs.lowlink = Math.min(vs.lowlink, ws.lowlink);
                }
                if (ws.lowlink != ws.index) continue;
                if (!includeSingletons && stack.last() == w) {
                    stack.popLast();
                    ((TarjanState)state.get(w).get()).onStack = false;
                    continue;
                }
                ISet group = new Set<V>(graph.vertexHash(), graph.vertexEquality()).linear();
                do {
                    x = stack.popLast();
                    ((Set)group).add(x);
                    ((TarjanState)state.get(x).get()).onStack = false;
                } while (x != w);
                ((Set)result2).add(((Set)group).forked());
            } while (path.size() > 0L);
        }
        return ((Set)result2).forked();
    }

    public static <V, E> List<IGraph<V, E>> stronglyConnectedSubgraphs(IGraph<V, E> graph, boolean includeSingletons) {
        IList result2 = new List().linear();
        Graphs.stronglyConnectedComponents(graph, includeSingletons).forEach(arg_0 -> Graphs.lambda$stronglyConnectedSubgraphs$5((List)result2, graph, arg_0));
        return ((List)result2).forked();
    }

    public static <V, E> List<List<V>> cycles(IGraph<V, E> graph) {
        if (!graph.isDirected()) {
            throw new IllegalArgumentException("graph must be directed");
        }
        LinearList path = new LinearList();
        LinearList<Iterator<V>> branches = new LinearList<Iterator<V>>();
        LinearSet blocked = new LinearSet(graph.vertexHash(), graph.vertexEquality());
        LinearMap blocking = new LinearMap();
        IList result2 = new List().linear();
        for (IGraph subgraph : Graphs.stronglyConnectedSubgraphs(graph, true)) {
            if (subgraph.vertices().stream().allMatch(v -> subgraph.out(v).size() == 1L)) {
                V seed = subgraph.vertices().nth(0L);
                ((List)result2).addLast(List.from(Graphs.bfsVertices(seed, subgraph::out)).addLast((Object)seed));
                continue;
            }
            for (V seed : subgraph.vertices()) {
                long threshold = subgraph.indexOf(seed);
                path.addLast((Object)seed);
                branches.addLast(subgraph.out(seed).iterator());
                blocked.clear();
                blocking.clear();
                int depth = 1;
                do {
                    Object v2;
                    if (((Iterator)branches.last()).hasNext()) {
                        v2 = ((Iterator)branches.last()).next();
                        if (subgraph.indexOf(v2) < threshold) continue;
                        if (subgraph.vertexEquality().test(seed, v2)) {
                            ((List)result2).addLast(List.from(path).addLast((Object)seed));
                            depth = 0;
                        } else if (!blocked.contains(v2)) {
                            path.addLast(v2);
                            ++depth;
                            branches.addLast(subgraph.out(v2).iterator());
                        }
                        blocked.add(v2);
                        continue;
                    }
                    v2 = path.popLast();
                    if ((depth = Math.max(-1, depth - 1)) < 0) {
                        IList stack = new LinearList().addFirst(v2);
                        while (((LinearList)stack).size() > 0L) {
                            Object u2 = ((LinearList)stack).popLast();
                            if (!blocked.contains(u2)) continue;
                            blocked.remove(u2);
                            blocking.get(u2, Sets.EMPTY).forEach(((LinearList)stack)::addLast);
                            blocking.remove(u2);
                        }
                    } else {
                        graph.out(v2).forEach(u -> blocking.getOrCreate(u, LinearSet::new).add(v2));
                    }
                    branches.removeLast();
                } while (path.size() > 0L);
            }
        }
        return ((List)result2).forked();
    }

    public static <V> Iterator<V> bfsVertices(V start2, Function<V, Iterable<V>> adjacent) {
        return Graphs.bfsVertices(LinearList.of(start2), adjacent);
    }

    public static <V> Iterator<V> bfsVertices(Iterable<V> start2, final Function<V, Iterable<V>> adjacent) {
        final LinearList queue = new LinearList();
        final LinearSet traversed = new LinearSet();
        start2.forEach(queue::addLast);
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return queue.size() > 0L;
            }

            @Override
            public V next() {
                Object v = queue.popFirst();
                traversed.add(v);
                ((Iterable)adjacent.apply(v)).forEach(w -> {
                    if (!traversed.contains(w)) {
                        queue.addLast(w);
                    }
                });
                return v;
            }
        };
    }

    private static /* synthetic */ void lambda$stronglyConnectedSubgraphs$5(List result2, IGraph graph, Set s2) {
        result2.addLast(graph.select(s2));
    }

    private static /* synthetic */ double lambda$shortestPath$3(ShortestPathState x) {
        return x.distance;
    }

    private static class TarjanState {
        final int index;
        int lowlink;
        boolean onStack;

        public TarjanState(int index) {
            this.index = index;
            this.lowlink = index;
            this.onStack = true;
        }
    }

    private static class ArticulationPointState<V> {
        final V node;
        final int depth;
        int lowlink;
        int childCount = 0;

        public ArticulationPointState(V node, int depth) {
            this.node = node;
            this.depth = depth;
            this.lowlink = depth;
        }
    }

    private static class ShortestPathState<V> {
        public final V origin;
        public final V node;
        public final ShortestPathState<V> prev;
        public final double distance;

        private ShortestPathState(V origin) {
            this.origin = origin;
            this.prev = null;
            this.node = origin;
            this.distance = 0.0;
        }

        public ShortestPathState(V node, ShortestPathState<V> prev, double edge) {
            this.origin = prev.origin;
            this.node = node;
            this.prev = prev;
            this.distance = prev.distance + edge;
        }

        public IList<V> path() {
            LinearList<V> result2 = new LinearList<V>();
            ShortestPathState<V> curr = this;
            while (true) {
                result2.addFirst(curr.node);
                if (curr.node.equals(curr.origin)) break;
                curr = curr.prev;
            }
            return result2;
        }
    }

    public static class Edge<V, E>
    implements IEdge<V, E> {
        public final E value;
        public final V from;
        public final V to;
        private int hash = -1;

        public Edge(E value, V from, V to) {
            this.value = value;
            this.from = from;
            this.to = to;
        }

        public static <V, E> Edge<V, E> create(IGraph<V, E> graph, V from, V to) {
            return new Edge<V, E>(graph.edge(from, to), from, to);
        }

        @Override
        public V from() {
            return this.from;
        }

        @Override
        public V to() {
            return this.to;
        }

        @Override
        public E value() {
            return this.value;
        }

        public int hashCode() {
            if (this.hash == -1) {
                this.hash = this.from.hashCode() ^ this.to.hashCode() ^ this.value.hashCode();
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Edge) {
                Edge e = (Edge)obj;
                return Objects.equals(this.from, e.from) && Objects.equals(this.to, e.to) && Objects.equals(this.value, e.value);
            }
            return false;
        }
    }
}

