from modpp import *;
from math import cos, sin, pi;


def generateFilledCircle(shape, sides, radius = 1, color = Color(1, 1, 1)):

  rad = pi*2.0 / sides
  center = Vector3(0, 0, 0)
  for side in xrange(sides):

    p0 = Vector3(cos(rad * side), sin(rad * side), 0)
    p1 = Vector3(cos(rad * (side+1)), sin(rad * (side+1)),0)

    shape.addTriangle(center,
                      p0 * radius,
                      p1 * radius,
                      color, color, color)


def generateCircle(shape, sides, innerRadius = 0.5, outerRadius = 1, color = Color(1, 1, 1)):

  rad = pi*2.0 / sides
  center = Vector3(0, 0, 0)
  c = Color(1,1,1)
  for side in xrange(sides):

    p0 = Vector3(cos(rad * side), sin(rad * side), 0) * innerRadius
    p1 = Vector3(cos(rad * (side+1)), sin(rad * (side+1)),0) * innerRadius
    p2 = Vector3(cos(rad * side), sin(rad * side), 0) * outerRadius
    p3 = Vector3(cos(rad * (side+1)), sin(rad * (side+1)),0) * outerRadius

    shape.addTriangle(p0, p3, p1, color, color, color)
    shape.addTriangle(p0, p2, p3, color, color, color)


def generateFilledCross(shape, width = .5, height = .5, thickness = .1, color = Color(1, 1, 1), center = Vector3(0, 0, 0), fillCenter = True):

  if fillCenter == True:
    generateFilledRect(shape, thickness, thickness, color, center)

  generateFilledRect(shape, thickness, (height - thickness) / 2, color, center + Vector3(0, (height/2 + thickness/2) / 2, 0))
  generateFilledRect(shape, thickness, (height - thickness) / 2,  color, center + Vector3(0, (height/2 + thickness/2) / -2, 0))
  generateFilledRect(shape, (width - thickness) / 2, thickness, color, center + Vector3((width/2 + thickness/2) / 2, 0, 0)) 
  generateFilledRect(shape, (width - thickness) / 2, thickness, color, center + Vector3((width/2 + thickness/2) / -2, 0, 0))
    
def generateFilledRect(shape, width = 1, height = 1, color = Color(1,1,1), center = Vector3(0, 0, 0)):

  p0 = center + Vector3(-width, height, 0) * 0.5
  p1 = center + Vector3(width, height, 0) * 0.5
  p2 = center + Vector3(width, -height, 0) * 0.5
  p3 = center + Vector3(-width, -height, 0) * 0.5

  shape.addTriangle(p0, p2, p1, color, color, color)
  shape.addTriangle(p0, p3, p2, color, color, color)
  
def generateRect(shape, innerWidth = .9, outerWidth = 1, innerHeight = .9, outerHeight = 1, color = Color(1,1,1)):

  p0 = Vector3(-innerWidth, innerHeight, 0) * 0.5
  p1 = Vector3(innerWidth, innerHeight, 0) * 0.5
  p2 = Vector3(innerWidth, -innerHeight, 0) * 0.5
  p3 = Vector3(-innerWidth, -innerHeight, 0) * 0.5

  p4 = Vector3(-outerWidth, outerHeight, 0) * 0.5
  p5 = Vector3(outerWidth, outerHeight, 0) * 0.5
  p6 = Vector3(outerWidth, -outerHeight, 0) * 0.5
  p7 = Vector3(-outerWidth, -outerHeight, 0) * 0.5
  
  ps0 = [p0, p1, p2, p3]
  ps1 = [p4, p5, p6, p7]

  for side in xrange(4):
    idx0 = side
    idx1 = (side + 1) % 4
    
    shape.addTriangle(ps1[idx0], ps0[idx1], ps1[idx1], color, color, color)
    shape.addTriangle(ps1[idx0], ps0[idx1], ps0[idx0], color, color, color)
    
  
  
