unit credz;

interface
uses routines,playmods,map;

const vidseg = $a000;
      zc = 256;
      xc = 160;
      yc = 100;

      xsize = 32;
      ysize = 32;
      xrange = 80;
      yrange = 80;
      zrange = 80;

      xinc = 256;
      yinc = 256;
      zinc = 0;

      points = 10;

      sinsize = 360;

      skip = 4;
      gap = 320;
      blurtime = 200;

      mies : array[1..2] of string=('access.map','jobe.map');

      pallot : array[1..2,1..2] of integer = ((80,40),(-80,-40));

var flareseg,miesseg,virseg : word;
    flarescr,miesscr,virscr : pointer;
    loop : word;
    xphi,yphi,zphi : integer;
    x,y,z : integer;
    stab,ctab : array[0..sinsize] of real;
    frames : word;
    loppu : boolean;
    trackstatus : miscdata;
    blurframes : word;
    male : byte;
    p : word;
    faded : boolean;

procedure do_credz(nosound:boolean);

implementation

procedure do_credz(nosound:boolean);

procedure blurMies; assembler; { k3wl! }
    asm
      mov es,[miesseg]
      mov di,8
      mov si,320*200-16
      @outer:

          xor ax,ax
          xor bx,bx
          mov al,[es:di+1]
          mov bl,[es:di-1]
          add ax,bx
          shr ax,1
          mov [es:di],al
          inc di

      dec si
      jne @outer
    end;

procedure loadMIES;
begin
  inc(male);
  loadMAP(miesseg,mies[male]);
end;

begin
  male:=0;
  getmem(miesscr,320*200);
  miesseg:=seg(miesscr^);
  cls(miesseg);
  randomize;
  getmem(virscr,320*200);
  virseg:=seg(virscr^);
  cls(virseg);

  for loop:=0 to sinsize do ctab[loop]:=cos(loop*pi/(sinsize div 2));
  for loop:=0 to sinsize do stab[loop]:=sin(loop*pi/(sinsize div 2));

  loadMIES;
  frames:=0;

  x:=0;
  y:=0;
  z:=0;

  blurframes:=0;
  loppu:=false;
  loadPAL('pal1.pal');
  repeat
    flip(miesseg,virseg);
    if nosound then
    inc(frames);
    if frames>gap then begin
      if male<2 then loadMIES else loppu:=true;
      frames:=0;
    end else begin
      get_module_status(trackstatus);
      if (trackstatus[0]=$16)and(male=1) then loadMIES;
      if trackstatus[0]=$17 then loppu:=true;
    end;
    retrace;
    flip(virseg,vidseg);
  until (keypressed)or(loppu);
  freemem(virscr,320*200);
  freemem(miesscr,320*200);
end;

end.

