#include "kernel.h"
#include <sys/types.h>
#include <sys/unistd.h>

//#define DEBUG_KERNEL_Initialize
//#define DEBUG_KERNEL_Key

CKernel::CKernel( void )
{
    FileSystem = new CFileSystem();
    ModuleManager = new CModuleManager();

    Initialize();
}

CKernel::~CKernel( void )
{
    Finalize();

    delete ModuleManager;
    delete FileSystem;
}

void CKernel::Initialize( void )
{
    CConfig config_file;
    CString parameter_value;
    CString file_path;

#ifdef DEBUG_KERNEL_Initialize
    pspDebugScreenInit();    
    pspDebugScreenPrintf( "booting kernel_1_0_0 ...\n" );

    pspDebugScreenPrintf( "loading kernel parameters ..." );
#endif

    if( config_file.Open( "kernel_1_0_0.params" ) )
    {        
        if( config_file.GetParameterValue( parameter_value, "ENVIRONMENT_PATH" ) )
            KERNEL_FileSystem().SetEnvironmentPath( parameter_value );

        config_file.Close();

#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " OK\n" );
#endif
    }
    else
    {
#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " FAILED\n" );
#endif
    }

#ifdef DEBUG_KERNEL_Initialize
    pspDebugScreenPrintf( "loading system config ..." );
#endif

    if( KERNEL_FileSystem().FindFullPath( file_path, "etc/system.conf" )
        && config_file.Open( file_path )
        )
    {
        if( config_file.GetParameterValue( parameter_value, "PATH" ) )
        {
            CString path;
            CText path_list;
            int32 path_index( NONE );

            while( parameter_value.GetNextWord( path, path_index, true ) )
                path_list.AddLine( path );
            
            KERNEL_FileSystem().SetPathList( path_list );
        }
        
        config_file.Close();

#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " OK\n" );
#endif
    }
    else
    {
#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " FAILED\n" );
#endif
    }

#ifdef DEBUG_KERNEL_Initialize
    pspDebugScreenPrintf( "loading modules ...\n" );
#endif

    if( KERNEL_FileSystem().FindFullPath( file_path, "etc/modules.conf" )
        && config_file.Open( file_path ) )
    {
        const CText & module_name_array = config_file.GetTextFileData();
        uint32 module_index;
        CString module_name;

        for( module_index = 0 ; module_index < module_name_array.GetLinesCount() ; module_index ++ )
        {
           
            if( KERNEL_FileSystem().FindFullPath( module_name, module_name_array.GetLine( module_index ) ) )
            {
#ifdef DEBUG_KERNEL_Initialize
                int free_mem = sceKernelMaxFreeMemSize() - 1*1024*1024;

                pspDebugScreenPrintf( "( free memory: %d bytes)\n", free_mem );

                pspDebugScreenPrintf( "     %s .. ", module_name.GetBuffer() );
#endif

                if( !ModuleManager->StartModule( module_name.GetFileName(), module_name.GetFilePath() ) )
                {
#ifdef DEBUG_KERNEL_Initialize
                    pspDebugScreenPrintf( "FAILED\n" );
#endif
                }
                else
                {
#ifdef DEBUG_KERNEL_Initialize
                    pspDebugScreenPrintf( "OK\n" );
#endif
                }
            }
        }

        config_file.Close();

#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " OK\n" );
#endif
    }
    else
    {
#ifdef DEBUG_KERNEL_Initialize
        pspDebugScreenPrintf( " FAILED\n" );
#endif
    }
}

void CKernel::Finalize( void )
{
}

void CKernel::Update( void )
{    
    KERNEL_ModuleManager().Update();

#ifdef DEBUG_KERNEL_Key
    uint32 key_code;
    int32 alt_key, ctrl_key, shift_key;
    
    key_code = LIBS_ModuleImporter().KEYBOARD_GetKeyJustPressed();

    if( key_code != NONE )
    {
        pspDebugScreenPrintf( "key\n" );
    }
#endif
}
