#include "text.h"

CText::CText( void ) :
    LineArray()
{
}

CText::CText( const CText & text ) :
    LineArray()
{
    this->operator =( text );
}

CText::~CText( void )
{
    SetEmpty();
}

const CString & CText::operator []( ulong index ) const
{
    return GetLine( index );
}

CString & CText::operator []( ulong index )
{
    return GetLine( index );
}

const CText & CText::operator =( const CText & text )
{
    SetEmpty();
    
    for( ulong index = 0 ; index < text.GetLinesCount() ; index ++ )
        AddLine( text.GetLine( index ) );
        
    return *this;
}

const CText & CText::operator +=( const CText & text )
{
    for( ulong index = 0 ; index < text.GetLinesCount() ; index ++ )
        AddLine( text.GetLine( index ) );

    return *this;
}

CText CText::operator +( const CText & text ) const
{
    CText output( *this );
    output += text;
    
    return output;
}

ulong CText::GetLinesCount( void ) const
{
    return LineArray.GetSize();
}

const CString & CText::GetLine( ulong line_index ) const
{
    return **LineArray[ line_index ];
}

CString & CText::GetLine( ulong line_index )
{
    return **LineArray[ line_index ];
}

int32 CText::FindLineBeginningWithWord( CString word ) const
{
    int32 index;

    for( index = 0 ; index < ( int32 ) GetLinesCount() ; index ++ )
    {
        if( GetLine( index ).IsPrefixed( word ) )
            return index;
    }

    return NONE;
}

bool CText::GetNextWord( CString & word, int32 & line_index, int32 & word_index ) const
{
    if( line_index == NONE )
    {
        if( GetLinesCount() == 0 )
            return false;

        line_index = 0;
    }

    if( line_index >= ( int32 ) GetLinesCount() )
        return false;

    while( !GetLine( line_index ).GetNextWord( word, word_index ) )
    {
        line_index ++;
        word_index = NONE;

        if( line_index >= ( int32 ) GetLinesCount() )
            return false;
    }
    
    return true;
}

void CText::AddLine( const CString & line )
{
    LineArray.Add( new CString( line ) );
}

void CText::SetEmpty( void )
{
    for( ulong line_index = 0 ; line_index < LineArray.GetSize() ; line_index ++ )
    {
        delete *LineArray[ line_index ];
        *LineArray[ line_index ] = 0;
    }

    LineArray.Erase();
}

void CText::SetFromTextBuffer( const char * text_buffer )
{
    CString * line = new CString();
    ulong size = ( ulong ) strlen( text_buffer );

    SetEmpty();
    
    for( ulong index = 0 ; index < size ; index ++ )
    {
        if( text_buffer[ index ] != '\n' && text_buffer[ index ] != '\r' )
            *line += text_buffer[ index ];
        
        if( text_buffer[ index ] == '\n' || index == size - 1 )
        {
            LineArray.Add( line );
            line = new CString();
        }
    }
    
    delete line;
}

char * CText::GetTextBuffer( void ) const
{
    char * buffer = NULL;
    ulong buffer_size = 0;
    ulong buffer_index = 0;

    for( ulong index = 0 ; index < LineArray.GetSize() ; index ++ )
    {
        buffer_size += (*LineArray[ index ])->GetLength() + 1;
        
        if( buffer == NULL )
            buffer = ( char * ) malloc( buffer_size );
        else
            buffer = ( char * ) realloc( buffer, buffer_size );
        
        memcpy( buffer + buffer_index, (*LineArray[ index ])->GetBuffer(), (*LineArray[ index ])->GetLength() );
        
        if( index < LineArray.GetSize() - 1 )
            buffer[ buffer_size - 1 ] = '\n';
        else
            buffer[ buffer_size - 1 ] = NULL_CHAR;

        buffer_index = buffer_size;
    }

    return buffer;
}

void CText::RemoveFirstLine( void )
{
    RemoveLine( 0 );
}

void CText::RemoveLine( ulong index )
{
    delete *LineArray[ index ];
    *LineArray[ index ] = NULL;
    LineArray.Remove( index );
}
