#ifndef _MODULE_HELPERS_H_
    #define _MODULE_HELPERS_H_

    #include "libs_defs.h"
    #include <pspsdk.h>
    #include "string/string.h"

    bool MODULE_HELPERS_IsThreadRunning( SceUID thread_id );
    void MODULE_HELPERS_WaitForModuleStart( SceUID module_id );
    void MODULE_HELPERS_WaitForModuleStop( SceUID module_id );
    bool MODULE_HELPERS_IsModuleRunning( SceUID module_id );
    SceModule * MODULE_HELPERS_GetModuleFromID( SceUID module_id );
    
    bool MODULE_HELPERS_FindModuleByName( SceModule ** module, CString & lib_name, CString module_name );
    u32 * MODULE_HELPERS_FindExportedNidAddr( CString module_name, u32 nid );

    u32 * MODULE_HELPERS_FindExportedNidAddr( SceModule * mod, const char * lib, u32 nid );
    u32 * MODULE_HELPERS_ModifyExportedFunction( SceModule * mod, const char * lib, u32 nid, u32 * newProcAddr );
    
#endif
