
    template< class type >
    CList< type >::CList( void ) : CArray()
    {
        SetItemSize( sizeof( type ) );
    }

    template< class type >
    CList< type >::~CList( void )
    {
        Erase();
    }

    template< class type >
    type * CList< type >::operator [] ( ulong index ) const
    {
        return ( ( type * ) ArrayGetItem( index ) );
    }

    template< class type >
    void CList< type >::Resize( ulong size )
    {
        ArrayResize( size );
    }

    template< class type >
    void CList< type >::Reserve( ulong size )
    {
        ArrayReserve( size );
    }

    template< class type >
    ulong CList< type >::Add( type item )
    {
        return ArrayAddItem( ( void * ) &item );
    }

    template< class type >
    ulong CList< type >::Insert( type item, ulong index )
    {
        ArrayInsertItem( index, ( void * ) &item );

        return index;
    }

    template< class type >
    void CList< type >::Remove( ulong index )
    {
        ArrayRemoveItem( index );
    }

    template< class type >
    void CList< type >::RemoveItem( type item )
    {
        if( GetSize() == 1 )
        {
            Erase();

            return;
        }

        for( ulong index = 0 ; index < GetSize() ; index ++ )
            if( ( *this )[ index ] == item )
            {   
                Remove( index );

                break;
            }
    }

    template< class type >
    void CList< type >::Erase( void )
    {
        ArrayErase();
    }

    template< class type >
    void CList< type >::RemoveAll( void )
    {
        ArrayRemoveAllItems();
    }
