#ifndef _KONSOLE_DEFS_H_
    #define _KONSOLE_DEFS_H_    

    #include <pspkernel.h>
    #include <pspdebug.h>
    #include <pspdisplay.h>
    #include <pspctrl.h>
    #include <stdlib.h>
    #include <string.h>

    #define KONSOLE_ConsoleCount    5

    // types

    #define real        float
    #define real64      double
    #define uint8       unsigned char
    #define uint16      unsigned short
    #define uint32      unsigned int
    #define ulong       unsigned long
    #define ulong_ptr   ULONG_PTR
    #define int8        signed char
    #define int16       short
    #define int32       int
    #define long        long
    #define char        char
    #define bit         uint32
    #define enum        enum
    
    #undef NULL
    #define NULL    0
    #define NULL_CHAR   '\0'
    #define NONE -1
        
    // macros

    #define KONSOLE_SingletonCpp( _class_ ) \
        _class_ * _class_::Instance = NULL; \
        _class_ & _class_::GetInstance( void ) { return *Instance; } \
        bool _class_::HasInstance( void ) { return ( Instance != NULL ); }

    #define KONSOLE_SingletonH( _class_ ) \
        private: static _class_ * Instance; \
        public: static _class_ & GetInstance( void ); \
        public: static bool HasInstance( void );

    #define KONSOLE_CreateSingleton( _singleton_ ) \
        if( Instance != NULL ) {}\
        else Instance = this;

    #define KONSOLE_DestroySingleton( _singleton_ ) \
        Instance = NULL;
#endif
