#include "konsole.h"
#include "time/time.h"

CKeyboard * Keyboard;
CScreen * Screen;
CList< CConsole * > ConsoleArray;
CCommandManager * CommandManager;

PSP_MODULE_INFO( "konsole", 0x1000, 1, 1 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 256 );

int CallbackExit( int arg1, int arg2, void *common );
int CallbackThread( SceSize args, void *argp );
int SetupCallbacks( void );

void KONSOLE_ActivateConsole( uint32 console_index )
{
    KONSOLE_ActiveConsole = *ConsoleArray[ console_index ];
}

int main( int argc, char **argv ) 
{ 
    ulong console_index;
    KONSOLE_RunningModuleID = NONE;

    SetupCallbacks();

    KONSOLE_IsHasToQuit = false;

    Keyboard = new CKeyboard();
    
    if( Keyboard->Initialize() )
    {        
        Screen = new CScreen();
        Screen->Create();

        CommandManager = new CCommandManager();

        for( console_index = 0 ; console_index < KONSOLE_ConsoleCount ; console_index ++ )
            ConsoleArray.Add( new CConsole() );

        KONSOLE_ActiveConsole = *ConsoleArray[ 0 ];
       
        while( !KONSOLE_IsHasToQuit )
        {
            KONSOLE_Keyboard().Update();

            if( KONSOLE_RunningModuleID >= 0 )
            {
               /* if( !sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) )
                {
                    KONSOLE_RunningModuleID = NONE;
                }
                else*/
                {
                    sceKernelDelayThread( 1000 );
                }

                if( KONSOLE_Keyboard().IsKeyPressed( KEY_SPACE ) )
                {
                  //  SceModule * mod;

                  //  while( ( mod = sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) ) )
                    {
                        sceKernelStopModule( KONSOLE_RunningModuleID, 0, NULL, NULL, NULL );
                        
/*
                        while( sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) )
                        {
                        }
*/
                        sceKernelUnloadModule( KONSOLE_RunningModuleID );
                    //    KONSOLE_RunningModuleID = NONE;
                    }

                 //   KONSOLE_RunningModuleID = NONE;
                }
            }
            else
            {
                KONSOLE_Screen().Update();
                KONSOLE_ActiveConsole->Update();
            }
        }
        
        for( console_index = 0 ; console_index < KONSOLE_ConsoleCount ; console_index ++ )
            delete *ConsoleArray[ console_index ];

        delete CommandManager;

        Screen->Destroy();
        delete Screen;
        Keyboard->Finalize();
    }

    delete Keyboard;

    sceKernelExitGame();

    return 0;
}

int CallbackExit( int arg1, int arg2, void *common )
{/*
    if( KONSOLE_RunningModuleID >= 0 )
    {
        SceModule * mod;

        while( ( mod = sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) ) )
        {
            sceKernelStopModule( mod->modid, 0, NULL, NULL, NULL );
            sceKernelUnloadModule( mod->modid );
            KONSOLE_ActiveConsole->Write("LOL");
        }

        KONSOLE_ActiveConsole->Write("OK");

        KONSOLE_RunningModuleID = 0;

        return 0;
    }
*/
    ulong console_index;

    for( console_index = 0 ; console_index < KONSOLE_ConsoleCount ; console_index ++ )
        delete *ConsoleArray[ console_index ];

    delete CommandManager;

    Screen->Destroy();
    delete Screen;
    Keyboard->Finalize();
    delete Keyboard;

    sceKernelExitGame();

    return 0;
}

int CallbackThread( SceSize args, void *argp )
{
    int cbid;

    cbid = sceKernelCreateCallback( "Exit Callback", CallbackExit, NULL );
    sceKernelRegisterExitCallback( cbid );
    sceKernelSleepThreadCB();

    return 0;
}

int SetupCallbacks( void )
{
    int thid = 0;

    thid = sceKernelCreateThread( "update_thread", CallbackThread, 0x11, 0xFA0, 0, 0 );

    if( thid >= 0 )
        sceKernelStartThread( thid, 0, 0 );

    return thid;
}

