#ifndef _KONSOLE_FONT_H_
    #define _KONSOLE_FONT_H_

    #include "konsole_defs.h"
    #include "list\list.h"
    #include "font_glyph.h"

    class CFont
    {      
    public:

        CFont( void );
        ~CFont( void );

        uint16 GetHeight( void ) const;
        const CFontGlyph * GetGlyph( uint32 character_code ) const;
        CFontGlyph * GetGlyph( uint32 character_code );
        uint32 GetGlyphCount( void ) const;

        void Create( char * font_file_name );
        void Destroy( void );

    private:

        CList< CFontGlyph * > GlyphArray;
        uint16 Height;
        uint16 WidthBytes;
        uint8 FirstCharacterCode;
        uint8 LastCharacterCode;
    };
#endif

