#include "command/list/list.h"
#include "konsole.h"

CCommandList::CCommandList( void ) :
    CCommand( "ls" )
{
}


CCommandList::~CCommandList( void )
{
}

bool CCommandList::Execute( const CString & command_line, const CString & path, CConsole & console )
{
    int directory;
    uint32 directory_count( 0 );
    uint32 file_count( 0 );

    directory = sceIoDopen( path.GetBuffer() );

    if( directory <= 0 )
    {
        console.Write( "Unexpected error" );
    }
    else
    {
        SceIoDirent item;

        memset( &item, 0, sizeof( item ) );

        console.Write( "" );

        while( sceIoDread( directory, &item ) > 0 )
        {
            if( item.d_stat.st_attr & FIO_SO_IFDIR )
            {
                if( item.d_name[ 0 ] != '.' )
                {
                    console.Write( CString( "/%s", item.d_name ) );
                    directory_count ++;
                }
            }
            else
            {
                console.Write( CString( "%s", item.d_name ) );
                file_count ++;
            }
        }

        sceIoDclose( directory );

        console.Write( "" );
        console.Write( CString( "( %i directories, %i files )", directory_count, file_count ) );
        console.Write( "" );
    }

    return true;
}
