#include "command/command_manager.h"
#include "console/console.h"
#include "konsole.h"

#include "command/exit/exit.h"
#include "command/echo/echo.h"
#include "command/list/list.h"
#include "command/chdir/chdir.h"
#include "command/clear/clear.h"
#include "command/run/run.h"

#define REGISTER_COMMAND( _class_ ) \
    CommandArray.Add( new _class_() ); \

KONSOLE_SingletonCpp( CCommandManager );

CCommandManager::CCommandManager( void )
{
    KONSOLE_CreateSingleton( CCommandManager );

    REGISTER_COMMAND( CCommandExit );
    REGISTER_COMMAND( CCommandEcho );
    REGISTER_COMMAND( CCommandList );
    REGISTER_COMMAND( CCommandChdir );
    REGISTER_COMMAND( CCommandClear );
    REGISTER_COMMAND( CCommandRun );
}

CCommandManager::~CCommandManager( void )
{
    ulong command_index;

    KONSOLE_DestroySingleton( CCommandManager );

    for( command_index = 0 ; command_index < CommandArray.GetSize() ; command_index ++ )
    {
        delete *CommandArray[ command_index ];
        *CommandArray[ command_index ] = NULL;
    }
}

bool CCommandManager::Execute( const CString & command_line, const CString & path, CConsole & console )
{
    ulong command_index;
    int32 parameter_index( NONE );
    CString main_command;
    CString parameters;

    if( command_line.GetNextWord( main_command, parameter_index ) )
    {
        parameters = command_line;
        parameters.RemoveFirstWord();

        for( command_index = 0 ; command_index < CommandArray.GetSize() ; command_index ++ )
        {
            if( ( *CommandArray[ command_index ] )->GetName() == main_command )
                return ( *CommandArray[ command_index ] )->Execute( parameters, path, console );
        }
    }

    return false;
}
