#include "kexplo.h"



HWND  g_hWnd;									
HDC   g_hDC;								
HGLRC g_hRC;					
HINSTANCE g_hInstance;				
DWORD dwStyle = NULL;

bool	active=TRUE;	
bool	keys[256];


PFNGLFOGCOORDFEXTPROC			glFogCoordfEXT			= NULL;

PFNGLMULTITEXCOORD1FARBPROC		glMultiTexCoord1fARB	= NULL;
PFNGLMULTITEXCOORD2FARBPROC		glMultiTexCoord2fARB	= NULL;
PFNGLMULTITEXCOORD3FARBPROC		glMultiTexCoord3fARB	= NULL;
PFNGLMULTITEXCOORD4FARBPROC		glMultiTexCoord4fARB	= NULL;
PFNGLACTIVETEXTUREARBPROC		glActiveTextureARB		= NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC	glClientActiveTextureARB= NULL;	
GLint maxTexelUnits = 1;



void Error(char *txt)
{
	MessageBox(NULL,txt,"-= Error =-",MB_OK);
}


int Init_Winapi(HWND hWnd)									
{
	g_hWnd = hWnd;									
	GetClientRect(g_hWnd, &g_rRect);				
	InitializeOpenGL(g_rRect.right, g_rRect.bottom);
	
	glShadeModel(GL_SMOOTH);							
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);				
	glClearDepth(1.0f);									
	glEnable(GL_DEPTH_TEST);							
	glDepthFunc(GL_LESS);								
	glEnable(GL_TEXTURE_2D);							
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	

	K_EXIT = false;

	if(initMultitexture()==false) return false;

	return TRUE;
}





HWND CreateMyWindow(LPSTR strWindowName, int width, int height, HINSTANCE hInstance)
{
	HWND hWnd;
	WNDCLASS wndclass;
	
	memset(&wndclass, 0, sizeof(WNDCLASS));				
	wndclass.style = CS_HREDRAW | CS_VREDRAW| CS_OWNDC;	

	wndclass.lpfnWndProc = WinProc;						

	wndclass.hInstance = hInstance;						
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);		
	wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW+2);	
	wndclass.lpszClassName = "3DKexplo";			

	RegisterClass(&wndclass);							
	
	if(!dwStyle)									
		dwStyle = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
	
	g_hInstance = hInstance;						

	RECT rWindow;
	rWindow.left	= 0;								
	rWindow.right	= width;							
	rWindow.top	    = 0;								
	rWindow.bottom	= height;							

	AdjustWindowRect( &rWindow, dwStyle, false);		

	hWnd = CreateWindow("3DKexplo", strWindowName, dwStyle, 0, 0, rWindow.right  - rWindow.left, rWindow.bottom - rWindow.top, NULL, NULL, hInstance, NULL);

	if(!hWnd) 
		return NULL;								
	
	ShowWindow(hWnd, SW_SHOWNORMAL);					
	UpdateWindow(hWnd);								

	SetFocus(hWnd);										

	WActive = true;

	return hWnd;
}



bool bSetupPixelFormat(HDC hdc) 
{ 
    PIXELFORMATDESCRIPTOR pfd; 
    int pixelformat; 
	int pixf;

	pixf = 16;

    pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);		
    pfd.nVersion = 1;									
													
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER; 
    pfd.dwLayerMask = PFD_MAIN_PLANE;				
    pfd.iPixelType = PFD_TYPE_RGBA;					
    pfd.cColorBits = pixf;					
    pfd.cDepthBits = pixf;						
    pfd.cAccumBits = 0;									
    pfd.cStencilBits = 0;								
 
	if ( (pixelformat = ChoosePixelFormat(hdc, &pfd)) == FALSE ) 
    { 
		Error("Pixel Format unsupported");
        return FALSE; 
    } 
 
	if (SetPixelFormat(hdc, pixelformat, &pfd) == FALSE) 
    { 
        Error("Pixel Format unsupported");
        return FALSE; 
    } 
 
    return TRUE;										
}

void SizeOpenGLScreen(int width, int height)			
{
	if (height==0)										
	{
		height=1;										
	}

	glViewport(0,0,width,height);						
	glMatrixMode(GL_PROJECTION);						
	glLoadIdentity();									
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height, .5f ,2000.0f);

	glMatrixMode(GL_MODELVIEW);						
	glLoadIdentity();								
}


void InitializeOpenGL(int width, int height) 
{  
    g_hDC = GetDC(g_hWnd);								

	if (!bSetupPixelFormat(g_hDC))						
        PostQuitMessage (0);							

    g_hRC = wglCreateContext(g_hDC);					
    wglMakeCurrent(g_hDC, g_hRC);						

	SizeOpenGLScreen(width, height);					
}



void Exit_Winapi()
{
	if (g_hRC)											
	{
		wglMakeCurrent(NULL, NULL);						
		wglDeleteContext(g_hRC);							
	}
	
	if (g_hDC) 
		ReleaseDC(g_hWnd, g_hDC);						

	UnregisterClass("3DKexplo", g_hInstance);		
	
	DestroyWindow(g_hWnd);
}







inline int rnd(int max)
{ 
	return rand() % max;
}



float vabs(float n)
{
	if(n<0.) return-n;
	else return n;
}




bool isInString(char *string, const char *search) {
	int pos=0;
	int maxpos=strlen(search)-1;
	int len=strlen(string);	
	char *other;
	for (int i=0; i<len; i++) {
		if ((i==0) || ((i>1) && string[i-1]=='\n')) {				
			other=&string[i];			
			pos=0;													
			while (string[i]!='\n') {								
				if (string[i]==search[pos]) pos++;					
				if ((pos>maxpos) && string[i+1]=='\n') return true; 
				i++;
			}			
		}
	}	
	return false;													
}


bool initMultitexture(void) {
	char *extensions;	
	extensions=strdup((char *) glGetString(GL_EXTENSIONS));			
	int len=strlen(extensions);
	for (int i=0; i<len; i++)										
		if (extensions[i]==' ') extensions[i]='\n';

	if (isInString(extensions,"GL_ARB_multitexture")				
		&& isInString(extensions,"GL_EXT_texture_env_combine"))		
	{	
		glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB,&maxTexelUnits);
		glMultiTexCoord1fARB	= (PFNGLMULTITEXCOORD1FARBPROC)		wglGetProcAddress("glMultiTexCoord1fARB");
		glMultiTexCoord2fARB	= (PFNGLMULTITEXCOORD2FARBPROC)		wglGetProcAddress("glMultiTexCoord2fARB");
		glMultiTexCoord3fARB	= (PFNGLMULTITEXCOORD3FARBPROC)		wglGetProcAddress("glMultiTexCoord3fARB");
		glMultiTexCoord4fARB	= (PFNGLMULTITEXCOORD4FARBPROC)		wglGetProcAddress("glMultiTexCoord4fARB");
		glActiveTextureARB		= (PFNGLACTIVETEXTUREARBPROC)		wglGetProcAddress("glActiveTextureARB");
		glClientActiveTextureARB= (PFNGLCLIENTACTIVETEXTUREARBPROC)	wglGetProcAddress("glClientActiveTextureARB");		

		glFogCoordfEXT	= (PFNGLFOGCOORDFEXTPROC) wglGetProcAddress("glFogCoordfEXT");

		if(!glFogCoordfEXT)
		{
			Error("Volumetric Fog unsupported");
			PostQuitMessage(0);
		}

		return true;
	}
	return false;
}





LRESULT CALLBACK WinProc(HWND hWnd,UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    LONG    lRet = 0; 
    PAINTSTRUCT    ps;
	bool bUpdate = false;

    switch (uMsg)
	{ 
	    case WM_SIZE:
			switch (wParam)												
			{
				case SIZE_MINIMIZED:
					WActive = false;
					break;
				
				case SIZE_MAXIMIZED:
				case SIZE_RESTORED:
					WActive = true;
					SizeOpenGLScreen(LOWORD(lParam),HIWORD(lParam));
					break;
			}
			break;

		case WM_PAINT:										
			BeginPaint(hWnd, &ps);									
			EndPaint(hWnd, &ps);							
			break;

		case WM_CLOSE:										
			PostQuitMessage(0);								
			K_EXIT = true;
			break; 

		default:										
			lRet = DefWindowProc (hWnd, uMsg, wParam, lParam); 
			break; 
	} 

    return lRet;										
}




