#ifndef _FILE_H_
#define _FILE_H_


#define TRI_BACK  0
#define TRI_FRONT 1
#define TRI_LEFT  2
#define TRI_RIGHT 3
#define TRI_TOP   4



// Rayon du bloc reprsentatif d'un fichier
extern float Taille_Fichier;



// Structure d'un fichier (afin de mmoriser le plus important uniquement)
typedef struct {
	char *name;
	Attrib att;
	SYSTEMTIME born;
	SYSTEMTIME writ;
	SYSTEMTIME seen;
	unsigned long size;
	float y;
	CVertex col;
} Fichier;




// Affichage du bloc reprsentatif d'un fichier
void Draw_Fichier(Fichier *fich, float x, float z, float scale, float deg, int tri[5], bool sel);

// Affichage des attributs d'un fichier
void Draw_Attrib(Fichier *fich, float x, float z, float deg, float r);
void Draw_Name(Fichier *fich, float x, float z, float deg, float r);

// Affichage complet d'un fichier
void Draw_File(Fichier *fich, float x, float z, float scale, float deg, int tri[5], bool sel);


void Dw_Back(float y, float s, float d, bool sel, CVertex c);
void Dw_Front(float y, float s, float d, bool sel, CVertex c);
void Dw_Left(float y, float s, float d, bool sel, CVertex c);
void Dw_Right(float y, float s, float d, bool sel, CVertex c);
void Dw_Top(float y, float s, float d, bool sel, CVertex c);

void Set_Fog(float y, float d);
void SetBlend(float deg, CVertex c);

#endif
