#include "kexplo.h"


//===================================================================
//		Constructor
//===================================================================

CVertex::CVertex(void)
{
	x = 0.0f;
	y = 0.0f;
	z = 0.0f;
}

CVertex::CVertex(float num)
{
	x = num;
	y = num;
	z = num;
}

CVertex::CVertex(float X, float Y, float Z)
{
	x = X;
	y = Y;
	z = Z;
}



//===================================================================
//		Destructor
//===================================================================

CVertex::~CVertex(void)
{
	x = 0.0f;
	y = 0.0f;
	z = 0.0f;
}


//===================================================================
//		Operator =
//===================================================================

void CVertex::operator = (float num)
{
	x = num;
	y = num;
	z = num;
}

void CVertex::operator = (CVertex vVector)
{
	x = vVector.x;
	y = vVector.y;
	z = vVector.z;
}


//===================================================================
//		Operator +
//===================================================================

CVertex CVertex::operator + (float num)
{
	return CVertex(x + num, y + num, z + num);
}

CVertex CVertex::operator + (CVertex vVector)
{
	return CVertex(x + vVector.x, y + vVector.y, z + vVector.z);
}

void CVertex::operator += (float num)
{
	x += num;
	y += num;
	z += num;
}

void CVertex::operator += (CVertex vVector)
{
	x += vVector.x;
	y += vVector.y;
	z += vVector.z;
}


//===================================================================
//		Operator -
//===================================================================

CVertex CVertex::operator - (float num)
{
	return CVertex(x - num, y - num, z - num);
}

CVertex CVertex::operator - (CVertex vVector)
{
	return CVertex(x - vVector.x, y - vVector.y, z - vVector.z);
}

void CVertex::operator -= (float num)
{
	x -= num;
	y -= num;
	z -= num;
}

void CVertex::operator -= (CVertex vVector)
{
	x -= vVector.x;
	y -= vVector.y;
	z -= vVector.z;
}


//===================================================================
//		Operator *
//===================================================================

CVertex CVertex::operator * (float num)
{
	return CVertex(x * num, y * num, z * num);
}

CVertex CVertex::operator * (CVertex vVector)
{
	return CVertex(x * vVector.x, y * vVector.y, z * vVector.z);
}

void CVertex::operator *= (float num)
{
	x *= num;
	y *= num;
	z *= num;
}

void CVertex::operator *= (CVertex vVector)
{
	x *= vVector.x;
	y *= vVector.y;
	z *= vVector.z;
}


//===================================================================
//		Operator /
//===================================================================

CVertex CVertex::operator / (float num)
{
	return CVertex(x / num, y / num, z / num);
}

CVertex CVertex::operator / (CVertex vVector)
{
	return CVertex(x / vVector.x, y / vVector.y, z / vVector.z);
}

void CVertex::operator /= (float num)
{
	x /= num;
	y /= num;
	z /= num;
}

void CVertex::operator /= (CVertex vVector)
{
	x /= vVector.x;
	y /= vVector.y;
	z /= vVector.z;
}


//===================================================================
//		Operator == , !=
//===================================================================

bool CVertex::operator == (CVertex vVector)
{
	return ((x == vVector.x) && (y == vVector.y) && (z == vVector.z));
}

bool CVertex::operator != (CVertex vVector)
{
	return (!((x == vVector.x) && (y == vVector.y) && (z == vVector.z)));
}








//===================================================================
//		ASM Vertexes transformations
//===================================================================

#pragma warning(disable:4035) //disable "no return value" warning


float ASMDotProduct(CVertex & a_cVec1, CVertex & a_cVec2)
{
	__asm{
		mov eax,[a_cVec1]
		mov edx,[a_cVec2]

		fld dword ptr [eax]//x1
		fmul dword ptr [edx]//x1*x2
		fld dword ptr [eax+4]//y1 x1*x2
		fmul dword ptr [edx+4]//y1*y2 x1*x2
		fld dword ptr [eax+8]//z1 y1*y2 x1*x2
		fmul dword ptr [edx+8]//z1*z2 y1*y2 x1*x2
		faddp st(1),st(0)//z1*z2+y1*y2 x1*x2
		faddp st(1),st(0)
	};
}


void ASMCrossProduct(CVertex & a_vP0, CVertex & a_vP1, CVertex & a_vDest)
{
	__asm{
		mov eax,[a_vP0]
		mov edx,[a_vP1]

		fld dword ptr [eax]
		fld dword ptr [edx]
		fld dword ptr [edx+4]
		fld dword ptr [eax+4]
		fld dword ptr [eax+8]
		fld dword ptr [edx+8]

		mov eax,[a_vDest]

		//z2 z1 y1 y2 x2 x1
		//0  1  2  3  4  5

		//y1*z2-y2*z1
		fld st(2)
		fmul st(0),st(1)
		fld st(4)
		fmul st(0),st(3)
		fsubp st(1),st(0)
		fstp dword ptr [eax]

		//x2*z1-z2*x1 (elim z1, z2)
		fmul st(0),st(5)
		fstp dword ptr [eax+4]
		fmul st(0),st(3)
		fsub dword ptr [eax+4]
		fstp dword ptr [eax+4]

		//y1 y2 x2 x1
		//0  1  2  3
		//y2*x1-x2*y1 (elim x1, x2, y1, y2)
		fmulp st(2),st(0)
		fmulp st(2),st(0)
		fsubp st(1),st(0)
		fstp dword ptr [eax+8]
	};
}


void ASMComputeNormal(CVertex & a_cVec0, CVertex & a_cVec1, CVertex & a_cVec2, CVertex & a_vDest)
{
	CVertex l_vA;
	CVertex l_vB;//<-- make these static or float[3]?
	float fConstMul=-1.0f;

	__asm{
		lea eax,[l_vA]
		mov edx,dword ptr [a_cVec0]
		mov ecx,dword ptr [a_cVec1]

		fld dword ptr [edx]
		fsub dword ptr [ecx]
		fstp dword ptr [eax]
		fld dword ptr [edx+4]
		fsub dword ptr [ecx+4]
		fstp dword ptr [eax+4]
		fld dword ptr [edx+8]
		fsub dword ptr [ecx+8]
		fstp dword ptr [eax+8]

		lea eax,[l_vB]
		mov edx,dword ptr [a_cVec2]

		fld dword ptr [ecx]
		fsub dword ptr [edx]
		fstp dword ptr [eax]
		fld dword ptr [ecx+4]
		fsub dword ptr [edx+4]
		fstp dword ptr [eax+4]
		fld dword ptr [ecx+8]
		fsub dword ptr [edx+8]
		fstp dword ptr [eax+8]

		mov edx,dword ptr [a_vDest]
		push edx
		push eax
		lea eax,[l_vA]
		push eax

		call ASMCrossProduct
		add esp,0xc

		fld dword ptr [fConstMul]

		mov eax,[a_vDest]

		fld dword ptr [eax+8]
		fld dword ptr [eax+4]
		fld dword ptr [eax]

		//p_fVec[0] p_fVec[1] p_fVec[2] -1
		fld st(2)
		fmul st(0),st(0)
		fld st(2)
		fmul st(0),st(0)
		fld st(2)
		fmul st(0),st(0)
		faddp st(2),st(0)
		faddp st(1),st(0)
		//p_fVec[0]*p_fVec[0]+p_fVec[1]*p_fVec[1]+p_fVec[2]*p_fVec[2] p_fVec[2] p_fVec[1] p_fVec[0] -1

		fstp dword ptr [eax]
		mov edx,dword ptr [eax] //<-- i really hate this setup. the CPU cant access the FPU. must go through mem
		push edx

		call sqrtf
		add esp,4

		//sqrt(p_fVec[0]*p_fVec[0]+p_fVec[1]*p_fVec[1]+p_fVec[2]*p_fVec[2]) p_fVec[0] p_fVec[1] p_fVec[2] -1
		fmulp st(4),st(0)

		mov eax,[a_vDest]

		//p_fVec[2] p_fVec[1] p_fVec[0] -sqrt(p_fVec[0]*p_fVec[0]+p_fVec[1]*p_fVec[1]+p_fVec[2]*p_fVec[2])
		fdiv st(0),st(3)
		fstp dword ptr [eax]
		fdiv st(0),st(2)
		fstp dword ptr [eax+4]

		//p_fVec[0] -sqrt(p_fVec[0]*p_fVec[0]+p_fVec[1]*p_fVec[1]+p_fVec[2]*p_fVec[2])
		fxch st(1)
		fdivp st(1),st
		fstp dword ptr [eax+8]
	};
}


float ASMAngleOfSeperation(CVertex & a_vP0,CVertex & a_vP1)
{
	float fTemp;

	__asm{
		mov eax,[a_vP0]

		//mul the vector lengths
		fld dword ptr [eax]
		fld dword ptr [eax+4]
		fld dword ptr [eax+8]

		fld st(2)
		fmul st(0),st(0)
		fld st(2)
		fmul st(0),st(0)
		fld st(2)
		fmul st(0),st(0)
		faddp st(2),st(0)
		faddp st(1),st(0)

		fstp dword ptr [fTemp]
		mov ebx,dword ptr [fTemp]
		push ebx
		call sqrtf
		add esp,4

		//sqrtf(x1*x1+y1*y1+z1*z1) z1 y1 x1

		mov edx,[a_vP1]

		fld dword ptr [edx]
		fmul st(0),st(0)
		fld dword ptr [edx+4]
		fmul st(0),st(0)
		fld dword ptr [edx+8]
		fmul st(0),st(0)
		faddp st(2),st(0)
		faddp st(1),st(0)

		fstp dword ptr [fTemp]
		mov ebx,dword ptr [fTemp]
		push ebx
		call sqrtf
		add esp,4

		mov edx,[a_vP1]

		fmulp st(1),st(0)

		//total_length z1 y1 x1
		fld dword ptr [edx]
		fmulp st(4),st(0)
		fld dword ptr [edx+4]
		fmulp st(3),st(0)
		fld dword ptr [edx+8]
		fmulp st(2),st(0)
		fstp dword ptr [fTemp]
		faddp st(2),st(0)
		faddp st(1),st(0)
		fdiv dword ptr [fTemp]

		fstp dword ptr [fTemp]
		mov eax,dword ptr [fTemp]
		push eax
		call acosf
		add esp,4
	};
}


void ASMCalculate3dRotation(float a_fPitch,float a_fYaw, CVertex & a_vPt)
{
	__asm{
		mov ebx,[a_fPitch]
		push ebx
		call cosf
		add esp,4

//		mov ebx,[a_fPitch]
		xor ebx,0x80000000//quick negate
		push ebx
		call sinf
		add esp,4

		mov ebx,[a_fYaw]
		push ebx
		call cosf
		add esp,4

//		mov ebx,[a_fYaw]
		push ebx
		call sinf
		add esp,4

		//sin(yaw) cos(yaw) sin(-pitch) cos(pitch)
		mov eax,dword ptr [a_vPt]

		fmul st(0),st(3)
		fstp dword ptr [eax]
		fmulp st(2),st(0)
		fstp dword ptr [eax+4]
		fstp dword ptr [eax+8]
	}
}







float ASMDistance(CVertex & v1, CVertex & v2)
{
	float fTemp;

	__asm{
		mov eax,[v1]
		mov edx,[v2]

		fld dword ptr [eax]		// x1
		fsub dword ptr [edx]	// x1-x2
		fmul st(0), st(0)		// (x1-x2)*(x1-x2)

		fld dword ptr [eax+4]	// y1     
		fsub dword ptr [edx+4]  // y1-y2  
		fmul st(0), st(0)		// (y1-y2)*(y1-y2)
		
		fld dword ptr [eax+8]	// z1
		fsub dword ptr [edx+8]  // z1-z2
		fmul st(0), st(0)		// (z1-z2)*(z1-z2)
		
		faddp st(1),st(0)		// (z1-z2)*(z1-z2) + (y1-y2)*(y1-y2) 
		faddp st(1),st(0)		// (z1-z2)*(z1-z2) + (y1-y2)*(y1-y2) + (y1-y2)*(y1-y2)
		

		// Calcul de la racine de tout a

		fstp dword ptr [fTemp]
		mov ebx,dword ptr [fTemp]
		push ebx
		call sqrtf
		add esp,4
	};
}


float ASMMagnitude(CVertex & v)
{
	float fTemp;

	__asm{
		mov eax,[v]
		
		fld dword ptr [eax]
		fmul st(0), st(0)
		fld dword ptr [eax+4]
		fmul st(0), st(0)
		fld dword ptr [eax+8]
		fmul st(0), st(0)

		faddp st(1),st(0)
		faddp st(1),st(0)

		fstp dword ptr [fTemp]
		mov ebx,dword ptr [fTemp]
		push ebx
		call sqrtf
		add esp,4
	};

}

